/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.dataimport.plugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class PerformanceDataImportPlugin
extends AbstractWorkflowPlugin {
    private static final String SUBMIT = "submit";
    private static final String UPDATE = "update";
    private static final String TOOLBARAP = "toolbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBARAP);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        int dataqty = (Integer)this.getModel().getValue("dataqty");
        String process = (String)this.getModel().getValue("process");
        Date start = (Date)this.getModel().getValue("range_start");
        Date end = (Date)this.getModel().getValue("range_end");
        int userAmount = (Integer)this.getModel().getValue("user_amount");
        switch (key = evt.getItemKey()) {
            case "submit": {
                this.batchSubmitAndStartProcess(dataqty, process);
                break;
            }
            case "update": {
                this.batchUpdate(start, end, userAmount);
                break;
            }
        }
    }

    private void batchSubmitAndStartProcess(int dataqty, String process) {
        String procdefid = null;
        if (process != null && "msg".equalsIgnoreCase(process)) {
            procdefid = "-1";
        } else if (process != null && process.length() > 0) {
            procdefid = PerformanceDataImportPlugin.findProcdefid(process);
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RuntimeService runtimeService = wfService.getRuntimeService();
        runtimeService.batchSubmitBill(dataqty, procdefid);
        this.getView().showSuccessNotification("successfully submit bill.");
    }

    private void batchUpdate(Date start, Date end, int userAmount) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RuntimeService runtimeService = wfService.getRuntimeService();
        runtimeService.updateForBatchAutoImport(start, end, userAmount);
    }

    private static String findProcdefid(String process) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ProcessDefinitionEntity proDefEntity = service.getRepositoryService().getLatestProcessDefinitionByKey(process);
        return proDefEntity.getId().toString();
    }
}

