/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.demo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;

public class ValidateSafeLevelWhenAuditOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        int i;
        Map variables = this.getOption().getVariables();
        String entityNumber = (String)variables.get("entitynumber");
        String businessKey = (String)variables.get("businesskey");
        Long taskId = Long.valueOf((String)variables.get("taskid"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
        int billSafeLevel = dynamicObject.getInt("safelevel");
        String nextNodeDealPersonStr = (String)this.getOption().getVariables().get("nextnodedealperson");
        ArrayList<Long> nextDealPersons = new ArrayList<Long>();
        String nodeId = null;
        if (StringUtils.isBlank((CharSequence)nextNodeDealPersonStr)) {
            List dynParticipantList = WorkflowServiceHelper.getNextUserTaskNodeByBusinessKey((String)businessKey);
            for (i = 0; i < dynParticipantList.size(); ++i) {
                Map dynParticipantMap = (Map)dynParticipantList.get(i);
                List users = (List)dynParticipantMap.get("users");
                AuditTask task = (AuditTask)dynParticipantMap.get("nextNode");
                nodeId = task.getId();
                for (DynamicObject user : users) {
                    Long userId = user.getLong("id");
                    if (nextDealPersons.contains(userId)) continue;
                    nextDealPersons.add(userId);
                }
            }
        } else {
            List nextNodeDealPersons = (List)SerializationUtils.fromJsonString((String)nextNodeDealPersonStr, List.class);
            for (i = 0; i < nextNodeDealPersons.size(); ++i) {
                String[] userIds;
                Map nextNodeDealPerson = (Map)nextNodeDealPersons.get(i);
                DynamicObject[] userIdStr = (DynamicObject[])nextNodeDealPerson.get("userIds");
                nodeId = (String)nextNodeDealPerson.get("nodeId");
                for (String userId : userIds = userIdStr.split(",")) {
                    if (nextDealPersons.contains(Long.valueOf(userId))) continue;
                    nextDealPersons.add(Long.valueOf(userId));
                }
            }
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", nextDealPersons)};
        DynamicObject[] userObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,safelevel", (QFilter[])qFilters);
        ArrayList<Long> resultUserIds = new ArrayList<Long>();
        for (DynamicObject userObject : userObjects) {
            int userSafeLevel = userObject.getInt("safelevel");
            if (userSafeLevel < billSafeLevel) continue;
            resultUserIds.add(userObject.getLong("id"));
        }
        if (resultUserIds.isEmpty()) {
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u56e0\u5bc6\u7ea7\u539f\u56e0\u627e\u4e0d\u5230\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\uff0c\u62d2\u7edd\u63d0\u4ea4", (String)"ValidateSafeLevelWhenAuditOp_0", (String)"bos-wf-unittest", (Object[])new Object[0])});
        }
        HashMap<String, String> dynParticipantMap = new HashMap<String, String>();
        dynParticipantMap.put("nodeId", nodeId);
        dynParticipantMap.put("userIds", StringUtils.join((Object[])resultUserIds.toArray(), (String)","));
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(dynParticipantMap);
        WorkflowServiceHelper.setDynPanticipant((Long)taskId, list);
    }
}

