/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.demo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.bpmn.model.Task;

public class ValidateSafeLevelWhenSubmitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        int billSafeLevel = dataEntities[0].getInt("safelevel");
        String entityNumber = "bos_devp_safelevel";
        String operation = "submit";
        IWorkflowService wfService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
        Map wfAssignPersons = wfService.getWfAssignPersons(entityNumber, operation, dataEntity);
        Boolean isAssignNextPerson = (Boolean)wfAssignPersons.get("wfAssignPersons");
        String obj = this.operateOption.getVariableValue("wfassigncallbackflag", null);
        if (isAssignNextPerson.booleanValue() && obj == null) {
            this.getOption().setVariableValue("procdefid", wfAssignPersons.get("procdefid").toString());
            this.getOption().setVariableValue("wfAssignPersons", "true");
            return;
        }
        List list = wfService.getNextUserTaskNodeByModel(dataEntity, operation, entityNumber);
        Map map = (Map)list.get(0);
        Object nextNode = map.get("nextNode");
        String nodeId = ((Task)nextNode).getId();
        DynamicObjectCollection users = (DynamicObjectCollection)map.get("users");
        if (users == null || users.isEmpty()) {
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u4e00\u6b65\u8282\u70b9\u5904\u7406\u4eba\uff0c\u62d2\u7edd\u63d0\u4ea4", (String)"ValidateSafeLevelWhenSubmitOp_0", (String)"bos-wf-unittest", (Object[])new Object[0])});
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (DynamicObject user : users) {
            userIds.add(user.getLong("id"));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", userIds)};
        DynamicObject[] userObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,safelevel", (QFilter[])qFilters);
        StringBuilder resultUserIds = new StringBuilder();
        for (DynamicObject userObject : userObjects) {
            int userSafeLevel = userObject.getInt("safelevel");
            if (userSafeLevel < billSafeLevel) continue;
            resultUserIds.append(userObject.getString("id"));
            resultUserIds.append(userObject.getString(","));
        }
        if (StringUtils.isBlank((CharSequence)resultUserIds)) {
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u56e0\u5bc6\u7ea7\u539f\u56e0\u627e\u4e0d\u5230\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\uff0c\u62d2\u7edd\u63d0\u4ea4", (String)"ValidateSafeLevelWhenSubmitOp_1", (String)"bos-wf-unittest", (Object[])new Object[0])});
        }
        String resultUserIdsStr = resultUserIds.toString().substring(0, resultUserIds.length() - 1);
        HashMap<String, String> dynParticipantMap = new HashMap<String, String>();
        dynParticipantMap.put("nodeId", nodeId);
        dynParticipantMap.put("userIds", resultUserIdsStr);
        ArrayList<HashMap<String, String>> listDynParticipant = new ArrayList<HashMap<String, String>>();
        listDynParticipant.add(dynParticipantMap);
        this.getOption().setVariableValue("dynParticipant", SerializationUtils.toJsonString(listDynParticipant));
    }
}

