/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.design.plugin.AbstractPartPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;

public class PartRelationPlugin
extends AbstractPartPlugin {
    public static final String FORMID = "wf_part_relation";
    protected static final String RELATION_TYPE = "relation_type";
    protected static final String RELATION_TYPE_PERSON = "person";
    protected static final String RELATION_TYPE_ORG = "org";
    protected static final String PANEL_PERSON = "relation_panel_2";
    protected static final String REF_PERSON = "ref_person";
    protected static final String REPORT_TYPE = "report_type";
    protected static final String PERSON_RELATION = "person_relation";
    protected static final String REF_ORG_PERSON = "ref_org_person";
    protected static final String PERSON_RELATION_SELF = "self";
    protected static final String PANEL_ORG = "relation_panel_3";
    protected static final String REF_ORG_ORG = "ref_org_org";
    protected static final String ORG_RELATION = "org_relation";
    protected static final String PANEL_REL_PARAM = "relparam_panel";
    protected static final String PARAMS_ENTRY = "paramsentry";
    protected static final String PARAMS_NAME = "paramname";
    protected static final String PARAMS_DESC = "paramdesc";
    protected static final String PARAMS_MUSTINPUT = "paramustinput";
    protected static final String PARAMS_TYPE = "paramtype";
    protected static final String PARAMS_TYPENAME = "paramtypename";
    protected static final String PARAMS_ENTITYOBJECT = "entityobject";
    protected static final String PARAMS_MAPPINGFIELD = "parammappingfield";
    protected static final String PARAMS_VALUEFORMAT = "paramvalueformat";
    protected static final String CLOSECALLBACK_EXPR = "closecallbackexpr";
    protected static final String CLOSECALLBACK_F7 = "closecallbackf7";
    protected static final String NUMBERVARIABLE = "number";
    protected static final String BOOLEANVARIABLE = "boolean";
    protected static final String STRINGVARIABLE = "String";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAMS_MAPPINGFIELD});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadReportType();
        this.init();
        this.load();
        this.setControl();
        this.updateReportTypes();
        this.updateRelations();
        this.updateExtraParams();
    }

    private void setControl() {
        if (RELATION_TYPE_PERSON.equals(this.getModel().getValue(RELATION_TYPE)) && PERSON_RELATION_SELF.equals(this.getModel().getValue(PERSON_RELATION)) && "admin_org".equals(this.getModel().getValue(REPORT_TYPE))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REF_ORG_PERSON});
        }
    }

    private void init() {
        ComboProp comboProp;
        ComboEdit comboEdit;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Process process = this.extractProcessFromParameter(parameter);
        if (process == null) {
            return;
        }
        String entraBill = this.getEntraBill(parameter, process);
        if (WfUtils.isEmpty((String)entraBill)) {
            return;
        }
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entraBill);
        List userItems = this.extractUserItemsFromEntityCache((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRelationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        List orgItems = this.extractOrgItemsFromEntityCache((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRelationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        for (IDataEntityProperty prop : mainEntity.getProperties()) {
            if (!(prop instanceof EntryProp)) continue;
            userItems.addAll(this.extractUserItemsFromEntityCache(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
            orgItems.addAll(this.extractOrgItemsFromEntityCache(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
        }
        List personsInProcess = this.extractUserItemsFromProcess(process);
        userItems.addAll(personsInProcess);
        String refPerson = null;
        if (!userItems.isEmpty()) {
            ((ComboEdit)this.getControl(REF_PERSON)).setComboItems(userItems);
            refPerson = ((ComboItem)userItems.get(0)).getValue();
            this.getModel().setValue(REF_PERSON, (Object)refPerson);
            this.getPageCache().put(REF_PERSON, SerializationUtils.toJsonString((Object)userItems));
            ((ComboEdit)this.getControl(REF_PERSON)).getModel();
        }
        if (!orgItems.isEmpty()) {
            this.getPageCache().put(REF_ORG_PERSON, SerializationUtils.toJsonString((Object)orgItems));
            List<ComboItem> orgItemsForOrg = new ArrayList<ComboItem>(orgItems);
            orgItemsForOrg = this.addCustomOrgItems(orgItemsForOrg);
            ((ComboEdit)this.getControl(REF_ORG_ORG)).setComboItems(orgItemsForOrg);
            this.getModel().setValue(REF_ORG_ORG, (Object)orgItemsForOrg.get(0).getValue());
            this.getPageCache().put(REF_ORG_ORG, SerializationUtils.toJsonString(orgItemsForOrg));
            this.loadRefOrgPerson(null == refPerson ? "" : refPerson);
        }
        if (null != (comboEdit = (ComboEdit)this.getView().getControl(ORG_RELATION)) && null != (comboProp = (ComboProp)comboEdit.getProperty())) {
            this.getPageCache().put(ORG_RELATION, SerializationUtils.toJsonString((Object)comboProp.getComboItems()));
        }
    }

    private void updateReportTypes() {
        Map reportTypeItems = this.extractReportTypesByType(RELATION_TYPE_PERSON);
        if (!reportTypeItems.isEmpty()) {
            ((ComboEdit)this.getControl(REPORT_TYPE)).setComboItems(new ArrayList(reportTypeItems.values()));
            Object reportTypeVal = this.getModel().getValue(REPORT_TYPE);
            if (reportTypeItems.size() > 0 && (StringUtils.isBlank((Object)reportTypeVal) || reportTypeItems.get(reportTypeVal.toString()) == null)) {
                Set keys = reportTypeItems.keySet();
                Iterator it = keys.iterator();
                this.getModel().setValue(REPORT_TYPE, it.next());
            }
        }
    }

    private void updateRelations() {
        String reprotType = (String)this.getModel().getValue(REPORT_TYPE);
        Map relationItems = this.extractRelationsByReportType(reprotType);
        if (!relationItems.isEmpty()) {
            ArrayList relations = new ArrayList(relationItems.values());
            String cacheKey = reprotType + "." + PERSON_RELATION;
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(relations));
            ((ComboEdit)this.getControl(PERSON_RELATION)).setComboItems(relations);
            Object relationVal = this.getModel().getValue(PERSON_RELATION);
            if (relationItems.size() > 0 && (StringUtils.isBlank((Object)relationVal) || relationItems.get(relationVal.toString()) == null)) {
                Set keys = relationItems.keySet();
                Iterator it = keys.iterator();
                this.getModel().setValue(PERSON_RELATION, it.next());
                relationVal = this.getModel().getValue(PERSON_RELATION);
            }
            this.showVisibleForRefOrgPerson(relationVal);
        }
    }

    private void updateExtraParams() {
        DynamicObjectCollection params = this.extractParamsByRelId((String)this.getModel().getValue(REPORT_TYPE), (String)this.getModel().getValue(PERSON_RELATION));
        this.getModel().deleteEntryData(PARAMS_ENTRY);
        if (params != null && params.size() > 0) {
            this.getModel().deleteEntryData(PARAMS_ENTRY);
            this.getModel().batchCreateNewEntryRow(PARAMS_ENTRY, params.size());
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map part = (Map)parameter.getCustomParam("part");
            List paramsInfo = new ArrayList();
            HashMap numberKeyParams = new HashMap();
            if (part != null && "relation".equals(part.get("type"))) {
                paramsInfo = (List)part.get("collaborationParams");
                for (Map i : paramsInfo) {
                    if (!WfUtils.isNotEmpty((String)((String)i.get(NUMBERVARIABLE)))) continue;
                    numberKeyParams.put(i.get(NUMBERVARIABLE), i);
                }
            }
            for (int i = 0; i < params.size(); ++i) {
                DynamicObject entityObject;
                DynamicObject para = (DynamicObject)params.get(i);
                String paramName = para.getString(PARAMS_NAME);
                String paramDesc = para.getString(PARAMS_DESC);
                Boolean paramMustInput = para.getBoolean(PARAMS_MUSTINPUT);
                String paramType = para.getString(PARAMS_TYPE);
                String paramTypeName = ParamTypeEnum.get(paramType).getDesc();
                if (ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType) && (entityObject = para.getDynamicObject(PARAMS_ENTITYOBJECT)) != null) {
                    this.getModel().setValue(PARAMS_ENTITYOBJECT, (Object)entityObject.getString(NUMBERVARIABLE), i);
                    paramTypeName = paramTypeName + "(" + entityObject.getLocaleString("name").getLocaleValue() + ")";
                }
                this.getModel().setValue(PARAMS_NAME, (Object)paramName, i);
                this.getModel().setValue(PARAMS_DESC, (Object)paramDesc, i);
                this.getModel().setValue(PARAMS_TYPE, (Object)paramType, i);
                this.getModel().setValue(PARAMS_MUSTINPUT, (Object)paramMustInput, i);
                this.getModel().setValue(PARAMS_TYPENAME, (Object)paramTypeName, i);
                if (numberKeyParams.get(paramName) == null) continue;
                String valueFormat = (String)((Map)numberKeyParams.get(paramName)).get("valueFormat");
                String paramMappingField = (String)((Map)numberKeyParams.get(paramName)).get("valueExpression");
                if (paramMappingField != null) {
                    this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)paramMappingField, i);
                }
                if (valueFormat == null) continue;
                this.getModel().setValue(PARAMS_VALUEFORMAT, (Object)valueFormat, i);
            }
        }
        String value = (String)this.getModel().getValue(RELATION_TYPE);
        this.showSubPanel(value);
    }

    private List<ComboItem> addCustomOrgItems(List<ComboItem> orgItems) {
        List customProps = ExpressionPropUtils.getCustomPropsByType((String)"bos_org", (String)"bos_org");
        ArrayList<ComboItem> newOrgItems = new ArrayList<ComboItem>(orgItems);
        for (Map prop : customProps) {
            for (ComboItem item : orgItems) {
                String name = item.getCaption().getLocaleValue();
                String value = item.getValue();
                String newName = name + "-" + (String)prop.get("name");
                String newValue = value + "." + (String)prop.get(NUMBERVARIABLE);
                newOrgItems.add(new ComboItem(new LocaleString(newName), newValue));
            }
        }
        return newOrgItems;
    }

    private void loadReportType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map part = (Map)parameter.getCustomParam("part");
        if (part != null && "relation".equals(part.get("type"))) {
            IDataModel model = this.getModel();
            Object reportType = part.get("reportType");
            this.setIfCheck(model, REPORT_TYPE, reportType);
            model.setValue("refpersontype", (Object)this.extractRefPersonTypeByReportType((String)reportType));
        }
    }

    private void load() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map part = (Map)parameter.getCustomParam("part");
        if (part != null && "relation".equals(part.get("type"))) {
            boolean person;
            IDataModel model = this.getModel();
            Object referencePerson = part.get("referencePerson");
            this.setIfCheck(model, REF_PERSON, referencePerson);
            Object personRelation = part.get("personRelation");
            this.setIfCheck(model, PERSON_RELATION, personRelation);
            Object referenceOrg = part.get("referenceOrg");
            this.setIfCheck(model, REF_ORG_ORG, referenceOrg);
            model.setValue(REF_ORG_PERSON, referenceOrg);
            Object orgRelation = part.get("orgRelation");
            this.setIfCheck(model, ORG_RELATION, orgRelation);
            Object relationType = part.get("relationType");
            if (WfUtils.isEmptyString(relationType)) {
                if (referenceOrg != null) {
                    this.setIfCheck(model, RELATION_TYPE, RELATION_TYPE_ORG);
                    person = false;
                } else {
                    this.setIfCheck(model, RELATION_TYPE, RELATION_TYPE_PERSON);
                    person = true;
                }
            } else {
                this.setIfCheck(model, RELATION_TYPE, relationType);
                person = RELATION_TYPE_PERSON.equals(relationType);
            }
            if (person) {
                this.showSubPanel(RELATION_TYPE_PERSON);
            } else {
                this.showSubPanel(RELATION_TYPE_ORG);
            }
        } else {
            this.showSubPanel(RELATION_TYPE_PERSON);
        }
    }

    private void showSubPanel(String relationType) {
        if (RELATION_TYPE_ORG.equals(relationType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_PERSON});
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_ORG});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_REL_PARAM});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_PERSON});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_ORG});
            int entryRowCount = this.getModel().getEntryRowCount(PARAMS_ENTRY);
            this.getView().setVisible(Boolean.valueOf(entryRowCount > 0), new String[]{PANEL_REL_PARAM});
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "parammappingfield": {
                this.showExpressionForm();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showExpressionForm() {
        String valueFormat = (String)this.getModel().getValue(PARAMS_VALUEFORMAT);
        if ("1".equals(valueFormat)) {
            String paramType = (String)this.getModel().getValue(PARAMS_TYPE);
            if (ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType)) {
                String formId = (String)this.getModel().getValue(PARAMS_ENTITYOBJECT);
                if (WfUtils.isEmpty((String)formId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5de5\u4f5c\u6d41\u534f\u4f5c\u5173\u7cfb\u3002", (String)"PartRelationPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean isMultiSelect = false;
                ListShowParameter para = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
                if (para != null) {
                    para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_F7));
                    this.getView().showForm((FormShowParameter)para);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u53c2\u6570\u503c\u201d\u3002", (String)"PartRelationPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            JSONObject context = (JSONObject)showParameter.getCustomParam("context");
            if (context == null || context.getJSONObject("nodeProperties") == null) {
                return;
            }
            String nodeKey = context.getJSONObject("nodeProperties").getString("itemId");
            if (StringUtils.isNotBlank((CharSequence)nodeKey)) {
                String expression;
                String modelJson = context.getString("model");
                Process process = ProcessDefinitionUtil.getBpmnModel((String)modelJson).getMainProcess();
                String entityNumber = this.getEntraBill(showParameter, process);
                HashMap<String, String> content = new HashMap<String, String>();
                content.put("bpmnModel", modelJson);
                content.put("entityNumber", entityNumber);
                content.put("ruleType", (String)ConditionalRuleType.skip);
                if (WfUtils.isNotEmptyString((Object)this.getModel().getValue(PARAMS_MAPPINGFIELD)) && (expression = this.getModel().getValue(PARAMS_MAPPINGFIELD).toString()).startsWith("${") && expression.endsWith("}")) {
                    expression = expression.substring(2, expression.length() - 1);
                    content.put("expression", expression);
                }
                this.showForm(CLOSECALLBACK_EXPR, "wf_valueexpression", content);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "closecallbackexpr": {
                this.setCloseDataForParamField((Map)returnData);
                break;
            }
            case "closecallbackf7": {
                this.setCloseDataForF7(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private boolean validateVariableType(String valueType, String paramType) {
        boolean typeValidation = false;
        switch (valueType) {
            case "date": {
                if (!ParamTypeEnum.DATETIME.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "boolean": {
                if (!ParamTypeEnum.BOOLEAN.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "String": {
                if (!ParamTypeEnum.TEXT.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "number": 
            case "Long": {
                if (!ParamTypeEnum.DECIMAL.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "F7": {
                if (!ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
        }
        return typeValidation;
    }

    private void setCloseDataForF7(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRow rowData = ((ListSelectedRowCollection)returnData).get(0);
            HashMap<String, Object> valObj = new HashMap<String, Object>();
            valObj.put("id", rowData.getPrimaryKeyValue());
            String number = rowData.getNumber();
            valObj.put(NUMBERVARIABLE, number);
            String name = rowData.getName();
            valObj.put("name", name);
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)SerializationUtils.toJsonString(valObj));
        } else {
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)SerializationUtils.toJsonString((Object)returnData));
        }
    }

    private void setCloseDataForParamField(Map<String, Object> data) {
        String prop = (String)data.get("prop");
        JSONObject propObj = (JSONObject)SerializationUtils.fromJsonString((String)prop, JSONObject.class);
        String valueType = propObj.getString("valuetype");
        String expression = propObj.getString("expression");
        EntryGrid grid = (EntryGrid)this.getControl(PARAMS_ENTRY);
        int focusRow = grid.getEntryState().getFocusRow();
        String currentParamType = (String)this.getModel().getValue(PARAMS_TYPE, focusRow);
        boolean typeValidation = true;
        if ("F7".equals(valueType)) {
            String currentParamEntityObject = (String)this.getModel().getValue(PARAMS_ENTITYOBJECT, focusRow);
            String entityNumber = propObj.getString("entityNumber");
            if (StringUtils.isBlank((CharSequence)entityNumber) || !entityNumber.equalsIgnoreCase(currentParamEntityObject)) {
                typeValidation = false;
            }
        } else if (this.isPersonMacroAndVariable(expression)) {
            valueType = STRINGVARIABLE;
        }
        if (typeValidation) {
            typeValidation = this.validateVariableType(valueType, currentParamType);
        }
        if (typeValidation) {
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)("${" + expression + "}"), focusRow);
        } else {
            String paraTypeName = (String)this.getModel().getValue(PARAMS_TYPENAME, focusRow);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53ea\u80fd\u9009\u62e9\u201c%s\u201d\u7c7b\u578b\u7684\u5b57\u6bb5\u3002", (String)"PartRelationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), paraTypeName));
        }
    }

    public boolean isPersonMacroAndVariable(String expression) {
        if (expression != null) {
            if (expression.startsWith("proc") && expression.endsWith("Assignee")) {
                return true;
            }
            if (expression.startsWith("proc") && expression.endsWith("initiator")) {
                return true;
            }
            return expression.equalsIgnoreCase("currentParticipant");
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        String valFormmat;
        IDataModel model = this.getModel();
        String prop = pca.getProperty().getName();
        Object newValue = pca.getChangeSet()[0].getNewValue();
        String value = (String)model.getValue(RELATION_TYPE);
        if (RELATION_TYPE.equals(prop)) {
            this.showSubPanel(value);
            this.updateReportTypes();
        } else if (REPORT_TYPE.equals(prop)) {
            this.getModel().setValue("refpersontype", (Object)this.extractRefPersonTypeByReportType((String)newValue));
            this.updateRelations();
            this.updateExtraParams();
        } else if (PERSON_RELATION.equals(prop)) {
            this.showVisibleForRefOrgPerson(newValue);
            this.updateExtraParams();
        } else if (REF_PERSON.equals(prop)) {
            this.loadRefOrgPerson((String)newValue);
        } else if ("refpersontype".equals(prop)) {
            this.init();
        } else if (PARAMS_VALUEFORMAT.equals(prop)) {
            this.getModel().beginInit();
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)"", pca.getChangeSet()[0].getRowIndex());
            this.getModel().endInit();
        } else if (PARAMS_MAPPINGFIELD.equals(prop) && !"1".equals(valFormmat = pca.getChangeSet()[0].getDataEntity().getString(PARAMS_VALUEFORMAT))) {
            String newVal = (String)newValue;
            if (StringUtils.isNotBlank((CharSequence)newVal) && !newVal.contains("${")) {
                String msg = pca.getChangeSet()[0].getDataEntity().getString(PARAMS_TYPENAME);
                String paramType = pca.getChangeSet()[0].getDataEntity().getString(PARAMS_TYPE);
                boolean typeValidation = true;
                if (ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType)) {
                    typeValidation = false;
                } else if (ParamTypeEnum.BOOLEAN.getName().equals(paramType)) {
                    if (!newVal.equalsIgnoreCase("true") && !newVal.equalsIgnoreCase("false")) {
                        typeValidation = false;
                    }
                } else if (ParamTypeEnum.DATETIME.getName().equals(paramType)) {
                    try {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        LocalDateTime.parse(newVal, formatter);
                    }
                    catch (Exception e) {
                        typeValidation = false;
                        msg = String.format(ResManager.loadKDString((String)"%s\u8bf7\u6c42\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm:ss\u3002", (String)"PartRelationPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg);
                    }
                } else if (ParamTypeEnum.DECIMAL.getName().equals(paramType)) {
                    try {
                        new BigDecimal(newVal);
                    }
                    catch (Exception e) {
                        typeValidation = false;
                    }
                }
                if (!typeValidation) {
                    this.getModel().beginInit();
                    this.getModel().setValue(prop, pca.getChangeSet()[0].getOldValue(), pca.getChangeSet()[0].getRowIndex());
                    this.getModel().endInit();
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53ea\u80fd\u9009\u62e9\u201c%s\u201d\u7c7b\u578b\u7684\u5b57\u6bb5\u3002", (String)"PartRelationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg));
                }
            }
            this.getView().updateView(PARAMS_ENTRY);
        }
    }

    private void loadRefOrgPerson(String newValue) {
        String refOrg = this.getPageCache().get(REF_ORG_PERSON);
        if (WfUtils.isNotEmpty((String)refOrg)) {
            String entryKey = null;
            if (WfUtils.isNotEmptyString((Object)newValue) && newValue.indexOf("ENTRY_") > -1) {
                entryKey = newValue.substring(newValue.indexOf(95) + 1, newValue.indexOf(46) + 1);
            }
            ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
            List orgItemList = (List)SerializationUtils.fromJsonString((String)refOrg, List.class);
            Object orgItemValue = null;
            boolean isAddData = false;
            for (Map map : orgItemList) {
                String valueStr;
                int beginIndex;
                orgItemValue = map.get("value");
                if (null == entryKey) {
                    isAddData = true;
                } else if (WfUtils.isNotEmptyString(orgItemValue) && ((beginIndex = (valueStr = orgItemValue.toString()).indexOf("ENTRY_")) > -1 && valueStr.indexOf(entryKey) > -1 || beginIndex <= -1)) {
                    isAddData = true;
                }
                if (isAddData) {
                    orgItems.add(new ComboItem(new LocaleString((String)((Map)map.get("caption")).get(Lang.get().toString())), (String)orgItemValue));
                }
                isAddData = false;
            }
            orgItems.add(new ComboItem(new LocaleString(""), " "));
            ((ComboEdit)this.getControl(REF_ORG_PERSON)).setComboItems(orgItems);
            this.getModel().setValue(REF_ORG_PERSON, (Object)((ComboItem)orgItems.get(0)).getValue());
        }
    }

    private void showVisibleForRefOrgPerson(Object newValue) {
        Boolean isEnable = Boolean.FALSE;
        String reportType = (String)this.getModel().getValue(REPORT_TYPE);
        if (!PERSON_RELATION_SELF.equals(newValue) && "admin_org".equals(reportType)) {
            isEnable = Boolean.TRUE;
        }
        this.getView().setVisible(isEnable, new String[]{REF_ORG_PERSON});
    }

    static enum ParamTypeEnum {
        DATETIME("datetime", "date", ResManager.loadKDString((String)"\u65e5\u671f\u578b", (String)"PartRelationPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        BOOLEAN("boolean", "boolean", ResManager.loadKDString((String)"\u5e03\u5c14\u578b", (String)"PartRelationPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        TEXT("text", "String", ResManager.loadKDString((String)"\u6587\u672c\u578b", (String)"PartRelationPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        DECIMAL("decimal", "number", ResManager.loadKDString((String)"\u6570\u503c\u578b", (String)"PartRelationPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        ENTITYOBJECT("entityobject", "F7", ResManager.loadKDString((String)"\u5bf9\u8c61\u578b", (String)"PartRelationPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));

        private String name;
        private String number;
        private String desc;

        private ParamTypeEnum(String name, String number, String desc) {
            this.name = name;
            this.number = number;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getDesc() {
            return this.desc;
        }

        public static ParamTypeEnum get(String name) {
            if (ParamTypeEnum.DATETIME.name.equals(name)) {
                return DATETIME;
            }
            if (ParamTypeEnum.BOOLEAN.name.equals(name)) {
                return BOOLEAN;
            }
            if (ParamTypeEnum.TEXT.name.equals(name)) {
                return TEXT;
            }
            if (ParamTypeEnum.DECIMAL.name.equals(name)) {
                return DECIMAL;
            }
            return ENTITYOBJECT;
        }
    }
}

