/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.EvtJobDAO;
import kd.bos.bec.engine.asyncexecutor.EvtJobManager;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.HasExtensionAttributes;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.basedata.BaseDataRefRecordInitTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.BaseDataRefRecordInitTaskClick;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.service.exectors.RepaireHiCommentExecutor;
import kd.bos.workflow.support.task.RecordRepeatUserNameScheduleTask;
import org.apache.commons.beanutils.PropertyUtils;

public class WorkflowBpmnModelPropertyPlugin
extends AbstractWorkflowPlugin
implements TreeNodeClickListener {
    private static Log log = LogFactory.getLog(WorkflowBpmnModelPropertyPlugin.class);
    private static final String BATCHNUMBER = "batchnums";
    private static final String ROWNUMS = "rownums";
    private static final String BUSINESSKEY = "businesskey";
    private static final String BTN_REMOVE_EVTLOG = "remevtlog";
    private static final String BTN_REMOVE_JOBRECORD = "remjobrecord";
    private static final String BTN_REMOVE_FAILEDJOB = "remfailedjob";
    private static final String BTN_REMOVE_RUNTIMEDATA = "deleteruntimedata";
    private static final String BTN_MOVE_TERMINALPROCESSDEADJOBTOFAILEDJOB = "deadjobtofailedjob";
    private static final String BTN_REMOVE_REMTASKHANDLELOG = "remtaskhandlelog";
    private static final String BTN_REMOVE_DEAD = "remdead";
    private static final String BTN_DELETEHIUSERINST = "deletehiuserinst";
    private static final String EVTTYPE = "evttype";
    private static final String BTN_REFRESH_CACAHE = "btnrefreshcache";
    private static final String BTN_REPAIREXECUTINGBIZCACHE = "repairrunningjobcache";
    private static final String PROCESSINSTANCEID_FIELD = "processinstanceid";
    private static final String PROCINSTID_FIELD = "procinstid";
    private static final String BTN_GETRELATIONDATAS = "getrelationdatas";
    private static final String BTN_GETDAPRELATIONDATAS = "getdaprelationdatas";
    private static final String FIELD_RELATIONENTITYNUMBER = "relationentitynumber";
    private static final String FIELD_RELATIONBILLID = "relationbillid";
    private static final String FIELD_UPLINK = "uplink";
    private static final String FIELD_RELATIONDATAS = "relationdatas";
    private static final String FIELD_RELATIONJSONDATAS = "relationjsondatas";
    private static final String BTN_GET_CACAHE = "get";
    private static final String BTN_GETSETVALUES_CACAHE = "getsetvalues";
    private static final String BTN_GETALL_CACAHE = "getall";
    private static Log logger = LogFactory.getLog(WorkflowBpmnModelPropertyPlugin.class);
    private static final String TREEVIEWAP = "treeviewap";
    private static final String BPMNMODEL = "bpmnModel";
    private static final String IDS = "ids";
    private static final String SCHEMEID = "schemeId";
    private static final String RESOURCEID = "resourceId";
    private static final String PROCESSINSTANCEID = "processInstanceId";
    private static final String PROCESSDEFITIONID = "processDefinitionId";
    private static final String CHOICEID = "choiceid";
    private static final String CONFIRMBTN = "btnconfirm";
    private static final String BTNCLEARCACHE = "btnclearcache";
    private static final String BTNFIXSCHEMEID = "fixschemeid";
    private static final String REPAIRRECORDS = "repaircomment";
    private static final String REPAIRCOMMENT_STARTDATE = "startdate";
    private static final String REPAIRCOMMENT_ENDDATE = "enddate";
    private static final String BTNPROCESSDELETE = "btnprocessdelete";
    private static final String BTNFIXWITHDRAWBILLID = "fixwithdrawbill";
    private static final String BTNREPAIRPROCINS = "repairprocins";
    private static final String FLEXPANELTREE = "flexpaneltree";
    private static final String TASKHANDLELOGREPAIR = "repairtaskhandlelog";
    private static final String TEXT_CACHEVALUE = "cachevalue";
    private static final String TEXT_CACHEKEY = "cachekey";
    private static final String BTN_REMOVESPCACHE = "removespcache";
    private static final String ITEMS = "Items";
    private static final String SOURCEFLOWELEMENT = "sourceFlowElement";
    private static final String ISINTERRUPTING = "isInterrupting";
    private static final String XMLCOLUMNNUMBER = "xmlColumnNumber";
    private static final String DATAOUTPUTASSOCIATIONS = "dataOutputAssociations";
    private static final String PARENTCONTAINER = "parentContainer";
    private static final String IOSPECIFICATION = "ioSpecification";
    private static final String TARGETFLOWELEMENT = "targetFlowElement";
    private static final String XMLROWNUMBER = "xmlRowNumber";
    private static final String EXTENSIONATTRIBUTESIMPL = "extensionAttributesImpl";
    private static final String CLASSEQUAL = "%s=%s";
    private static String[] propertiesExcludes = new String[]{"parentContainer", "forkJoinModels", "behavior", "eventListeners", "artifactList", "flowElementMap", "dynamicModelPartial", "lanes", "PROCESSMODE_SKIP", "PROCESSMODE_AUTO", "PROCESSMODE_MANUAL", "ioSpecification", "dataObjects", "flowElementList", "initiator", "style", "resultVariableName", "forCompensation", "mapExceptions", "notExclusive", "xmlRowNumber", "xmlColumnNumber", "boundaryEvents", "failedJobRetryTimeCycleValue", "dataOutputAssociations", "dataInputAssociations", "dataOutputAssociations", "ioSpecification", "isInterrupting", "sourceFlowElement", "targetFlowElement", "deleted", "updated", "inserted", "formProperties", "waypoints", "xmlRowNumber", "xmlColumnNumber"};
    private static String[] objectNodeExcludes = new String[]{"initiator", "behavior", "forkJoinModels", "parentContainer", "style", "resultVariableName", "forCompensation", "mapExceptions", "notExclusive", "xmlRowNumber", "xmlColumnNumber", "boundaryEvents", "failedJobRetryTimeCycleValue", "dataOutputAssociations", "dataInputAssociations", "dataOutputAssociations", "ioSpecification", "isInterrupting", "sourceFlowElement", "targetFlowElement", "deleted", "updated", "inserted", "formProperties", "waypoints", "xmlRowNumber", "xmlColumnNumber"};
    private static final String SEARCHCACHEKEY = "searchcachekey";
    private static final String BTN_SEARCHCACHE = "searchcache";
    private static final String SEARCHCACHEVALUE = "searchcachevalue";
    private static final String BTN_CLEARCACHEFORUSERS = "clearcacheforusers";
    private static final String BTN_CLEARREPEATUSERSDATA = "clearrepeatusersdata";
    private static final String BTN_ADDREPEATUSERSDATA = "addrepeatusersdata";
    private static final String CLEARCACHEFORUSERSKEY = "muluserids";
    private static final String BTN_BASEDATA_REF_INIT = "initbasedataref";
    private static final String BIN_UPDATEHITASKPRESENTASSIGEN = "updatehitaskpresentassige";
    private static final String BTN_UPDATEEXECUTIONPRESENTASSIGEN = "updateexecpresentassigen";
    private static final String BTN_UPDATEHICOMMENTDATA = "updatehicommentdata";
    private static final String BTN_GENERATEADDRESSJOB = "generateaddress";
    private static final String CHECKCLICK = "checkclick";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String FIELDID = "fieldid";
    private static final String RESULT = "result";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRMBTN, BTNCLEARCACHE, BTNFIXSCHEMEID, BTNPROCESSDELETE, BTNFIXWITHDRAWBILLID, REPAIRRECORDS, BTNREPAIRPROCINS, TASKHANDLELOGREPAIR, BTN_REMOVESPCACHE, BTN_GETRELATIONDATAS, BTN_GETDAPRELATIONDATAS, BTN_REMOVE_EVTLOG, BTN_REMOVE_DEAD, BTN_REMOVE_JOBRECORD, BTN_REMOVE_FAILEDJOB, BTN_REMOVE_RUNTIMEDATA, BTN_REMOVE_REMTASKHANDLELOG, BTN_MOVE_TERMINALPROCESSDEADJOBTOFAILEDJOB, BTN_REFRESH_CACAHE, BTN_GET_CACAHE, BTN_GETSETVALUES_CACAHE, BTN_GETALL_CACAHE, BTN_REPAIREXECUTINGBIZCACHE, BTN_DELETEHIUSERINST, BTN_SEARCHCACHE, BTN_CLEARCACHEFORUSERS, BTN_BASEDATA_REF_INIT, BIN_UPDATEHITASKPRESENTASSIGEN, CHECKCLICK, BTN_UPDATEEXECUTIONPRESENTASSIGEN, BTN_UPDATEHICOMMENTDATA, BTN_ADDREPEATUSERSDATA, BTN_CLEARREPEATUSERSDATA, BTN_GENERATEADDRESSJOB});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String id = (String)this.getModel().getValue(IDS);
        String choiceid = (String)this.getModel().getValue(CHOICEID);
        switch (key) {
            case "btnconfirm": {
                this.btnConfirm(id, choiceid);
                break;
            }
            case "btnclearcache": {
                this.clearCache(id, choiceid);
                break;
            }
            case "fixschemeid": {
                this.fixProcInstSchemeIdByProcDefId(id);
                break;
            }
            case "btnprocessdelete": {
                this.processDelete(id, choiceid);
                break;
            }
            case "fixwithdrawbill": {
                this.fixWithDrawBillId(id);
                break;
            }
            case "repaircomment": {
                this.repairComment();
                break;
            }
            case "removespcache": {
                this.removeSpecialCache();
                break;
            }
            case "remevtlog": {
                this.removeLog("wf_eventlogentry", "t_wf_evtlog");
                break;
            }
            case "remdead": {
                this.removeLog("wf_deadletterjob", "t_wf_deadletterjob");
                break;
            }
            case "remjobrecord": {
                this.removeLog("wf_job", "t_wf_jobrecord");
                break;
            }
            case "remfailedjob": {
                this.removeLog("wf_failedjob", "t_wf_failedjob");
                break;
            }
            case "deleteruntimedata": {
                this.removeRuntimeData();
                break;
            }
            case "deadjobtofailedjob": {
                this.terminalProcessDeadjobToFailedjob();
                break;
            }
            case "remtaskhandlelog": {
                this.removeTaskHandleLog();
                break;
            }
            case "btnrefreshcache": {
                this.refreshCacheAmount();
                break;
            }
            case "get": 
            case "getsetvalues": 
            case "getall": {
                this.getCacheValue(key);
                break;
            }
            case "repairrunningjobcache": {
                this.repairExecuteRunJobCache();
                break;
            }
            case "deletehiuserinst": {
                this.removeRuntimeData();
                break;
            }
            case "searchcache": {
                this.searchCache();
                break;
            }
            case "clearcacheforusers": {
                this.clearCacheForUsers();
                break;
            }
            case "clearrepeatusersdata": {
                String sql = "delete from t_wf_secuserrepeat";
                DB.execute((DBRoute)DBRoute.workflow, (String)sql);
                RecordRepeatUserNameScheduleTask taskUp = new RecordRepeatUserNameScheduleTask();
                taskUp.updateLatestUserId("");
                this.getView().showTipNotification("Clear repeat users data success.");
                break;
            }
            case "addrepeatusersdata": {
                RecordRepeatUserNameScheduleTask task = new RecordRepeatUserNameScheduleTask();
                task.execute();
                this.getView().showTipNotification("Add repeat users data success.");
                break;
            }
            case "initbasedataref": {
                this.initBaseDataRef();
                break;
            }
            case "updatehitaskpresentassige": {
                this.updateHitaskPresentAssigen();
                break;
            }
            case "checkclick": {
                this.checkMateData();
                break;
            }
            case "updateexecpresentassigen": {
                this.updateExecutionPresentAssigen();
                break;
            }
            case "updatehicommentdata": {
                this.updateHicommentData();
                break;
            }
            case "getrelationdatas": {
                this.showRelationDatas();
                break;
            }
            case "getdaprelationdatas": {
                this.showDAPRelationDatas();
                break;
            }
            case "generateaddress": {
                this.generateAddressJob();
                break;
            }
        }
    }

    private void generateAddressJob() {
        String billids = (String)this.getView().getModel().getValue("billids");
        if (WfUtils.isEmpty((String)billids)) {
            return;
        }
        String[] businessKeys = new String[]{billids};
        if (billids.contains("\n")) {
            businessKeys = billids.split("\n");
        } else if (billids.contains("\r")) {
            businessKeys = billids.split("\r");
        } else if (billids.contains(",")) {
            businessKeys = billids.split(",");
        }
        boolean evtJob = (Boolean)this.getView().getModel().getValue("evtjob");
        String entityNumber = (String)this.getView().getModel().getValue("billentitynumber");
        String operation = (String)this.getView().getModel().getValue("operation");
        if (!evtJob) {
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(businessKeys.length);
            for (int i = 0; i < businessKeys.length; ++i) {
                if (WfUtils.isEmpty((String)businessKeys[i])) continue;
                try {
                    dyns.add(WfUtils.findBusinessObject((String)businessKeys[i], (String)entityNumber));
                    continue;
                }
                catch (Exception e) {
                    logger.info("batch abandon process occurred exception: businessKey-{},exception-{}", (Object)businessKeys[i], (Object)WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
            if (dyns.isEmpty()) {
                return;
            }
            List jobs = this.getRuntimeService().tryTriggerProcess(dyns.toArray(new DynamicObject[dyns.size()]), operation, null, new HashMap());
            JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
            dao.insert(jobs, operation, entityNumber);
            return;
        }
        ProcessEngineConfigurationImpl impl = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        EvtJobManager jobManager = impl.getEvtJobManager();
        String eventNumber = String.format("%s.%s", entityNumber, operation);
        ORM orm = ORM.create();
        for (int i = 0; i < businessKeys.length; ++i) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("eventType", "entityEvent");
            params.put("eventNumber", eventNumber);
            params.put("entityNumber", entityNumber);
            params.put("businesskeys", businessKeys[i]);
            params.put("operation", operation);
            EvtJobEntity job = jobManager.createEventDispatchJob(params, new HashMap());
            job.setBusinessKey(businessKeys[i]);
            job.setId(Long.valueOf(orm.genLongId("evt_job")));
            EvtJobDAO dao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
            String dbRoute = DBRoute.workflow.getRouteKey();
            if (WfUtils.isNotEmpty((String)entityNumber)) {
                MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                dbRoute = entity.getDBRouteKey();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(impl.getClock().getCurrentTime());
            gregorianCalendar.add(12, 1);
            job.setLockExpirationTime(gregorianCalendar.getTime());
            ArrayList<EvtJobEntity> jobs = new ArrayList<EvtJobEntity>(1);
            jobs.add(job);
            dao.insert(jobs, operation, WfUtils.isEmpty((String)entityNumber) ? "" : entityNumber, dbRoute);
        }
    }

    private void showRelationDatas() {
        IDataModel model = this.getModel();
        String entityNumber = (String)model.getValue(FIELD_RELATIONENTITYNUMBER);
        String billId = (String)model.getValue(FIELD_RELATIONBILLID);
        boolean isUpLink = Boolean.TRUE.equals(model.getValue(FIELD_UPLINK));
        if (WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)billId) || !billId.matches("\\d+")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u548c\u5355\u636eID\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WorkflowBpmnModelPropertyPlugin_22", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        String data = "no data";
        String jsonData = "no data";
        Long[] billIds = new Long[]{Long.valueOf(billId)};
        try {
            if (isUpLink) {
                Map ret = BFTrackerServiceHelper.loadBillLinkUpNodes((String)entityNumber, (Long[])billIds, (boolean)false);
                if (ret != null && !ret.isEmpty()) {
                    data = SerializationUtils.serializeToBase64((Object)ret);
                    jsonData = SerializationUtils.toJsonString((Object)ret);
                } else {
                    log.debug(String.format("entityNumber: %s, billId: %s no LinkUpNode.", entityNumber, billId));
                }
            } else {
                Map ret = BFTrackerServiceHelper.loadBillLinkDownNodes((String)entityNumber, (Long[])billIds, (boolean)false);
                if (ret != null && !ret.isEmpty()) {
                    data = SerializationUtils.serializeToBase64((Object)ret);
                    jsonData = SerializationUtils.toJsonString((Object)ret);
                } else {
                    log.debug(String.format("entityNumber: %s, billId: %s no LinkDownNode.", entityNumber, billId));
                }
            }
            model.setValue(FIELD_RELATIONDATAS, (Object)data);
            model.setValue(FIELD_RELATIONJSONDATAS, (Object)jsonData);
        }
        catch (Exception e) {
            this.getView().showTipNotification(String.format("Failed, %s.", e.getMessage()));
            log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void showDAPRelationDatas() {
        IDataModel model = this.getModel();
        String entityNumber = (String)model.getValue(FIELD_RELATIONENTITYNUMBER);
        String billId = (String)model.getValue(FIELD_RELATIONBILLID);
        if (WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)billId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u548c\u5355\u636eID\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WorkflowBpmnModelPropertyPlugin_22", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        String data = "no data";
        String jsonData = "no data";
        try {
            String[] strIds = billId.split(",");
            HashSet<Long> ids = new HashSet<Long>(strIds.length);
            for (String str : strIds) {
                if (WfUtils.isEmpty((String)str)) continue;
                ids.add(Long.valueOf(str));
            }
            Map ret = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getVoucherInfofromBill", (Object[])new Object[]{entityNumber, ids});
            if (ret != null && !ret.isEmpty()) {
                data = SerializationUtils.serializeToBase64((Object)ret);
                jsonData = SerializationUtils.toJsonString((Object)ret);
            } else {
                log.debug(String.format("entityNumber: %s, billId: %s no DAP relation.", entityNumber, billId));
            }
            model.setValue(FIELD_RELATIONDATAS, (Object)data);
            model.setValue(FIELD_RELATIONJSONDATAS, (Object)jsonData);
        }
        catch (Exception e) {
            this.getView().showTipNotification(String.format("Failed, %s.", e.getMessage()));
            log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void updateHicommentData() {
        RepaireHiCommentExecutor exe = new RepaireHiCommentExecutor();
        HistoryRepairTaskParam param = new HistoryRepairTaskParam();
        param.setLimitSize(1000);
        param.setTimes(3);
        param.setRequire(new HashMap<String, Object>());
        exe.execute(param);
    }

    private void repairExecuteRunJobCache() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        String entityNumber = (String)this.getModel().getValue(TEXT_CACHEKEY);
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            List bks = service.getRuntimeService().getEndRunningJobCache(entityNumber);
            if (bks != null && !bks.isEmpty()) {
                for (String bk : bks) {
                    WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)bk, (String)entityNumber);
                }
            }
        } else {
            this.getView().showErrorNotification("entity key must input.");
        }
    }

    private void terminalProcessDeadjobToFailedjob() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        service.getRuntimeService().scheduleHandleFailedJobs();
    }

    private void removeTaskHandleLog() {
        Integer v = (Integer)this.getModel().getValue(BATCHNUMBER);
        int batchCount = v;
        ArrayList<Long[]> paramsList = new ArrayList<Long[]>();
        String taskids = (String)this.getModel().getValue("taskid");
        if (batchCount <= 0 || WfUtils.isEmpty((String)taskids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u76f8\u5173\u53c2\u6570\uff0c\u6240\u6709\u53c2\u6570\u5fc5\u987b\u586b\u5199\u3002", (String)"WorkflowBpmnModelPropertyPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String[] taskidArray = taskids.split(",");
        if (null != taskidArray && taskidArray.length > 0) {
            for (int i = 0; i < taskidArray.length; ++i) {
                if (!taskidArray[i].matches("^\\d+$") || !WfUtils.isNotEmpty((String)taskidArray[i])) continue;
                paramsList.add(new Long[]{Long.valueOf(taskidArray[i])});
            }
        }
        String batchSql1 = "DELETE FROM t_wf_taskhandlelog_l WHERE fid in (SELECT fid FROM t_wf_taskhandlelog WHERE FTASKID = ?);";
        WfUtils.executeBatch((String)batchSql1, paramsList, (Integer)batchCount);
        String batchSql2 = "DELETE FROM t_wf_taskhandlelog WHERE FTASKID = ?;";
        WfUtils.executeBatch((String)batchSql2, paramsList, (Integer)batchCount);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5220\u9664taskhandlelog\u8868\u548ct_wf_taskhandlelog_l\u8868\u4e2d\u7684\u6570\u636e\u3002", (String)"WorkflowBpmnModelPropertyPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    private void removeRuntimeData() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        service.getHistoryService().deleteFinishedProcessDatas();
    }

    private void getCacheValue(String method) {
        String key = (String)this.getModel().getValue(TEXT_CACHEKEY);
        Object showText = "";
        try {
            if (WfUtils.isEmpty((String)key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u6e05\u9664\u7f13\u5b58\u7684key\u3002", (String)"WorkflowBpmnModelPropertyPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            int i = 0;
            if (BTN_GETSETVALUES_CACAHE.equals(method)) {
                i = 1;
            } else if (BTN_GETALL_CACAHE.equals(method)) {
                i = 2;
            }
            showText = WfCacheHelper.getCacheValue((String)key, (int)i);
        }
        catch (Exception e) {
            showText = WfUtils.getExceptionStacktrace((Throwable)e);
        }
        this.getModel().setValue("show", showText);
    }

    private void refreshCacheAmount() {
        ProcessEngineConfigurationImpl cfg = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        int size = cfg.getProcessDefinitionCache().size();
        this.getView().getModel().setValue("cacheamout", (Object)size);
    }

    private void removeLog(String entityNumber, String tableName) {
        Integer v = (Integer)this.getModel().getValue(BATCHNUMBER);
        int batchNum = v;
        v = (Integer)this.getModel().getValue(ROWNUMS);
        int rowNumPerBatch = v;
        String businesskey = (String)this.getModel().getValue(BUSINESSKEY);
        String evtType = (String)this.getModel().getValue(EVTTYPE);
        if (WfUtils.isEmpty((String)businesskey) || rowNumPerBatch <= 0 || batchNum <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u76f8\u5173\u53c2\u6570\uff0c\u6240\u6709\u53c2\u6570\u5fc5\u987b\u586b\u5199\u3002", (String)"WorkflowBpmnModelPropertyPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (WfUtils.isNotEmpty((String)evtType) && RuntimeUtil.isRunningJob((String)evtType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u6d41\u8f6c\u6d88\u606f\u3002", (String)"WorkflowBpmnModelPropertyPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        long total = 0L;
        QFilter[] qFilters = null;
        QFilter bkFilter = new QFilter("businessKey", "=", (Object)businesskey);
        QFilter evtTypeFilter = null;
        if ("wf_eventlogentry".equalsIgnoreCase(entityNumber) || "wf_failedjob".equalsIgnoreCase(entityNumber)) {
            evtTypeFilter = new QFilter("jobtype", "=", (Object)evtType);
            qFilters = WfUtils.isEmpty((String)evtType) ? new QFilter[]{bkFilter} : new QFilter[]{bkFilter, evtTypeFilter};
        } else {
            evtTypeFilter = new QFilter("jobHandlerType", "=", (Object)evtType);
            qFilters = new QFilter[]{bkFilter, evtTypeFilter};
        }
        String sql = "";
        sql = "wf_failedjob".equalsIgnoreCase(entityNumber) ? "delete from " + tableName + " where fid =? and fchanneltype = 'yunzhijia' ;" : "delete from " + tableName + " where fid =? ";
        for (int i = 0; i < batchNum; ++i) {
            try (TXHandle h = TX.requiresNew();){
                List pks = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilters, null, (int)rowNumPerBatch);
                int billCount = pks.size();
                int j = billCount % 100 != 0 ? billCount / 100 + 1 : billCount / 100;
                for (int x = 0; x < j; ++x) {
                    int end = (x + 1) * 100 > billCount ? billCount : (x + 1) * 100;
                    List subList = pks.subList(x * 100, end);
                    ArrayList<Object[]> param = new ArrayList<Object[]>(subList.size());
                    for (Object obj : subList) {
                        Object[] id = new Object[]{obj};
                        param.add(id);
                    }
                    DB.executeBatch((DBRoute)DBRoute.workflow, (String)sql, param);
                }
                total += (long)pks.size();
                if (!pks.isEmpty()) continue;
                break;
            }
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u603b\u5171\u5220\u9664\u4e86%s\u6761\u6570\u636e\u3002", (String)"WorkflowBpmnModelPropertyPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), total), Integer.valueOf(3000));
    }

    private void removeSpecialCache() {
        String key = (String)this.getModel().getValue(TEXT_CACHEKEY);
        if (WfUtils.isEmpty((String)key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u6e05\u9664\u7f13\u5b58\u7684key\u3002", (String)"WorkflowBpmnModelPropertyPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String val = (String)this.getModel().getValue(TEXT_CACHEVALUE);
        if (WfUtils.isNotEmpty((String)val)) {
            if (val.contains(",")) {
                String[] valArr = val.split("\\,");
                WfCacheHelper.removeSetOfSome((String)key, (String[])valArr);
            } else {
                String[] valArr = new String[]{val};
                WfCacheHelper.removeSetOfSome((String)key, (String[])valArr);
            }
        } else {
            WfCacheHelper.removeAllSet((String)key);
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\uff01", (String)"WorkflowBpmnModelPropertyPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
    }

    private void btnConfirm(String id, String choiceid) {
        try {
            BpmnModel bpmnModel = null;
            switch (choiceid) {
                case "schemeId": {
                    bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(Long.valueOf(id));
                    break;
                }
                case "resourceId": {
                    String modelJson = this.getRepositoryService().getResourceById(Long.valueOf(id)).getData();
                    bpmnModel = DesignerModelUtil.getBpmnModel((String)modelJson);
                    break;
                }
                case "processInstanceId": {
                    bpmnModel = this.getRepositoryService().getBpmnModel(null, Long.valueOf(id));
                    break;
                }
                case "processDefinitionId": {
                    bpmnModel = this.getRepositoryService().getBpmnModel(Long.valueOf(id), null);
                    break;
                }
            }
            if (bpmnModel != null) {
                this.showBpmnModelProperties(bpmnModel);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELTREE});
        }
        catch (Exception e) {
            log.debug(String.format("\u64cd\u4f5c\u5931\u8d25\uff01 %s %s", e.getMessage(), WfUtils.getExceptionStacktrace((Throwable)e)));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5bf9\u5e94\u6d41\u7a0b\u65b9\u6848ID\u3002", (String)"WorkflowBpmnModelPropertyPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void clearCache(String id, String choiceid) {
        switch (choiceid) {
            case "schemeId": {
                this.getManagementService().removeBPMNModelCacheByScheme(Long.valueOf(id));
                break;
            }
            case "processInstanceId": {
                this.getManagementService().removeBPMNModelCacheByProcessInstance(Long.valueOf(id));
                break;
            }
        }
        this.getView().showSuccessNotification("SUCCESS!");
    }

    private void processDelete(String processInstanceId, String choiceid) {
        if (PROCESSINSTANCEID.equals(choiceid)) {
            this.getRepositoryService().deleteAllRuntimeDatasByProcessInstanceId(Long.valueOf(processInstanceId));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"WorkflowBpmnModelPropertyPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6d41\u7a0b\u5b9e\u4f8bID\u3002", (String)"WorkflowBpmnModelPropertyPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void fixProcInstSchemeIdByProcDefId(String procDefId) {
        if (WfUtils.isEmpty((String)procDefId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6709\u6548\u6d41\u7a0b\u5b9a\u4e49ID\u3002", (String)"WorkflowBpmnModelPropertyPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] ids = procDefId.split(",");
        HashSet<Long> procDefIds = new HashSet<Long>();
        for (String id : ids) {
            if (!(id = id.trim()).matches("\\d+")) continue;
            procDefIds.add(Long.valueOf(id));
        }
        if (!procDefIds.isEmpty()) {
            this.getManagementService().fixProcInstSchemeIdByProcDefId(procDefIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\uff01", (String)"WorkflowBpmnModelPropertyPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void repairComment() {
        Date startDate = (Date)this.getModel().getValue(REPAIRCOMMENT_STARTDATE);
        Date endDate = (Date)this.getModel().getValue(REPAIRCOMMENT_ENDDATE);
        if (startDate == null || endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"WorkflowBpmnModelPropertyPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.getTaskService().repairComment(startDate, endDate);
    }

    private void fixWithDrawBillId(String id) {
        String entityNumber = (String)this.getView().getModel().getValue(TEXT_CACHEKEY);
        WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)id, (String)entityNumber);
        try {
            ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration().getMessageService().init();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    private void showBpmnModelProperties(BpmnModel bpmnmodel) {
        try {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("Id", BPMNMODEL);
            root.put("Name", ResManager.loadKDString((String)"BpmnModel\u5c5e\u6027", (String)"WorkflowBpmnModelPropertyPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            List<String> o = Arrays.asList(propertiesExcludes);
            String val = (String)this.getView().getModel().getValue("itemid");
            Process obj = bpmnmodel.getMainProcess();
            if (val != null && val.length() > 0 && (obj = bpmnmodel.getMainProcess().getFlowElement(val)) == null) {
                obj = bpmnmodel.getMainProcess();
            }
            List<Field> fields = WorkflowBpmnModelPropertyPlugin.getAllFields(obj, obj.getClass());
            ArrayList<Map<String, Object>> rootItems = new ArrayList<Map<String, Object>>(fields.size());
            root.put(ITEMS, rootItems);
            for (Field field : fields) {
                String fieldName = field.getName();
                if (o.contains(fieldName)) continue;
                rootItems.add(WorkflowBpmnModelPropertyPlugin.getTreeNode(fieldName, obj));
            }
            this.createTree(root);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Object> getTreeNode(String name, Object obj) {
        try {
            Object value = null;
            HashMap<String, Object> node = new HashMap<String, Object>();
            switch (name) {
                case "isInterrupting": {
                    StartEvent startEvent = (StartEvent)obj;
                    node.put("Id", name);
                    node.put("Name", String.format(CLASSEQUAL, name, startEvent.isInterrupting()));
                    return node;
                }
                case "isSetNextAssignee": {
                    Process process = (Process)obj;
                    node.put("Id", name);
                    node.put("Name", String.format(CLASSEQUAL, name, process.isSetNextAssigneeValue()));
                    return node;
                }
                case "extensionAttributesImpl": {
                    node.put("Id", name);
                    if (obj instanceof HasExtensionAttributes) {
                        value = SerializationUtils.toJsonString((Object)((HasExtensionAttributes)obj).getAttributes());
                    }
                    node.put("Name", String.format(CLASSEQUAL, name, value));
                    return node;
                }
            }
            try {
                value = PropertyUtils.getProperty((Object)obj, (String)name);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
            if (value == null) {
                node.put("Id", name);
                node.put("Name", String.format(CLASSEQUAL, name, value));
                return node;
            }
            if (value instanceof DynamicObject) {
                value = SerializationUtils.toJsonString((Object)value);
            }
            Class<?> type = value.getClass();
            boolean isMap = false;
            boolean isList = false;
            for (Class<?> itf : type.getInterfaces()) {
                if (Map.class.equals(itf)) {
                    isMap = true;
                    break;
                }
                if (!List.class.equals(itf)) continue;
                isList = true;
                break;
            }
            if (isMap) {
                return WorkflowBpmnModelPropertyPlugin.getMapTypeNode(name, (Map)value, type);
            }
            if (isList) {
                return WorkflowBpmnModelPropertyPlugin.getListTypeNode(name, (List)value, type);
            }
            if (WorkflowBpmnModelPropertyPlugin.isBaseDataTypeForType(type)) {
                return WorkflowBpmnModelPropertyPlugin.getBaseTypeNode(name, value);
            }
            return WorkflowBpmnModelPropertyPlugin.getObjectNode(name, value, type);
        }
        catch (Exception e) {
            throw new WFException(e.getMessage());
        }
    }

    private static Map<String, Object> getBaseTypeNode(String name, Object value) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("Id", name);
        ret.put("Name", String.format(CLASSEQUAL, name, value));
        ArrayList result = new ArrayList();
        ret.put(ITEMS, result);
        return ret;
    }

    private static Map<String, Object> getListTypeNode(String name, List<Object> value, Class<?> type) {
        try {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("Id", name);
            if (value.isEmpty()) {
                node.put("Name", String.format("%s=[]", name));
                return node;
            }
            node.put("Name", String.format(CLASSEQUAL, name, type));
            ArrayList items = new ArrayList(value.size());
            node.put(ITEMS, items);
            int i = 0;
            for (Object object : value) {
                Map<String, Object> child = new HashMap<String, String>();
                child.put("Id", String.format("%s_%s", name, i));
                if (WorkflowBpmnModelPropertyPlugin.isBaseDataTypeForObject(object)) {
                    child.put("Name", String.format(CLASSEQUAL, i, object));
                } else {
                    log.debug("List: " + name + "  " + object);
                    child = WorkflowBpmnModelPropertyPlugin.getObjectNode(name + "_" + i, object, object.getClass());
                }
                items.add(child);
                ++i;
            }
            return node;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Object> getMapTypeNode(String name, Map<String, Object> value, Class<?> type) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Id", name);
        if (value.isEmpty()) {
            node.put("Name", String.format("%s={}", name));
            return node;
        }
        node.put("Name", String.format(CLASSEQUAL, name, type));
        ArrayList items = new ArrayList(value.size());
        node.put(ITEMS, items);
        Object mapVal = null;
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            HashMap<String, Object> child = new HashMap<String, Object>();
            String key = entry.getKey();
            mapVal = entry.getValue();
            child.put("Id", key);
            if (WorkflowBpmnModelPropertyPlugin.isBaseDataTypeForObject(mapVal)) {
                child.put("Name", String.format(CLASSEQUAL, key, mapVal));
            } else {
                child.put("Name", String.format(CLASSEQUAL, key, mapVal.getClass().getTypeName()));
                ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
                try {
                    children.add(WorkflowBpmnModelPropertyPlugin.getObjectNode(key, mapVal, mapVal.getClass()));
                }
                catch (Exception e) {
                    log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
                }
                child.put(ITEMS, children);
            }
            items.add(child);
        }
        return node;
    }

    private static boolean isBaseDataTypeForObject(Object obj) {
        return obj.getClass().isAssignableFrom(Double.class) || obj.getClass().isAssignableFrom(Float.class) || obj.getClass().isAssignableFrom(Character.class) || obj.getClass().isAssignableFrom(Long.class) || obj.getClass().isAssignableFrom(Boolean.class) || obj.getClass().isAssignableFrom(Short.class) || obj.getClass().isAssignableFrom(Byte.class) || obj.getClass().isAssignableFrom(Integer.class) || obj.getClass().isAssignableFrom(String.class);
    }

    private static boolean isBaseDataTypeForType(Class<?> type) {
        return type.isAssignableFrom(Double.class) || type.isAssignableFrom(Float.class) || type.isAssignableFrom(Character.class) || type.isAssignableFrom(Long.class) || type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Short.class) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Byte.class) || type.isAssignableFrom(String.class);
    }

    private static Map<String, Object> getObjectNode(String name, Object value, Class<?> type) {
        try {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("Id", name);
            node.put("Name", String.format(CLASSEQUAL, name, type));
            ArrayList<Map<Object, Object>> items = new ArrayList<Map<Object, Object>>();
            node.put(ITEMS, items);
            List<Field> allFields = WorkflowBpmnModelPropertyPlugin.getAllFields(value, type);
            String fieldName = "";
            List<String> o = Arrays.asList(objectNodeExcludes);
            for (Field field : allFields) {
                String number;
                HashMap<String, Object> child;
                type = field.getType();
                fieldName = field.getName();
                if (o.contains(fieldName)) continue;
                if (!PropertyUtils.isReadable((Object)value, (String)fieldName) && !EXTENSIONATTRIBUTESIMPL.equalsIgnoreCase(fieldName)) {
                    log.debug(String.format("%s\u5bf9\u8c61\u4e0d\u5b58\u5728%s\u5c5e\u6027\uff01", value, fieldName));
                    continue;
                }
                Object val = null;
                val = value instanceof HasExtensionAttributes && EXTENSIONATTRIBUTESIMPL.equalsIgnoreCase(fieldName) ? SerializationUtils.toJsonString((Object)((HasExtensionAttributes)value).getAttributes()) : PropertyUtils.getProperty((Object)value, (String)fieldName);
                if (val instanceof DynamicObject) {
                    val = SerializationUtils.toJsonString((Object)val);
                }
                if ("incomingFlows".equalsIgnoreCase(fieldName) || "outgoingFlows".equalsIgnoreCase(fieldName)) {
                    val = SerializationUtils.toJsonString((Object)val);
                }
                if ("inMsg".equalsIgnoreCase(fieldName) || "outMsg".equalsIgnoreCase(fieldName)) {
                    val = SerializationUtils.toJsonString((Object)val);
                }
                boolean isSequenceFlow = SequenceFlow.class.isInstance(value);
                boolean isFlowNode = FlowNode.class.isInstance(value);
                boolean isFlowElement = FlowElement.class.isInstance(value);
                if (isSequenceFlow) {
                    if (SOURCEFLOWELEMENT.equals(fieldName) || TARGETFLOWELEMENT.equals(fieldName) || PARENTCONTAINER.equals(fieldName)) {
                        child = new HashMap<String, Object>();
                        child.put("Id", fieldName);
                        number = null;
                        if (val instanceof FlowNode) {
                            number = ((FlowNode)val).getNumber();
                        } else if (val instanceof Process) {
                            number = ((Process)val).getNumber();
                        } else if (val != null) {
                            number = val.getClass().getName();
                        }
                        child.put("Name", String.format(CLASSEQUAL, fieldName, number));
                        items.add(child);
                        continue;
                    }
                } else if (isFlowElement) {
                    if (PARENTCONTAINER.equals(fieldName)) {
                        child = new HashMap();
                        child.put("Id", fieldName);
                        number = null;
                        if (val instanceof Process) {
                            number = ((Process)val).getNumber();
                        } else if (val != null) {
                            number = val.getClass().getName();
                        }
                        child.put("Name", String.format(CLASSEQUAL, fieldName, number));
                        items.add(child);
                        continue;
                    }
                } else if (isFlowNode && ("incomingFlows".equals(fieldName) || "outgoingFlows".equals(fieldName))) {
                    child = new HashMap();
                    child.put("Id", fieldName);
                    child.put("Name", String.format(CLASSEQUAL, fieldName, type));
                    List flows = (List)val;
                    if (flows != null && !flows.isEmpty()) {
                        ArrayList flowItems = new ArrayList(flows.size());
                        child.put(ITEMS, flowItems);
                        int i = 0;
                        for (SequenceFlow flow : flows) {
                            HashMap flowItem = new HashMap();
                            child.put("Id", String.format("%s-%s", fieldName, i++));
                            child.put("Name", String.format(CLASSEQUAL, "SequenceFlow", flow.getNumber()));
                            flowItems.add(flowItem);
                        }
                    }
                    items.add(child);
                    continue;
                }
                if (val != null && WorkflowBpmnModelPropertyPlugin.isBaseDataTypeForType(val.getClass())) {
                    child = new HashMap();
                    child.put("Id", fieldName);
                    child.put("Name", String.format(CLASSEQUAL, fieldName, val));
                    items.add(child);
                    continue;
                }
                log.debug(fieldName + "  " + value);
                items.add(WorkflowBpmnModelPropertyPlugin.getTreeNode(fieldName, value));
            }
            return node;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected static List<Field> getAllFields(Object value, Class<?> type) {
        Field[] fields;
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Field field : fields = value.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            allFields.add(field);
        }
        for (Class<?> superClass = type.getSuperclass(); superClass != null && !Object.class.equals(superClass); superClass = superClass.getSuperclass()) {
            fields = superClass.getDeclaredFields();
            if (fields.length <= 0) continue;
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                allFields.add(field);
            }
        }
        return allFields;
    }

    private TreeNode createTree(Map<String, Object> treeData) {
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        TreeNode root = TreeNode.Parse((String)"", treeData, (String)"Id", (String)"Name", (String)ITEMS);
        root.setIsOpened(true);
        tree.deleteAllNodes();
        tree.addNode(root);
        return root;
    }

    private void clearCacheForUsers() {
        StringBuilder msg = new StringBuilder();
        Object usersKey = this.getModel().getValue(CLEARCACHEFORUSERSKEY);
        if (usersKey instanceof DynamicObjectCollection) {
            DynamicObjectCollection usersKeyCol = (DynamicObjectCollection)usersKey;
            Object userIdObj = null;
            for (DynamicObject dynObj : usersKeyCol) {
                if (null == dynObj || null == (userIdObj = dynObj.get("fbasedataid_id"))) continue;
                msg.append(userIdObj).append(",");
                WfCacheHelper.clearUserName((String)userIdObj.toString());
            }
        }
        if (0 == msg.length()) {
            msg.append("The data not exist, can't clear.");
        } else {
            msg.append("success clear.");
        }
        this.getView().showSuccessNotification(msg.toString());
    }

    private void searchCache() {
        String cacheValue = null;
        Object cacheKey = this.getModel().getValue(SEARCHCACHEKEY);
        if (null != cacheKey) {
            cacheValue = WfCacheHelper.getCacheValue((String)cacheKey.toString());
        }
        if (null == cacheValue || WfUtils.isEmpty((String)cacheValue)) {
            cacheValue = "There is no result from cache.";
        }
        this.getModel().setValue(SEARCHCACHEVALUE, (Object)cacheValue);
    }

    private void initBaseDataRef() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("wf");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName("initialize base data reference record");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(BaseDataRefRecordInitTask.class.getCanonicalName());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5f15\u7528\u6570\u636e\u521d\u59cb\u5316", (String)"WorkflowBpmnModelPropertyPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(BaseDataRefRecordInitTaskClick.class.getCanonicalName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject dataObj = JSON.parseObject((String)data);
            Integer successed = dataObj.getInteger("success");
            Integer failed = dataObj.getInteger("failed");
            String tip = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u521d\u59cb\u5316\u5b8c\u6210\u3002\u6210\u529f\uff1a%1$s\uff0c\u5931\u8d25\uff1a%2$s\u3002", (String)"WorkflowBpmnModelPropertyPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]), successed, failed);
            this.getView().showMessage(tip);
        }
    }

    private void updateHitaskPresentAssigen() {
        if (StringUtils.isBlank((Object)this.getModel().getValue("step"))) {
            this.getView().showTipNotification("step's value is null");
            return;
        }
        int step = (Integer)this.getModel().getValue("step");
        int batchSize = 500;
        Date startDate = new Date(System.currentTimeMillis() - (long)(step * 24 * 3600) * 1000L);
        Date endDate = new Date();
        Map<Long, List<Long>> procIdRelatedHiTaskIds = this.getProcIdRelatedHiTaskIdList(startDate, endDate);
        Set<Long> procInstIds = procIdRelatedHiTaskIds.keySet();
        HashMap<String, List<Object[]>> langParamList = new HashMap<String, List<Object[]>>(procInstIds.size());
        ArrayList<Object[]> hitaskParamsList = new ArrayList<Object[]>(procInstIds.size());
        for (Long procInstId : procInstIds) {
            ILocaleString presentAssigen = this.getPresentAssigen(procInstId);
            if (WfUtils.isEmpty((ILocaleString)presentAssigen)) {
                String localName = " ";
                ExecutionEntity processInstance = this.getRuntimeService().getProcessInstance(procInstId);
                if (processInstance != null) {
                    localName = processInstance.getActivityName().getLocaleValue();
                }
                hitaskParamsList.add(new Object[]{StringUtils.substring((String)localName, (int)0, (int)2000), procInstId});
            } else {
                hitaskParamsList.add(new Object[]{StringUtils.substring((String)presentAssigen.getLocaleValue(), (int)0, (int)2000), procInstId});
            }
            this.getGLparamList(procInstId, presentAssigen, langParamList, procIdRelatedHiTaskIds);
        }
        String hitaskSql = "update t_wf_hitaskinst set fpresentassignee = ? where fprocinstid = ?";
        WfUtils.executeBatch((String)hitaskSql, hitaskParamsList, (Integer)batchSize);
        String hitaskGLSql = "update t_wf_hitaskinst_l  set fpresentassignee = ? where fid = ? and flocaleid = ?";
        for (Map.Entry entrySet : langParamList.entrySet()) {
            WfUtils.executeBatch((String)hitaskGLSql, (List)((List)entrySet.getValue()), (Integer)batchSize);
        }
    }

    private void updateExecutionPresentAssigen() {
        if (StringUtils.isBlank((Object)this.getModel().getValue("step"))) {
            this.getView().showTipNotification("step's value is null");
            return;
        }
        int step = (Integer)this.getModel().getValue("step");
        int batchSize = 500;
        Date startDate = new Date(System.currentTimeMillis() - (long)(step * 24 * 3600) * 1000L);
        Date endDate = new Date();
        DynamicObjectCollection executions = this.getExecutionNeedUpdatePresentAssigen(startDate, endDate);
        HashMap langParamList = new HashMap(executions.size());
        ArrayList<Object[]> executionParamsList = new ArrayList<Object[]>(executions.size());
        for (int i = 0; i < executions.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)executions.get(i);
            ILocaleString presentAssigen = this.getPresentAssigen(dynamicObject.getLong(PROCINSTID_FIELD));
            if (WfUtils.isEmpty((ILocaleString)presentAssigen)) {
                Object localName = " ";
                ExecutionEntity processInstance = this.getRuntimeService().getProcessInstance(Long.valueOf(dynamicObject.getLong(PROCINSTID_FIELD)));
                if (processInstance != null) {
                    localName = processInstance.getActivityName().getLocaleValue();
                }
                executionParamsList.add(new Object[]{StringUtils.substring((String)localName, (int)0, (int)2000), dynamicObject.getLong(PROCINSTID_FIELD)});
            } else {
                executionParamsList.add(new Object[]{StringUtils.substring((String)presentAssigen.getLocaleValue(), (int)0, (int)2000), dynamicObject.getLong(PROCINSTID_FIELD)});
            }
            for (Map.Entry entrySet : presentAssigen.entrySet()) {
                String key = (String)entrySet.getKey();
                String value = (String)entrySet.getValue();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                List paramList = langParamList.get(key) != null ? (List)langParamList.get(key) : new ArrayList();
                paramList.add(new Object[]{StringUtils.substring((String)value, (int)0, (int)2000), dynamicObject.getLong("id"), key});
                langParamList.put(key, paramList);
            }
        }
        String hitaskSql = "update t_wf_execution set fpresentassignee = ? where fprocinstid = ?";
        WfUtils.executeBatch((String)hitaskSql, executionParamsList, (Integer)batchSize);
        String hitaskGLSql = "update t_wf_execution_l  set fpresentassignee = ? where fid = ? and flocaleid = ?";
        for (Map.Entry entrySet : langParamList.entrySet()) {
            WfUtils.executeBatch((String)hitaskGLSql, (List)((List)entrySet.getValue()), (Integer)batchSize);
        }
    }

    private void getGLparamList(Long procinstId, ILocaleString presentAssigen, Map<String, List<Object[]>> langParamList, Map<Long, List<Long>> procIdRelatedHiTaskIds) {
        for (Map.Entry entrySet : presentAssigen.entrySet()) {
            List<Long> hitaskList;
            String key = (String)entrySet.getKey();
            String value = (String)entrySet.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value) || (hitaskList = procIdRelatedHiTaskIds.get(procinstId)).isEmpty()) continue;
            for (int i = 0; i < hitaskList.size(); ++i) {
                ArrayList<Object> objList = new ArrayList<Object>();
                List<Object> paramList = langParamList.get(key) != null ? langParamList.get(key) : new ArrayList();
                objList.add(StringUtils.substring((String)value, (int)0, (int)2000));
                objList.add(hitaskList.get(i));
                objList.add(key);
                paramList.add(objList.toArray());
                langParamList.put(key, paramList);
            }
        }
    }

    private Map<Long, List<Long>> getProcIdRelatedHiTaskIdList(Date startDate, Date endDate) {
        String sql = "select fid,fprocinstid from t_wf_hitaskinst where fcreatedate < ? and fcreatedate > ? and fprocinstid != 0 and fpresentassignee = ' '";
        HashMap<Long, List<Long>> procIdRelatedHiTaskIds = new HashMap<Long, List<Long>>();
        try (DataSet ds = DB.queryDataSet((String)"WorkflowBpmnModelPropertyPlugin", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{endDate, startDate});){
            for (Row row : ds) {
                Long procinstId = row.getLong("fprocinstid");
                List hitaskIds = procIdRelatedHiTaskIds.get(procinstId) != null ? (List)procIdRelatedHiTaskIds.get(procinstId) : new ArrayList();
                hitaskIds.add(row.getLong("fid"));
                procIdRelatedHiTaskIds.put(procinstId, hitaskIds);
            }
        }
        return procIdRelatedHiTaskIds;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ILocaleString getPresentAssigen(Long procInstId) {
        LocaleString currentAssigen;
        HashMap<Long, Integer> yunzhijiaTasks = new HashMap<Long, Integer>();
        ArrayList<Object> currentAssigenList = new ArrayList<Object>();
        List hiactinsts = this.getHistoryService().getHistoricActivityByProcessInstanceId(procInstId);
        HistoricActivityInstanceEntity lastHiactinst = null;
        HashMap<String, String> flowElementIds = new HashMap<String, String>();
        int i = 0;
        while (true) {
            block8: {
                LocaleString assigen;
                block13: {
                    HistoricActivityInstanceEntity hiactinst;
                    block11: {
                        block12: {
                            List identityLinks;
                            String activityType;
                            block10: {
                                block7: {
                                    block9: {
                                        FlowElement flowElement;
                                        BpmnModel bpmnModel;
                                        if (i >= hiactinsts.size()) break block7;
                                        hiactinst = (HistoricActivityInstanceEntity)hiactinsts.get(i);
                                        if (lastHiactinst == null) {
                                            lastHiactinst = hiactinst;
                                        }
                                        if (lastHiactinst.getStep() < hiactinst.getStep()) {
                                            lastHiactinst = hiactinst;
                                        }
                                        if (StringUtils.isNotBlank((Object)hiactinst.getEndTime()) || (bpmnModel = this.getRepositoryService().getBpmnModel(hiactinst.getProcessDefinitionId(), hiactinst.getProcessInstanceId())) == null || (flowElement = bpmnModel.getFlowElement(hiactinst.getActivityId())) == null || !BpmnModelUtil.instanceofYunzhijiaTask((String)flowElement.getType()) && flowElementIds.containsKey(flowElement.getId())) break block8;
                                        flowElementIds.put(flowElement.getId(), flowElement.getId());
                                        assigen = new LocaleString();
                                        activityType = hiactinst.getActivityType();
                                        if (!StringUtils.isNotBlank((Object)hiactinst.getTaskId()) || !"UserTask".equals(activityType) && !"AuditTask".equals(activityType) && !"YunzhijiaTask".equals(activityType)) break block9;
                                        identityLinks = this.getRuntimeService().getIdentityLinksByTaskId(hiactinst.getTaskId());
                                        break block10;
                                    }
                                    currentAssigenList.add(hiactinst.getActivityName());
                                    break block8;
                                }
                                currentAssigen = new LocaleString();
                                if (currentAssigenList.isEmpty() && lastHiactinst != null) {
                                    return lastHiactinst.getActivityName();
                                }
                                break;
                            }
                            for (int j = 0; j < identityLinks.size(); ++j) {
                                IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)identityLinks.get(j);
                                if (!WfUtils.isEmpty((ILocaleString)identityLinkEntity.getTrustName())) continue;
                                ILocaleString userName = WfConfigurationUtil.isDisplaySetting() ? identityLinkEntity.getUserNameFormatter() : identityLinkEntity.getUserName();
                                if (WfUtils.isEmpty((ILocaleString)assigen)) {
                                    assigen = userName;
                                    continue;
                                }
                                WfMultiLangUtils.jointILocaleString((ILocaleString)assigen, (ILocaleString)userName, (String)"\uff0c");
                            }
                            if (!BpmnModelUtil.instanceofYunzhijiaTask((String)activityType)) break block11;
                            if (!StringUtils.isBlank(yunzhijiaTasks.get(hiactinst.getParentTaskId()))) break block12;
                            yunzhijiaTasks.put(hiactinst.getParentTaskId(), currentAssigenList.size());
                            assigen = WfMultiLangUtils.jointILocaleString((ILocaleString)hiactinst.getActivityName(), (ILocaleString)assigen, (String)"\uff0f");
                            break block13;
                        }
                        assigen = WfMultiLangUtils.jointILocaleString((ILocaleString)((ILocaleString)currentAssigenList.get((Integer)yunzhijiaTasks.get(hiactinst.getParentTaskId()))), (ILocaleString)assigen, (String)"\uff0c");
                        currentAssigenList.set((Integer)yunzhijiaTasks.get(hiactinst.getParentTaskId()), assigen);
                        break block8;
                    }
                    assigen = WfMultiLangUtils.jointILocaleString((ILocaleString)hiactinst.getActivityName(), (ILocaleString)assigen, (String)"\uff0f");
                }
                currentAssigenList.add(assigen);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < currentAssigenList.size()) {
            currentAssigen = WfUtils.isEmpty((ILocaleString)currentAssigen) ? (ILocaleString)currentAssigenList.get(i2) : WfMultiLangUtils.jointILocaleString((ILocaleString)currentAssigen, (ILocaleString)((ILocaleString)currentAssigenList.get(i2)), (String)"\uff1b");
            ++i2;
        }
        return currentAssigen;
    }

    private void checkMateData() {
        this.getModel().setValue(RESULT, null);
        Long fieldId = Long.valueOf((String)this.getModel().getValue(FIELDID));
        String entitynNumber = (String)this.getModel().getValue(ENTITYNUMBER);
        Entity ret = this.getRepositoryService().findEntityById(fieldId, entitynNumber);
        if (ret != null) {
            this.getModel().setValue(RESULT, (Object)("Operation succeeded!   " + ret.toString()));
        }
    }

    private DynamicObjectCollection getExecutionNeedUpdatePresentAssigen(Date startDate, Date endDate) {
        String sql = "select fid id,fprocinstid procinstid from t_wf_execution WHERE FPARENTID = 0 AND FSUPEREXEC = 0 AND FISACTIVE = '1' AND fcreatedate < ? and fcreatedate > ? and fpresentassignee = ' '";
        try (DataSet ds = DB.queryDataSet((String)"WorkflowBpmnModelPropertyPlugin", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{endDate, startDate});){
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }
}

