/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionRuleInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionRuleInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import org.apache.commons.collections.CollectionUtils;

public class AnalyticalExpressionCmd
implements Command<Map<String, Object>>,
Serializable {
    protected Log logger = LogFactory.getLog(AnalyticalExpressionCmd.class);
    private static final long serialVersionUID = 5566629723335190364L;
    public static final String CONF_KEY = "[support-tools-test]";
    public static final String CREATE_DATE = "createdate";
    public static final String DESC = "DESC";
    public static final String ID = "id";
    protected Map<String, Object> params;

    public AnalyticalExpressionCmd(Map<String, Object> params) {
        this.params = params;
    }

    public Map<String, Object> execute(CommandContext commandContext) {
        QFilter[] qFilters;
        DynamicObject dynamicObject;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String conditionExpression = String.valueOf(this.params.get("expression"));
        String entityNumber = String.valueOf(this.params.get("entitynum"));
        String businesskey = String.valueOf(this.params.get("businesskey"));
        String billno = String.valueOf(this.params.get("billno"));
        if (StringUtils.isEmpty((String)entityNumber)) {
            entityNumber = this.getEntityNumber(commandContext, businesskey);
        }
        if (StringUtils.isEmpty((String)businesskey) && Objects.nonNull(dynamicObject = QueryServiceHelper.queryOne((String)entityNumber, (String)ID, (QFilter[])(qFilters = new QFilter("billno", "=", (Object)billno).toArray())))) {
            businesskey = String.valueOf(dynamicObject.get(0));
        }
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(businesskey, entityNumber);
        try {
            ConditionUtil.hasTrueCondition((String)conditionExpression, (VariableScope)variableScope, (String)CONF_KEY);
        }
        catch (Exception e) {
            resultMap.put("result", e);
            return resultMap;
        }
        String result = this.getRuleResultByEntity(commandContext, entityNumber, businesskey);
        resultMap.put("result", result);
        return resultMap;
    }

    private String getRuleResultByEntity(CommandContext commandContext, String entityNumber, String businesskey) {
        String result = "";
        QFilter qFilter_businesskey = new QFilter("businessKey", "=", (Object)businesskey);
        QFilter qFilter_key = new QFilter("key", "=", (Object)CONF_KEY);
        QFilter[] qFilters = new QFilter[]{qFilter_businesskey, qFilter_key};
        String sort = String.format("%s %s", CREATE_DATE, DESC);
        HistoricConditionRuleInstanceEntityManager historicConditionRuleInstanceEntityManager = commandContext.getHistoricConditionRuleInstanceEntityManager();
        List dataList = historicConditionRuleInstanceEntityManager.findByQueryFilters(qFilters, "logMsg", sort);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            result = ((HistoricConditionRuleInstanceEntity)dataList.get(0)).getLogMsg();
        }
        return result;
    }

    private String getEntityNumber(CommandContext commandContext, String businesskey) {
        String entityNumber = "";
        QFilter[] qFilters = new QFilter("businessKey", "=", (Object)businesskey).toArray();
        List dataList = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(qFilters, Boolean.TRUE.booleanValue());
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            entityNumber = ((HistoricProcessInstanceEntity)dataList.get(0)).getEntitynumber();
        }
        return entityNumber;
    }
}

