/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import org.apache.commons.collections.CollectionUtils;

public class CleanHistoricalProcessesDataCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = -8851080771557204177L;
    private static Log logger = LogFactory.getLog(CleanHistoricalProcessesDataCmd.class);
    public static final String CREATE_DATE = "createdate";
    public static final String INSTANCEIDS = "instanceIds";
    public static final String BUSINESSKEYS = "businesskeys";
    public static final String WF_EXECUTION = "wf_execution";
    public static final String WF_TASK = "wf_task";
    public static final String WF_PARTICIPANT = "wf_participant";
    public static final String WF_VARIABLEINSTANCE = "wf_variableinstance";
    public static final String WF_TRDHICOMMENT = "wf_trdhicomment";
    public static final String WF_FEEDBACK = "wf_feedback";
    public static final String WF_HIPROCINST = "wf_hiprocinst";
    public static final String WF_HIACTINST = "wf_hiactinst";
    public static final String WF_HITASKINST = "wf_hitaskinst";
    public static final String WF_HIPARTICIPANT = "wf_hiparticipant";
    public static final String WF_HIVARINST = "wf_hivarinst";
    public static final String WF_HICOMMENT = "wf_hicomment";
    public static final String WF_HIFEEDBACK = "wf_hifeedback";
    public static final String WF_HIATTACHMENT = "wf_hiattachment";
    public static final String WF_HICONDITIONINST = "wf_hiconditioninst";
    public static final String WF_JOB = "wf_job";
    public static final String WF_JOBLOG = "wf_joblog";
    public static final String WF_DEADLETTERJOB = "wf_deadletterjob";
    public static final String WF_TIMERJOB = "wf_timerjob";
    public static final String WF_SUSPENDEDJOB = "wf_suspendedjob";
    public static final String WF_HIDYNAMICRESOURCE = "wf_hidynamicresource";
    public static final String WF_AUDITPOINTINSTANCE = "wf_auditpointinstance";
    public static final String SOURCEFLAG_ENTITYNUMBER = "sourceflag_entitynumber";
    public static final String WF_HISTORICPROCCOMPACT = "wf_historicproccompact";
    public static final String WF_HISTORICCOMPACTRELA = "wf_historiccompactrela";
    private Map<String, Object> params;

    public CleanHistoricalProcessesDataCmd(Map<String, Object> params) {
        this.params = params;
    }

    public Void execute(CommandContext commandContext) {
        if (this.params == null) {
            throw new WFIllegalArgumentException("params is null");
        }
        Map<Object, Object> queryResult = new HashMap();
        if (SOURCEFLAG_ENTITYNUMBER.equals(this.params.get("sourceFlag"))) {
            String entitynumber = String.valueOf(this.params.get("entitynumber"));
            logger.debug(String.format("CleanHistoricalProcessesDataCmd  entitynumber:[%s],Operator:[%s],OperateTime:[%s]", entitynumber, RequestContext.get().getCurrUserId(), System.currentTimeMillis()));
            queryResult = this.getInstanceIdsAndBusinesskeyByEntityQuery(null, entitynumber, null, null, null);
        } else {
            String billno = String.valueOf(this.params.get("billno"));
            logger.debug(String.format("CleanHistoricalProcessesDataCmd  billno:[%s],Operator:[%s],OperateTime:[%s]", billno, RequestContext.get().getCurrUserId(), System.currentTimeMillis()));
            queryResult = this.getInstanceIdsAndBusinesskeyByEntityQuery(billno, null, null, null, null);
        }
        if (queryResult.size() > 0) {
            List processesInstanceIds = (List)queryResult.get(INSTANCEIDS);
            Set businesskeys = (Set)queryResult.get(BUSINESSKEYS);
            if (CollectionUtils.isNotEmpty((Collection)processesInstanceIds)) {
                this.executeCleanData(processesInstanceIds, businesskeys);
            }
        }
        return null;
    }

    private Map<String, Object> getInstanceIdsAndBusinesskeyByEntityQuery(String billno, String entitynum, Date startDate, Date endDate, String senduser) {
        QFilter qFilter;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<Object> instanceIds = new ArrayList();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((String)billno)) {
            qFilter = new QFilter("billno", "=", (Object)billno);
            list.add(qFilter);
        }
        if (StringUtils.isNotEmpty((String)entitynum)) {
            qFilter = new QFilter("entitynumber", "=", (Object)entitynum);
            list.add(qFilter);
        }
        if (StringUtils.isNotEmpty((String)senduser)) {
            qFilter = new QFilter("startName", "=", (Object)senduser);
            list.add(qFilter);
        }
        if (Objects.nonNull(startDate) && Objects.nonNull(endDate)) {
            QFilter qFilterStartDate = new QFilter(CREATE_DATE, ">", (Object)startDate);
            QFilter qFilterEndDate = new QFilter(CREATE_DATE, "<=", (Object)endDate);
            list.add(qFilterStartDate);
            list.add(qFilterEndDate);
        }
        QFilter[] qFilters = new QFilter[list.size()];
        qFilters = list.toArray(qFilters);
        String fields = String.format("%s,%s", "processInstanceId", "businessKey");
        DynamicObjectCollection dyCollection = QueryServiceHelper.query((String)WF_HIPROCINST, (String)fields, (QFilter[])qFilters);
        if (CollectionUtils.isNotEmpty((Collection)dyCollection)) {
            Set tempSet;
            List tempList = dyCollection.stream().map(r -> r.get(0)).collect(Collectors.toList());
            instanceIds = tempList;
            Set businesskeys = tempSet = dyCollection.stream().map(r -> r.get(1)).collect(Collectors.toSet());
            resultMap.put(INSTANCEIDS, instanceIds);
            resultMap.put(BUSINESSKEYS, businesskeys);
        }
        return resultMap;
    }

    private void executeCleanData(List<Long> processesInstanceIds, Set<String> businesskeys) {
        QFilter[] qFilters = new QFilter("processInstanceId", "in", processesInstanceIds).toArray();
        DeleteServiceHelper.delete((String)WF_EXECUTION, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_TASK, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_PARTICIPANT, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_VARIABLEINSTANCE, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_TRDHICOMMENT, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_FEEDBACK, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIPROCINST, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIACTINST, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HITASKINST, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIPARTICIPANT, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIVARINST, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HICOMMENT, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIFEEDBACK, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIATTACHMENT, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HIDYNAMICRESOURCE, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_AUDITPOINTINSTANCE, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HISTORICPROCCOMPACT, (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)WF_HISTORICCOMPACTRELA, (QFilter[])qFilters);
        QFilter[] qFiltersbusinesskeys = new QFilter("businessKey", "in", businesskeys).toArray();
        DeleteServiceHelper.delete((String)WF_HICONDITIONINST, (QFilter[])qFiltersbusinesskeys);
        DeleteServiceHelper.delete((String)WF_JOB, (QFilter[])qFiltersbusinesskeys);
        DeleteServiceHelper.delete((String)WF_JOBLOG, (QFilter[])qFiltersbusinesskeys);
        DeleteServiceHelper.delete((String)WF_DEADLETTERJOB, (QFilter[])qFiltersbusinesskeys);
        DeleteServiceHelper.delete((String)WF_TIMERJOB, (QFilter[])qFiltersbusinesskeys);
        DeleteServiceHelper.delete((String)WF_SUSPENDEDJOB, (QFilter[])qFiltersbusinesskeys);
    }
}

