/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.bec.engine.EvtJobDAO;
import kd.bos.bec.engine.impl.jobexecutor.EvtJobUtil;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.jobexecutor.ScheduleJobAddedNotification;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;

public class ResendFailJobCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Log logger = LogFactory.getLog(ResendFailJobCmd.class);
    protected Map<String, Object> params;

    public ResendFailJobCmd(Map<String, Object> params) {
        this.params = params;
    }

    public Boolean execute(CommandContext commandContext) {
        String jobId = String.valueOf(this.params.get("jobId"));
        String datasource = String.valueOf(this.params.get("dataSource"));
        String type = String.valueOf(this.params.get("type"));
        if ("dbRoute_wf".equalsIgnoreCase(datasource) || WfUtils.isEmpty((String)datasource)) {
            if ("0".equals(type)) {
                JobEntity jobEntity = (JobEntity)commandContext.getJobEntityManager().findById(Long.valueOf(jobId));
                if (jobEntity == null) {
                    this.logger.debug(String.format(" job[%s] is not exist", jobId));
                    return Boolean.FALSE;
                }
                this.logger.info(String.format("job state update before-\u3010%s\u3011", jobEntity.getState()));
                jobEntity.setState(JobStateEnum.CREATED.getNumber());
                JobEntity jobEntityupdate = (JobEntity)commandContext.getJobEntityManager().update((Entity)jobEntity);
                this.logger.info(String.format("job state-\u3010%s\u3011", jobEntityupdate.getState()));
                this.logger.debug(String.format("resend job[%s] to mq", jobId));
                ScheduleJobAddedNotification jobAddedNotification = new ScheduleJobAddedNotification(jobEntity);
                commandContext.addCloseListener((CommandContextCloseListener)jobAddedNotification);
                return Boolean.TRUE;
            }
            if ("1".equals(type)) {
                EvtJobEntity evtJobEntity = (EvtJobEntity)commandContext.getEvtJobEntityManager().findById(Long.valueOf(jobId));
                if (evtJobEntity == null) {
                    this.logger.debug(String.format(" job[%s] is not exist", jobId));
                    return Boolean.FALSE;
                }
                this.logger.info(String.format("job state update before-\u3010%s\u3011", evtJobEntity.getState()));
                evtJobEntity.setState(JobStateEnum.CREATED.getNumber());
                EvtJobEntity jobEntityupdate = (EvtJobEntity)commandContext.getEvtJobEntityManager().update((Entity)evtJobEntity);
                this.logger.info(String.format("job state-\u3010%s\u3011", jobEntityupdate.getState()));
                ArrayList<EvtJobEntity> evtJobs = new ArrayList<EvtJobEntity>();
                evtJobs.add(evtJobEntity);
                this.logger.debug(String.format("resend eventjob [%s]", jobId));
                EvtJobUtil.sendMqDirect(evtJobs);
                return Boolean.TRUE;
            }
            this.logger.debug(String.format(" type[%s] is invalid", type));
            return Boolean.FALSE;
        }
        if ("0".equals(type)) {
            JobDAO jobDao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
            JobEntity jobEntity = jobDao.findById(Long.valueOf(Long.parseLong(jobId)), datasource);
            if (jobEntity == null) {
                this.logger.debug(String.format(" job[%s] is not exist", jobId));
                return Boolean.FALSE;
            }
            this.logger.info(String.format("job state update before-\u3010%s\u3011", jobEntity.getState()));
            jobEntity.setState(JobStateEnum.CREATED.getNumber());
            jobDao.update(datasource, jobEntity);
            this.logger.info(String.format("job state-\u3010%s\u3011", jobEntity.getState()));
            this.logger.debug(String.format("resend job[%s] to mq", jobId));
            JobUtil.sendJobToMQ((JobEntity)jobEntity);
            return Boolean.TRUE;
        }
        if ("1".equals(type)) {
            EvtJobDAO jobDao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
            EvtJobEntity evtJobEntity = jobDao.findById(Long.valueOf(Long.parseLong(jobId)), datasource);
            if (evtJobEntity == null) {
                this.logger.debug(String.format(" job[%s] is not exist", jobId));
                return Boolean.FALSE;
            }
            this.logger.info(String.format("job state update before-\u3010%s\u3011", evtJobEntity.getState()));
            evtJobEntity.setState(JobStateEnum.CREATED.getNumber());
            jobDao.update(datasource, evtJobEntity);
            this.logger.info(String.format("job state-\u3010%s\u3011", evtJobEntity.getState()));
            ArrayList<EvtJobEntity> evtJobs = new ArrayList<EvtJobEntity>();
            evtJobs.add(evtJobEntity);
            this.logger.debug(String.format("resend eventjob [%s]", jobId));
            EvtJobUtil.sendMqDirect(evtJobs);
            return Boolean.TRUE;
        }
        this.logger.debug(String.format(" type[%s] is invalid", type));
        return Boolean.FALSE;
    }
}

