/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class SearchWfSchJobLogCmd
implements Command<List<Map<String, String>>>,
Serializable {
    private static final long serialVersionUID = -2036877916996008578L;
    protected Map<String, Object> params;
    public static final String SCH_JOB_LOG = "sch_job_log";
    public static final String SCH_JOB_ERROR_LOG = "sch_job_error_log";
    public static final String SHOW_RECORDS_NUMBER = "20,0";

    public SearchWfSchJobLogCmd(Map<String, Object> params) {
        this.params = params;
    }

    public List<Map<String, String>> execute(CommandContext commandContext) {
        if (this.params != null && this.params.size() > 0) {
            if (SCH_JOB_LOG.equalsIgnoreCase(String.valueOf(this.params.get(SCH_JOB_LOG)))) {
                String jobId = String.valueOf(this.params.get("jobNumber"));
                return this.getSchJobLogList(jobId);
            }
            if (SCH_JOB_ERROR_LOG.equalsIgnoreCase(String.valueOf(this.params.get(SCH_JOB_ERROR_LOG)))) {
                String jobId = String.valueOf(this.params.get("jobId"));
                return this.getSchJobErrorLogList(jobId);
            }
        }
        return null;
    }

    private List<Map<String, String>> getSchJobLogList(String jobId) {
        ArrayList<Map<String, String>> reList = new ArrayList<Map<String, String>>();
        StringBuilder sql = new StringBuilder("SELECT TOP ").append(SHOW_RECORDS_NUMBER);
        sql.append(" A.FJOBID jobId, A.FPROGRESS progress,A.FRUNAT runat,");
        sql.append(" A.FDISPATCHTIME dispatchtime,A.FRUNTIME runtime,A.FENDTIME endtime,A.FSTATUS status, A.FId id");
        sql.append(" FROM T_SCH_TASK A ");
        if (WfUtils.isNotEmpty((String)jobId)) {
            sql.append(" WHERE A.FJOBID =? ");
        }
        sql.append(" ORDER BY A.FDISPATCHTIME DESC");
        DataSet dataSet = DB.queryDataSet((String)this.getAlgoKey("sch_job"), (DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{jobId});
        for (Row row : dataSet) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("jobId", String.valueOf(row.get("jobId")));
            tempMap.put("progress", String.valueOf(row.get("progress")));
            tempMap.put("runat", String.valueOf(row.get("runat")));
            tempMap.put("dispatchtime", String.valueOf(row.get("dispatchtime")));
            tempMap.put("runtime", String.valueOf(row.get("runtime")));
            tempMap.put("endtime", String.valueOf(row.get("endtime")));
            tempMap.put("status", String.valueOf(row.get("status")));
            tempMap.put("id", String.valueOf(row.get("id")));
            reList.add(tempMap);
        }
        return reList;
    }

    private List<Map<String, String>> getSchJobErrorLogList(String jobId) {
        ArrayList<Map<String, String>> reList = new ArrayList<Map<String, String>>();
        StringBuilder sql = new StringBuilder("SELECT TOP ").append(SHOW_RECORDS_NUMBER);
        sql.append(" T.FTASKID taskId,T.FJOBID jobId,");
        sql.append(" T.FEXECUTETIME executetime,T.FRUNAT runat,T.FERRORREASON  errorreason ");
        sql.append(" FROM T_SCH_ERRORJOB  T ");
        sql.append(" WHERE T.FJOBID =? ");
        sql.append(" ORDER BY T.FEXECUTETIME DESC");
        DataSet dataSet = DB.queryDataSet((String)this.getAlgoKey("sch_error_job"), (DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{jobId});
        for (Row row : dataSet) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("jobId", String.valueOf(row.get("jobId")));
            tempMap.put("taskId", String.valueOf(row.get("taskId")));
            tempMap.put("runat", String.valueOf(row.get("runat")));
            tempMap.put("executetime", String.valueOf(row.get("executetime")));
            tempMap.put("errorreason", String.valueOf(row.get("errorreason")));
            reList.add(tempMap);
        }
        return reList;
    }

    private String getAlgoKey(String key) {
        return String.format("wf.support.SearchWfSchJobLogCmd.%s", key);
    }
}

