/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.plugin.AbstractWorkflowSupportPlugin;

public class AnalyticalExpressionPlugin
extends AbstractWorkflowSupportPlugin {
    private static Log logger = LogFactory.getLog(AnalyticalExpressionPlugin.class);
    private static final String BUTTON_ANALYSIS = "button_analysis";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_ANALYSIS});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_ANALYSIS.equals(ctrl.getKey())) {
            logger.debug("click the 'button_analysis' button");
            this.analyticalExpression();
        }
    }

    private void analyticalExpression() {
        IDataModel model = this.getModel();
        Object billnoObj = model.getValue("billno");
        Object entitynumObj = model.getValue("entitynum");
        Object businesskeyObj = model.getValue("businesskey");
        Object expressionObj = model.getValue("expression");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.checkParams(billnoObj, entitynumObj, businesskeyObj, expressionObj)) {
            params.put("billno", null == billnoObj ? "" : String.valueOf(billnoObj));
            params.put("entitynum", null == entitynumObj ? "" : String.valueOf(entitynumObj));
            params.put("businesskey", null == businesskeyObj ? "" : String.valueOf(businesskeyObj));
            params.put("expression", null == expressionObj ? "" : String.valueOf(expressionObj));
            try {
                Map<String, Object> temp = this.getWorkflowSupportToolService().analyticalExpression(params);
                this.getModel().setValue("result", temp.get("result"));
            }
            catch (Exception e1) {
                this.getView().showErrMessage(ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\u3002", (String)"AnalyticalExpressionPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u539f\u56e0\u63cf\u8ff0\uff1a%s", (String)"AnalyticalExpressionPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), WfUtils.getExceptionStacktrace((Throwable)e1)));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6838\u5bf9\u3002", (String)"AnalyticalExpressionPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
    }

    private boolean checkParams(Object billnoObj, Object entitynumObj, Object businesskeyObj, Object expressionObj) {
        if (Objects.nonNull(expressionObj)) {
            return !Objects.isNull(businesskeyObj) && (!Objects.isNull(billnoObj) || !Objects.isNull(entitynumObj));
        }
        return false;
    }
}

