/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class BatchAbandonBizProcessPlugin
extends AbstractWorkflowPlugin {
    private static final String BUTTON_BATCHABANDON = "button_batchabandon";
    private static final String BIZTRACENO = "biztraceno";
    private static final String PROCESSINSTANCEID = "processinstanceid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_BATCHABANDON});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_BATCHABANDON.equals(ctrl.getKey())) {
            IDataModel model = this.getModel();
            Object biztracenoObj = model.getValue(BIZTRACENO);
            if (null == biztracenoObj || WfUtils.isEmpty((String)String.valueOf(biztracenoObj))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u8ddf\u8e2a\u53f7", (String)"BatchAbandonProcessPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            this.executeBatchAbandonBizProcess(biztracenoObj);
        }
    }

    private void executeBatchAbandonBizProcess(Object biztracenoObj) {
        String biztracenos = String.valueOf(biztracenoObj);
        List<Object> biztracenoList = Arrays.asList(biztracenos.split("\n"));
        if (biztracenos.trim().contains(",") && WfUtils.isEmptyForCollection(biztracenoList = Arrays.asList(biztracenos.split(",")))) {
            return;
        }
        Set<Long> procinstIds = this.getProcinstIds(biztracenoList);
        if (WfUtils.isNotEmptyForCollection(procinstIds)) {
            for (Long procinstId : procinstIds) {
                try {
                    WorkflowServiceHelper.abandon((Long)procinstId);
                }
                catch (Exception e) {
                    this.logger.info("batch abandon process occurred exception: procinstId-{},{}", (Object)procinstId, (Object)e);
                }
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u7ec8\u6b62\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"BatchAbandonProcessPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    private Set<Long> getProcinstIds(List<Object> bizTraceNos) {
        HashSet<Long> ret = new HashSet<Long>();
        QFilter[] qFilters = new QFilter(BIZTRACENO, "in", bizTraceNos).toArray();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"wf_execution", (String)PROCESSINSTANCEID, (QFilter[])qFilters);
        if (null != dynamicObjects) {
            for (DynamicObject obj : dynamicObjects) {
                Long procinstId = (Long)obj.get(0);
                ret.add(procinstId);
            }
        }
        return ret;
    }
}

