/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class BatchAbandonProcessPlugin
extends AbstractWorkflowPlugin {
    private static Log logger = LogFactory.getLog(BatchAbandonProcessPlugin.class);
    private static final String BUTTON_BATCHABANDON = "button_batchabandon";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_BATCHABANDON});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_BATCHABANDON.equals(ctrl.getKey())) {
            IDataModel model = this.getModel();
            Object businesskeysObj = model.getValue("businesskeys");
            if (this.checkParams(businesskeysObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u4e3b\u952e", (String)"BatchAbandonProcessPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            this.executeBatchAbandonProcess(businesskeysObj);
        }
    }

    private void executeBatchAbandonProcess(Object businesskeysObj) {
        String businessKey = String.valueOf(businesskeysObj);
        Object[] businessKeys = new String[]{businessKey};
        if (businessKey.contains("\n")) {
            businessKeys = businessKey.split("\n");
        } else if (businessKey.contains("\r")) {
            businessKeys = businessKey.split("\r");
        } else if (businessKey.contains(",")) {
            businessKeys = businessKey.split(",");
        }
        for (int i = 0; i < businessKeys.length; ++i) {
            try {
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKeys[i]);
                continue;
            }
            catch (Exception e) {
                logger.info("batch abandon process occurred exception: businessKey-{},exception-{}", (Object)businessKeys[i], (Object)WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        WfUtils.addOpLog((String)"wf_execution", (String)"batchAbandonProcess", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6279\u91cf\u7ec8\u6b62\u6d41\u7a0b", "BatchAbandonProcessPlugin_3", "bos-wf-unittest"), null, (Object[])new Object[]{String.format("[%s]", StringUtils.join((Object[])businessKeys, (String)","))});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u7ec8\u6b62\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"BatchAbandonProcessPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    private boolean checkParams(Object entitynumberObj) {
        return Objects.isNull(entitynumberObj) || String.valueOf(entitynumberObj).length() == 0;
    }
}

