/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.collections.CollectionUtils;

public class CheckBillPropertyPlugin
extends AbstractWorkflowPlugin {
    private static final String BUTTON_CHECK = "button_check";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String BILLID = "billId";
    private static final String ENTITYID = "wf_billsubjectmodel";
    private static final String PARAM_TIPS = "param_tips";
    private static final String EXIST_TIPS = "exist_tips";
    private static final String CHECK_PC_TIPS = "check_pc_tips";
    private static final String CHECK_MOB_TIPS = "check_mob_tips";
    private static final String CHECK_PASS_TIPS = "check_pass_tips";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CHECK});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_CHECK.equals(ctrl.getKey())) {
            this.checkBillProperties();
        }
    }

    private void checkBillProperties() {
        String entitynumber = (String)this.getModel().getValue(ENTITYNUMBER);
        if (StringUtils.isNotEmpty((String)entitynumber)) {
            String entityId = this.getEntityIdByNumber(entitynumber);
            BillSubjectModelEntity entity = this.getWFService().getRepositoryService().findBillSubject(entityId);
            if (Objects.nonNull(entity)) {
                this.logger.debug(String.format("billId[%s]--billName[%s]", entity.getBillId(), entity.getBillName()));
                List pcData = this.getWFService().getManagementService().getBillPageByType(entityId, "BillFormModel");
                if (CollectionUtils.isEmpty((Collection)pcData)) {
                    this.getView().showTipNotification(this.getFormatTipsStr(CHECK_PC_TIPS));
                    return;
                }
                List mobData = BillPagePluginUtil.getBillPagesForMob((List)pcData, (String)entityId, (boolean)true, (String)entitynumber, null);
                if (CollectionUtils.isEmpty((Collection)mobData)) {
                    this.getView().showTipNotification(this.getFormatTipsStr(CHECK_MOB_TIPS));
                    return;
                }
                this.getView().showSuccessNotification(this.getFormatTipsStr(CHECK_PASS_TIPS));
            } else {
                this.getView().showTipNotification(this.getFormatTipsStr(EXIST_TIPS));
            }
        } else {
            this.getView().showTipNotification(this.getFormatTipsStr(PARAM_TIPS));
        }
    }

    protected WorkflowService getWFService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    private String getEntityIdByNumber(String entityNumber) {
        String entityId = null;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ENTITYNUMBER, "=", (Object)entityNumber));
        DynamicObjectCollection dyCollections = this.getWFService().getManagementService().getBillSubjectModelData(ENTITYID, 1, 10, qFilters, null);
        if (CollectionUtils.isNotEmpty((Collection)dyCollections)) {
            entityId = (String)((DynamicObject)dyCollections.get(0)).get(BILLID);
        }
        return entityId;
    }

    private String getFormatTipsStr(String type) {
        String tips = "";
        if (PARAM_TIPS.equals(type)) {
            tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570\u3002", (String)"CheckBillPropertyPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]);
        }
        if (EXIST_TIPS.equals(type)) {
            tips = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CheckBillPropertyPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]);
        }
        if (CHECK_PC_TIPS.equals(type)) {
            tips = ResManager.loadKDString((String)"\u3010PC\u7aef\u67e5\u770b\u9875\u9762\u5c5e\u6027\u3011\u4e0d\u5b58\u5728\u3002", (String)"CheckBillPropertyPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]);
        }
        if (CHECK_MOB_TIPS.equals(type)) {
            tips = ResManager.loadKDString((String)"\u3010\u79fb\u52a8\u7aef\u67e5\u770b\u9875\u9762\u5c5e\u6027\u3011\u4e0d\u5b58\u5728\u3002", (String)"CheckBillPropertyPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]);
        }
        if (CHECK_PASS_TIPS.equals(type)) {
            tips = ResManager.loadKDString((String)"\u5355\u636e\u5c5e\u6027\u68c0\u9a8c\u901a\u8fc7\u3002", (String)"CheckBillPropertyPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]);
        }
        return tips;
    }
}

