/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.model.ProcessDefinitionStartInfo;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class CheckRepeatableProcess
extends AbstractWorkflowPlugin {
    private static final String GRID_ENTRY = "entryentity";
    private static final String BUTTON_CHECK = "check";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CHECK});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_CHECK.equals(ctrl.getKey())) {
            IDataModel model = this.getModel();
            Object billnos = model.getValue("billnos");
            String entityNumber = (String)model.getValue("entitynumber");
            if (this.checkParams(billnos) || this.checkParams(entityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e1a\u52a1\u5355\u636e\u53f7\u201d\u3001\u201c\u5b9e\u4f53\u7f16\u7801\u201d\u3002", (String)"CheckRepeatableProcess_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            MainEntityType entity = null;
            try {
                entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5b9e\u4f53\u7f16\u7801\u65e0\u6548\u3002", (String)"CheckRepeatableProcess_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.checkRepeatableProcess(billnos, entityNumber, entity);
        }
    }

    private void checkRepeatableProcess(Object billObjects, final String entityNumber, MainEntityType entityType) {
        String finalBillNoNumber;
        String billnos = String.valueOf(billObjects);
        String[] businessKeys = new String[]{billnos};
        if (billnos.contains("\n")) {
            businessKeys = billnos.split("\n");
        } else if (billnos.contains("\r")) {
            businessKeys = billnos.split("\r");
        } else if (billnos.contains(",")) {
            businessKeys = billnos.split(",");
        }
        String billNoNumber = null;
        if (entityType instanceof BillEntityType) {
            billNoNumber = ((BillEntityType)entityType).getBillNo();
        }
        if (this.checkParams(billNoNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u65e0\u5355\u636e\u7f16\u53f7\u5b57\u6bb5\u3002", (String)"CheckRepeatableProcess_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.logger.debug("----------------------------start-------------------------------------------------");
        final ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        for (String billno : businessKeys) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityNumber, (QFilter[])new QFilter[]{new QFilter(billNoNumber, "=", (Object)billno)});
            if (obj == null) continue;
            objs.add(obj);
        }
        ProcessEngineConfigurationImpl impl = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        CommandExecutor commandExecutor = impl.getCommandExecutor();
        Map billProcesses = (Map)commandExecutor.execute((Command)new Command<Map<String, List<String>>>(finalBillNoNumber = billNoNumber){
            private Log logger = LogFactory.getLog(CheckRepeatableProcess.class);
            final /* synthetic */ String val$finalBillNoNumber;
            {
                this.val$finalBillNoNumber = string2;
            }

            public Map<String, List<String>> execute(CommandContext commandContext) {
                HashMap<String, List<String>> result = new HashMap<String, List<String>>();
                List<ProcessDefinitionStartInfo> infos = commandContext.getProcessDefinitionEntityManager().findLatestEnabledProcessDefinitions(entityNumber, "submit", null);
                if ((infos = this.filterDiscardProc(commandContext, infos)) == null || infos.isEmpty()) {
                    this.logger.debug(String.format("%s\u5b9e\u4f53 \u5bf9\u5e94\u7684\u64cd\u4f5csubmit \u672a\u5b9a\u4e49\u6d41\u7a0b.", entityNumber));
                    return Collections.emptyMap();
                }
                for (DynamicObject dyn : objs) {
                    try {
                        result.put(dyn.getString(this.val$finalBillNoNumber), this.findSuitableProcess(commandContext, dyn, infos));
                    }
                    catch (Exception e) {
                        this.logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
                    }
                }
                return result;
            }

            private List<ProcessDefinitionStartInfo> filterDiscardProc(CommandContext commandContext, List<ProcessDefinitionStartInfo> infos) {
                if (infos == null || infos.isEmpty()) {
                    return infos;
                }
                ArrayList<String> keys = new ArrayList<String>(infos.size());
                for (ProcessDefinitionStartInfo info : infos) {
                    keys.add(info.getNumber());
                }
                DynamicObjectCollection cols = QueryServiceHelper.query((String)"wf_model", (String)"key", (QFilter[])new QFilter[]{new QFilter("key", "in", keys), new QFilter("discard", "=", (Object)Character.valueOf('1'))});
                if (cols != null && cols.size() > 0) {
                    Iterator iter = cols.iterator();
                    ArrayList<String> discardKeys = new ArrayList<String>(2);
                    while (iter.hasNext()) {
                        DynamicObject dot = (DynamicObject)iter.next();
                        discardKeys.add(dot.getString("key"));
                    }
                    infos.removeIf(processDefinitionStartInfo -> discardKeys.contains(processDefinitionStartInfo.getNumber()));
                }
                return infos;
            }

            private List<String> findSuitableProcess(CommandContext commandContext, DynamicObject dynamicObject, List<ProcessDefinitionStartInfo> infos) {
                ArrayList<String> ret = new ArrayList<String>();
                BusinessModelVariableScope bizScope = new BusinessModelVariableScope(dynamicObject);
                for (ProcessDefinitionStartInfo info : infos) {
                    try {
                        if (!WfUtils.isEmpty((String)info.getStartCondition()) && !ConditionUtil.hasTrueCondition((String)info.getStartCondition(), (VariableScope)bizScope, null)) continue;
                        ret.add(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b[%1$s/%2$s]", (String)"CheckRepeatableProcess_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), info.getNumber(), info.getVersion()));
                    }
                    catch (Exception e) {
                        this.logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
                    }
                }
                return ret;
            }
        });
        int length = billProcesses.size();
        if (length == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u627e\u5230\u5339\u914d\u7684\u6d41\u7a0b\u3002", (String)"CheckRepeatableProcess_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid grid = (EntryGrid)this.getControl(GRID_ENTRY);
        this.getModel().deleteEntryData(GRID_ENTRY);
        this.getModel().batchCreateNewEntryRow(grid.getKey(), length);
        Set set = billProcesses.entrySet();
        int i = 0;
        for (Map.Entry entry : set) {
            this.getModel().setValue("billno", entry.getKey(), i);
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) {
                this.getModel().setValue("process", (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u6d41\u7a0b", (String)"CheckRepeatableProcess_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), i);
                this.getModel().setValue("repetable", (Object)false, i);
            } else {
                this.getModel().setValue("process", (Object)WfUtils.listToString((Collection)((Collection)entry.getValue()), (String)"    "), i);
                this.getModel().setValue("repetable", (Object)(((List)entry.getValue()).size() > 1 ? 1 : 0), i);
            }
            ++i;
        }
        this.logger.debug("----------------------------end-------------------------------------------------");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u7d22\u5b8c\u6210\u3002", (String)"CheckRepeatableProcess_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    private boolean checkParams(Object entitynumberObj) {
        return Objects.isNull(entitynumberObj) || String.valueOf(entitynumberObj).length() == 0;
    }
}

