/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.plugin.AbstractWorkflowSupportPlugin;

public class CleanHistoricalProcessesDataPlugin
extends AbstractWorkflowSupportPlugin {
    private static Log logger = LogFactory.getLog(CleanHistoricalProcessesDataPlugin.class);
    private static final String BUTTON_CLEAN = "button_clean";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CLEAN});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_CLEAN.equals(ctrl.getKey())) {
            IDataModel model = this.getModel();
            Object billnoObj = model.getValue("billno");
            if (this.checkParams(billnoObj, null, null, null, null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5355\u53f7", (String)"CleanHistoricalProcessesDataPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            this.cleanHistoricalProcessesData();
        }
    }

    private void cleanHistoricalProcessesData() {
        logger.debug("execete business logic: clean historical processes data");
        IDataModel model = this.getModel();
        Object billnoObj = model.getValue("billno");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("billno", billnoObj == null ? "" : String.valueOf(billnoObj));
        try {
            HistoryService historyService = this.getHistoryService();
            this.getWorkflowSupportToolService().cleanHistoricalProcessesData(params);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\u3002", (String)"CleanHistoricalProcessesDataPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        catch (Exception e1) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6e05\u9664\u5931\u8d25\u3002", (String)"CleanHistoricalProcessesDataPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u539f\u56e0\u63cf\u8ff0\uff1a%s", (String)"CleanHistoricalProcessesDataPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), WfUtils.getExceptionStacktrace((Throwable)e1)));
        }
    }

    protected HistoryService getHistoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getHistoryService();
    }

    private boolean checkParams(Object billnoObj, Object entitynumObj, DynamicObject senduserObj, Object startDate, Object endDate) {
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        boolean flag5 = false;
        if (Objects.isNull(billnoObj) || StringUtils.isEmpty((String)String.valueOf(billnoObj))) {
            flag1 = true;
        }
        if (Objects.isNull(entitynumObj) || StringUtils.isEmpty((String)String.valueOf(entitynumObj))) {
            flag2 = true;
        }
        if (Objects.isNull(senduserObj) || StringUtils.isEmpty((String)String.valueOf(senduserObj))) {
            flag3 = true;
        }
        if (Objects.isNull(startDate) || StringUtils.isEmpty((String)String.valueOf(startDate))) {
            flag4 = true;
        }
        if (Objects.isNull(billnoObj) || StringUtils.isEmpty((String)String.valueOf(billnoObj))) {
            flag5 = true;
        }
        return flag1 && flag2 && flag3 && flag4 && flag5;
    }
}

