/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.plugin.AbstractWorkflowSupportPlugin;

public class CleanProcessesInstanceDataPlugin
extends AbstractWorkflowSupportPlugin {
    private static Log logger = LogFactory.getLog(CleanProcessesInstanceDataPlugin.class);
    private static final String BUTTON_CLEAN = "button_clean";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CLEAN});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_CLEAN.equals(ctrl.getKey())) {
            IDataModel model = this.getModel();
            Object entitynumberObj = model.getValue("entitynumber");
            if (this.checkParams(entitynumberObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5b9e\u4f53\u7f16\u7801", (String)"CleanProcessesInstanceDataPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            String entitynumber = String.valueOf(entitynumberObj);
            try {
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitynumber);
                if (null == mainEntityType) {
                    this.cleanProcessesData(entitynumberObj);
                    return;
                }
            }
            catch (Exception e) {
                this.cleanProcessesData(entitynumberObj);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4ecd\u5b58\u5728\uff0c\u65e0\u9700\u6e05\u9664\u3002", (String)"CleanProcessesInstanceDataPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
    }

    private void cleanProcessesData(Object entitynumberObj) {
        logger.debug("execete business logic: clean processes data");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entitynumber", entitynumberObj == null ? "" : String.valueOf(entitynumberObj));
        params.put("sourceFlag", "sourceflag_entitynumber");
        try {
            this.getWorkflowSupportToolService().cleanHistoricalProcessesData(params);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\u3002", (String)"CleanProcessesInstanceDataPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        catch (Exception e1) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6e05\u9664\u5931\u8d25\u3002", (String)"CleanProcessesInstanceDataPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u539f\u56e0\u63cf\u8ff0\uff1a%s", (String)"CleanHistoricalProcessesDataPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), WfUtils.getExceptionStacktrace((Throwable)e1)));
        }
    }

    private boolean checkParams(Object entitynumberObj) {
        return Objects.isNull(entitynumberObj) || String.valueOf(entitynumberObj).length() == 0;
    }
}

