/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class ClearBillOpVerifyCachePlugin
extends AbstractWorkflowPlugin {
    private static Log log = LogFactory.getLog(ClearBillOpVerifyCachePlugin.class);
    private final String TXT_ENTITYNUMBER = "txt_entitynumber";
    private final String TXT_BILLNO = "txt_billno";
    private final String TXT_BUSINESSKEY = "txt_businesskey";
    private final String BTN_CLEARCACHEALL = "btn_clearcacheall";
    private final String BTN_CLEARCACHEDETAIL = "btn_clearcachedetail";
    private String entityNumberStr;
    private String businessKeyStr;
    private String[] businessKeysForCache;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_clearcacheall", "btn_clearcachedetail"});
    }

    public void click(EventObject evt) {
        if (null == evt) {
            log.debug("kd.bos.workflow.support.ClearBillOpVerifyCachePlugin.click evt is null.");
            return;
        }
        Control control = (Control)evt.getSource();
        if (null == control) {
            log.debug("kd.bos.workflow.support.ClearBillOpVerifyCachePlugin.click control is null.");
            return;
        }
        String key = control.getKey();
        log.debug("kd.bos.workflow.support.ClearBillOpVerifyCachePlugin.click key : " + key);
        this.entityNumberStr = (String)this.getModel().getValue("txt_entitynumber");
        boolean existForEntityNumber = BillPagePluginUtil.isExistForFormId((String)this.entityNumberStr);
        if (!existForEntityNumber) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5b9e\u4f53\u7f16\u7801\u3002", (String)"ClearBillOpVerifyCachePlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "btn_clearcacheall": {
                this.doClearCacheAll();
                break;
            }
            case "btn_clearcachedetail": {
                this.doClearCacheDetail();
                break;
            }
        }
    }

    private void doClearCacheAll() {
        boolean isVerifySucess = this.verifyProcessState();
        if (!isVerifySucess || null == this.businessKeysForCache || 0 == this.businessKeysForCache.length) {
            return;
        }
        boolean runningJob = false;
        boolean retrying = false;
        int successCount = 0;
        for (String key : this.businessKeysForCache) {
            if (null == key || key.isEmpty() || (runningJob = this.getRuntimeService().isRunning(key, null, null)) || (retrying = this.getRuntimeService().isRetrying(key, null, null))) continue;
            WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)key, (String)this.entityNumberStr);
            ++successCount;
        }
        if (0 == successCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5f53\u524d\u5b9e\u4f53\u6240\u6709\u4efb\u52a1\u6b63\u5728\u6d41\u8f6c\u6216\u91cd\u8bd5\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_9", (String)"bos-wf-unittest", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff1a\u5f53\u524d\u5b9e\u4f53\u4e0d\u5728\u6d41\u7a0b\u4e2d\u7684\u6240\u6709\u7f13\u5b58\u5df2\u5220\u9664\u3002\u6b63\u5728\u8fd0\u8f6c\u4ee5\u53ca\u91cd\u8bd5\u7684\u7f13\u5b58\u4e0d\u80fd\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_10", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private void doClearCacheDetail() {
        boolean isVerifySucess = this.verifyInputInfo();
        if (!isVerifySucess) {
            return;
        }
        WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)this.businessKeyStr, (String)this.entityNumberStr);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff1a\u5f53\u524d\u5355\u636e\u5728\u6d41\u7a0b\u4e2d\u7f13\u5b58\u5df2\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_8", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    private boolean verifyInputInfo() {
        boolean emptyForBusinessKey;
        String errorNotification = null;
        Object billNo = this.getModel().getValue("txt_billno");
        boolean emptyForBillNo = null == billNo || WfUtils.isEmptyString((Object)billNo);
        Object businessKey = this.getModel().getValue("txt_businesskey");
        boolean bl = emptyForBusinessKey = null == businessKey || WfUtils.isEmptyString((Object)businessKey);
        if (emptyForBillNo && emptyForBusinessKey) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u8bf7\u8f93\u5165\u5355\u636e\u7f16\u7801 \u6216 \u5355\u636e\u4e3b\u952e\u3002", (String)"ClearBillOpVerifyCachePlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        boolean isExistData = false;
        if (!emptyForBusinessKey) {
            isExistData = QueryServiceHelper.exists((String)this.entityNumberStr, (Object)businessKey);
            this.businessKeyStr = businessKey.toString();
        } else {
            DynamicObject billInfo = BusinessDataServiceHelper.loadSingleFromCache((String)this.entityNumberStr, (QFilter[])new QFilter[]{new QFilter("billno", "=", billNo)});
            if (null == billInfo) {
                isExistData = false;
            } else {
                Object billInfoId = billInfo.get("id");
                if (null == billInfoId || WfUtils.isEmptyString((Object)billInfoId)) {
                    isExistData = false;
                } else {
                    this.businessKeyStr = billInfoId.toString();
                    isExistData = true;
                }
            }
        }
        if (!isExistData) {
            errorNotification = !emptyForBusinessKey ? ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u6839\u636e\u5355\u636e\u4e3b\u952e\u67e5\u8be2\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ClearBillOpVerifyCachePlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u6839\u636e\u5355\u636e\u7f16\u7801\u67e5\u8be2\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ClearBillOpVerifyCachePlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorNotification);
            return false;
        }
        return this.verifyProcessState();
    }

    private boolean verifyProcessState() {
        this.businessKeysForCache = WfCacheHelper.getExecutingBusinesskeysByEntityNumber((String)this.entityNumberStr);
        if (null == this.businessKeysForCache || 0 == this.businessKeysForCache.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a\uff1a\u5f53\u524d\u5b9e\u4f53\u7f13\u5b58\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        if (null == this.businessKeyStr) {
            return true;
        }
        List<String> businessKeyList = Arrays.asList(this.businessKeysForCache);
        if (!businessKeyList.contains(this.businessKeyStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a\uff1a\u5f53\u524d\u5355\u636e\u7f13\u5b58\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        boolean runningJob = this.getRuntimeService().isRunning(this.businessKeyStr, null, null);
        if (runningJob) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5f53\u524d\u5355\u636e\u4efb\u52a1\u6b63\u5728\u6d41\u8f6c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        boolean retrying = this.getRuntimeService().isRetrying(this.businessKeyStr, null, null);
        if (retrying) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5f53\u524d\u5355\u636e\u7f13\u4efb\u52a1\u6b63\u5728\u91cd\u8bd5\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ClearBillOpVerifyCachePlugin_7", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

