/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.design.plugin.event.AfterExportProcessEvent;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.BillSettingProcessor;
import kd.bos.workflow.engine.impl.cmd.model.BillSubjectProcessor;
import kd.bos.workflow.engine.impl.cmd.model.ConditionalRuleProcessor;
import kd.bos.workflow.engine.impl.cmd.model.IModelProcessor;
import kd.bos.workflow.engine.impl.cmd.model.ParticipantProcessor;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.management.plugin.event.AfterExportSchemesEvent;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.plugin.CleanProcessesInstanceDataPlugin;
import org.apache.commons.io.FilenameUtils;

public class ExportOldVersionPorcessPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CleanProcessesInstanceDataPlugin.class);
    private static Map<String, IModelProcessor> processorMap = new HashMap<String, IModelProcessor>();

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"process", "role"});
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                this.exportData();
                break;
            }
        }
        super.click(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "type": {
                this.controlFieldDisplay(this.getModel().getValue("type"));
                break;
            }
        }
        super.propertyChanged(e);
    }

    private void controlFieldDisplay(Object type) {
        if ("model".equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"process", "role"});
        } else if ("process".equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"process"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model", "role"});
        } else if ("role".equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"role"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model", "process"});
        }
    }

    private void exportData() {
        String type = (String)this.getModel().getValue("type");
        if ("model".equals(type)) {
            this.exportModel();
        } else if ("process".equals(type)) {
            this.exportScheme();
        }
    }

    private void exportModel() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_model", (String)"4730fc9f000004ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = (DynamicObject)this.getModel().getValue("model");
        if (obj == null) {
            return;
        }
        String fileName = obj.getString("key");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_modifyexportfilename");
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u6d41\u7a0b", (String)"WorkflowModelManagePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("key", (Object)fileName);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modelFileExportClose"));
        this.getView().showForm(parameter);
    }

    private void exportScheme() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"4730fc9f000004ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bfc\u51fa\u6d41\u7a0b\u53ca\u65b9\u6848\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowManageCenterPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = (DynamicObject)this.getModel().getValue("process");
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"WorkflowManageCenterPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long procdefId = obj.getLong("id");
        ProcessDefinitionEntity definitionEntity = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().getProcessdefineById(procdefId);
        String fileName = definitionEntity.getKey();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_modifyexportfilename");
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u6d41\u7a0b\u53ca\u6d41\u7a0b\u52a8\u6001\u65b9\u6848", (String)"WorkflowManageCenterPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("key", (Object)fileName);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mprocessFileExportClose"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "mprocessFileExportClose": {
                this.packedZipAndExportFile(closedCallBackEvent, "process");
                break;
            }
            case "modelFileExportClose": {
                this.packedZipAndExportFile(closedCallBackEvent, "model");
                break;
            }
        }
    }

    private void packedZipAndExportFile(ClosedCallBackEvent closedCallBackEvent, String type) {
        ArrayList<String> modelIds;
        ArrayList<Long> processDefinitionIds;
        block51: {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            String filename = (String)closedCallBackEvent.getReturnData();
            String path = System.getProperty("user.home") + File.separator + "KINGDEEDOWNLOAD" + File.separator + "workflow0";
            String localPath = FilenameUtils.normalize((String)(path + File.separator + WfUtils.now().getTime()));
            File localFile = new File(FilenameUtils.getName((String)localPath));
            if (!localFile.exists()) {
                localFile.mkdirs();
            }
            String zipFilename = String.format("%s.zip", filename);
            String fullPath = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
            File zipFile = new File(FilenameUtils.getName((String)fullPath));
            processDefinitionIds = new ArrayList<Long>(1);
            modelIds = new ArrayList<String>(1);
            try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
                DeployFile df = this.getNewDeployFile(processDefinitionIds, modelIds, type);
                String content = df.getFileContent();
                try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
                    String fileName = df.getFileName();
                    ZipEntry entry = new ZipEntry(fileName);
                    entry.setMethod(8);
                    out.putNextEntry(entry);
                    int n = 0;
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                }
                catch (Exception e) {
                    logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                    throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), "exportSchemes")});
                }
            }
            catch (IOException e) {
                if (localFile.exists()) {
                    this.deleteFile(localFile);
                }
                throw new RuntimeException(e);
            }
            String downloadFile = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
            try (FileInputStream in = new FileInputStream(FilenameUtils.getName((String)downloadFile));){
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFilename, (InputStream)in, 5000);
                this.getView().openUrl(url);
            }
            catch (FileNotFoundException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            catch (IOException e) {
                this.getView().showErrorNotification(e.getMessage());
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                if (!localFile.exists()) break block51;
                this.deleteFile(localFile);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"WorkflowManageCenterPlugin_48", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        if ("model".equals(type)) {
            this.fireAfterExportProcess(modelIds, "wfdesigner");
        } else if ("process".equals(type)) {
            this.fireAfterExportSchemes(processDefinitionIds, "wfscheme");
        }
    }

    private DeployFile getNewDeployFile(List<Long> processDefinitionIds, List<String> modelIds, String type) {
        DeployFile deployFileOld = null;
        if ("process".equals(type)) {
            DynamicObject obj = (DynamicObject)this.getModel().getValue("process");
            processDefinitionIds.add(obj.getLong("id"));
            deployFileOld = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().getExportScheme(obj.getLong("id"));
            if (deployFileOld == null) {
                return null;
            }
            DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            ExportScheme exportScheme = (ExportScheme)serializer.deserializeFromString(deployFileOld.getFileContent(), null);
            this.dealWorkFlowRoles(exportScheme.getRoles());
            List resources = exportScheme.getResources();
            HashMap<Integer, DynamicObject> otherResources = new HashMap<Integer, DynamicObject>(resources.size());
            HashMap<Long, Long> removeParticipants = new HashMap<Long, Long>(resources.size());
            for (int i = 0; i < resources.size(); ++i) {
                DynamicObject resource2 = (DynamicObject)resources.get(i);
                if (WfUtils.isEmpty((String)resource2.getString("data"))) continue;
                if (resource2.getString("data").startsWith("[")) {
                    otherResources.put(i, resource2);
                    continue;
                }
                JSONObject data = (JSONObject)JSONObject.parse((String)resource2.getString("data"));
                if (data.getJSONObject("stencil") == null || !"BPMNDiagram".equals(data.getJSONObject("stencil").getString("id"))) {
                    otherResources.put(i, resource2);
                    continue;
                }
                this.dealResource(resource2, removeParticipants);
                resources.set(i, resource2);
            }
            otherResources.forEach((index, resource) -> {
                this.dealResource((DynamicObject)resource, (Map<Long, Long>)removeParticipants);
                resources.set((int)index, resource);
            });
            return exportScheme.toDeployFile(deployFileOld.getFileName());
        }
        DynamicObject obj = (DynamicObject)this.getModel().getValue("model");
        modelIds.add(obj.getString("key"));
        deployFileOld = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().getDeployModel(obj.getLong("id"));
        if (deployFileOld == null) {
            return null;
        }
        DcxmlSerializer serializer = new DcxmlSerializer(DeployModel.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployModel exportScheme = (DeployModel)serializer.deserializeFromString(deployFileOld.getFileContent(), null);
        this.dealWorkFlowRoles(exportScheme.getRoles());
        List resources = exportScheme.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            DynamicObject resource3 = (DynamicObject)resources.get(i);
            if (resource3.getString("data") == null) continue;
            this.dealResource(resource3, new HashMap<Long, Long>(1));
            resources.set(i, resource3);
        }
        return exportScheme.toDeployFile(deployFileOld.getFileName());
    }

    private void dealWorkFlowRoles(List<DynamicObject> roles) {
        if (WfUtils.isEmptyForCollection(roles)) {
            return;
        }
        for (DynamicObject role : roles) {
            String dimensions = role.getString("roledimension");
            if (!WfUtils.isNotEmpty((String)dimensions) || !dimensions.contains("dimensions")) continue;
            Map dimensionInfos = (Map)SerializationUtils.fromJsonString((String)dimensions, Map.class);
            role.set("roledimension", dimensionInfos.get("dimensions"));
        }
    }

    private void dealResource(DynamicObject resource, Map<Long, Long> removeParticipants) {
        Object dataObj = JSONObject.parse((String)resource.getString("data"));
        if (dataObj instanceof JSONObject) {
            JSONObject data = (JSONObject)dataObj;
            JSONArray childShapes = data.getJSONArray("childShapes");
            if (childShapes == null || childShapes.isEmpty()) {
                return;
            }
            for (Object childShape : childShapes) {
                JSONObject jsonShape = (JSONObject)childShape;
                JSONObject properties = jsonShape.getJSONObject("properties");
                this.removeUnKnowParticipant(properties, removeParticipants);
            }
            data.put("childShapes", (Object)childShapes);
            resource.set("data", (Object)JSONObject.toJSONString((Object)data));
        } else if (dataObj instanceof JSONArray) {
            JSONArray arr = (JSONArray)dataObj;
            Iterator iterator = arr.iterator();
            while (iterator.hasNext()) {
                Object data = iterator.next();
                if (!(data instanceof JSONObject)) continue;
                String op = ((JSONObject)data).getString("op");
                String path = ((JSONObject)data).getString("path");
                Object value = ((JSONObject)data).get((Object)"value");
                if (!"add".equals(op) && !"replace".equals(op) || path == null || !path.contains("participant") && (!path.contains("expireModel/timeControls") || !path.contains("operation/config")) || !this.needRemove(path, removeParticipants) && (!(value instanceof JSONObject) || !"relation".equals(((JSONObject)value).getString("type")) && !"position".equals(((JSONObject)value).getString("type")))) continue;
                iterator.remove();
            }
            resource.set("data", (Object)JSONArray.toJSONString((Object)arr));
        }
    }

    private boolean needRemove(String path, Map<Long, Long> removeParticipants) {
        Set<Long> ids = removeParticipants.keySet();
        for (Long id : ids) {
            if (!path.contains(id.toString())) continue;
            return true;
        }
        return false;
    }

    private void removeUnKnowParticipant(JSONObject object, Map<Long, Long> removeParticipants) {
        Iterator keys = object.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object tmpValue = object.get((Object)key);
            if (tmpValue instanceof JSONObject) {
                this.removeUnKnowParticipant((JSONObject)tmpValue, removeParticipants);
                continue;
            }
            if (!(tmpValue instanceof JSONArray)) continue;
            JSONArray tmpArray = (JSONArray)tmpValue;
            if ("participant".equals(key) || "participantAllow".equals(key) || "participantBlackList".equals(key) || "receiver".equals(key) || "timeControls".equals(key)) {
                Iterator iterator = tmpArray.iterator();
                while (iterator.hasNext()) {
                    String selectedType;
                    JSONObject participantJson = (JSONObject)iterator.next();
                    if ("timeControls".equals(key) && participantJson.get((Object)"operation") instanceof JSONObject && "transferExpire".equals(participantJson.getJSONObject("operation").getString("operationNumber"))) {
                        String config = participantJson.getJSONObject("operation").getString("config");
                        participantJson = (JSONObject)JSONObject.parse((String)config);
                    }
                    String string = selectedType = WfUtils.isNotEmpty((String)participantJson.getString("selectedType")) ? participantJson.getString("selectedType") : participantJson.getString("type");
                    if ("relation".equals(selectedType) || "position".equals(selectedType)) {
                        removeParticipants.put(participantJson.getLong("id"), participantJson.getLong("id"));
                        iterator.remove();
                        continue;
                    }
                    if (!removeParticipants.containsKey(participantJson.getLong("id"))) continue;
                    iterator.remove();
                }
                if (!WfUtils.isEmptyForCollection((Collection)tmpArray)) continue;
                keys.remove();
                object.remove((Object)key);
                continue;
            }
            for (Object o : tmpArray) {
                if (!(o instanceof JSONObject)) continue;
                this.removeUnKnowParticipant((JSONObject)o, removeParticipants);
            }
        }
    }

    private void fireAfterExportProcess(List<String> processNumbers, String scene) {
        try {
            AfterExportProcessEvent evt = new AfterExportProcessEvent((Object)this.getView(), scene, "afterExportProcess", null, processNumbers);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)evt);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b\u5bfc\u51fa\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowModelManagePlugin_52", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void fireAfterExportSchemes(List<Long> processDefinitionIds, String scene) {
        try {
            AfterExportSchemesEvent evt = new AfterExportSchemesEvent((Object)this.getView(), scene, "afterExportSchemes", null, processDefinitionIds);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)evt);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u65b9\u6848\u5bfc\u51fa\u4e8b\u4ef6\u89e6\u53d1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowManageCenterPlugin_65", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void deleteFile(File file) {
        try {
            if (!file.isDirectory()) {
                if (!file.delete()) {
                    logger.error("file delete failed! " + file.getCanonicalPath());
                }
            } else if (file.isDirectory()) {
                File[] fileList = file.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    File delfile = fileList[i];
                    if (!delfile.isDirectory()) {
                        if (delfile.delete()) continue;
                        logger.error("file delete failed! " + delfile.getCanonicalPath());
                        continue;
                    }
                    if (!delfile.isDirectory()) continue;
                    this.deleteFile(fileList[i]);
                }
                if (!file.delete()) {
                    logger.error("file delete failed! " + file.getCanonicalPath());
                }
            }
        }
        catch (IOException e) {
            logger.error("delete error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId((IFormView)this.getView());
    }

    static {
        processorMap.put("participant", (IModelProcessor)new ParticipantProcessor());
        processorMap.put("receiver", (IModelProcessor)new ParticipantProcessor());
        processorMap.put("circulator", (IModelProcessor)new ParticipantProcessor());
        processorMap.put("coordinator", (IModelProcessor)new ParticipantProcessor());
        processorMap.put("personRangeSetting", (IModelProcessor)new ParticipantProcessor());
        processorMap.put("condition", (IModelProcessor)new ConditionalRuleProcessor());
        processorMap.put("subject", (IModelProcessor)new BillSubjectProcessor());
        processorMap.put("billSetting", (IModelProcessor)new BillSettingProcessor());
    }
}

