/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.process.ProcessInstData;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class HistoricActivityMakerPlugin
extends AbstractListPlugin {
    private static final String BTNMIGRATE = "btnmigrate";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BTNMIGRATE});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTNMIGRATE.equals(evt.getItemKey())) {
            this.migrate();
        }
    }

    private void migrate() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null) {
            if (!rows.isEmpty()) {
                ArrayList<Long> actIds = new ArrayList<Long>(10);
                for (ListSelectedRow row : rows) {
                    actIds.add((Long)row.getPrimaryKeyValue());
                }
                DynamicObjectCollection hiActInsts = QueryServiceHelper.query((String)"wf_hiactinst", (String)String.format("%s,%s", "id", "processInstanceId"), (QFilter[])new QFilter[]{new QFilter("id", "in", actIds)});
                HashSet<Long> procInstIds = new HashSet<Long>(16);
                for (DynamicObject hiActInst : hiActInsts) {
                    if (!WfUtils.isNotEmpty((Long)hiActInst.getLong("processInstanceId"))) continue;
                    procInstIds.add(hiActInst.getLong("processInstanceId"));
                }
                DynamicObjectCollection hiProcInsts = QueryServiceHelper.query((String)"wf_hiprocinst", (String)String.format("%s,%s,%s", "id", "rootProcessInstanceId", "processtype"), (QFilter[])new QFilter[]{new QFilter("id", "in", procInstIds)});
                Long rootProcInstId = null;
                for (DynamicObject hiProcInst : hiProcInsts) {
                    if (!ProcessType.AuditFlow.name().equals(hiProcInst.get("processtype"))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u4ec5\u652f\u6301\u5de5\u4f5c\u6d41\uff0c\u6d41\u7a0b\u5b9e\u4f8b[%1$s]\u6d41\u7a0b\u7c7b\u578b\u4e3a[%2$s]\u3002", (String)"HistoricActivityMakerPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]), hiProcInst.getLong("id"), hiProcInst.get("processtype")));
                        return;
                    }
                    Long tRootProcInstId = null;
                    tRootProcInstId = WfUtils.isNotEmpty((Long)hiProcInst.getLong("rootProcessInstanceId")) ? Long.valueOf(hiProcInst.getLong("rootProcessInstanceId")) : Long.valueOf(hiProcInst.getLong("id"));
                    if (rootProcInstId != null && !rootProcInstId.equals(tRootProcInstId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u6d41\u7a0b\u5b9e\u4f8b\u7684\u6d3b\u52a8\u5b9e\u4f8b\u6570\u636e\u3002", (String)"HistoricActivityMakerPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
                        return;
                    }
                    rootProcInstId = tRootProcInstId;
                }
                DynamicObjectCollection rootHiProcInsts = QueryServiceHelper.query((String)"wf_hiprocinst", (String)String.format("%s,%s,%s", "id", "endTime", "processtype"), (QFilter[])new QFilter[]{new QFilter("id", "=", rootProcInstId)});
                if (WfUtils.isNotEmptyForCollection((Collection)rootHiProcInsts)) {
                    DynamicObject rootHiProcInst = (DynamicObject)rootHiProcInsts.get(0);
                    if (!ProcessType.AuditFlow.name().equals(rootHiProcInst.get("processtype"))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u4ec5\u652f\u6301\u5de5\u4f5c\u6d41\uff0c\u6d41\u7a0b\u5b9e\u4f8b[%1$s]\u6d41\u7a0b\u7c7b\u578b\u4e3a[%2$s]\u3002", (String)"HistoricActivityMakerPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]), rootHiProcInst.getLong("id"), rootHiProcInst.get("processtype")));
                        return;
                    }
                    if (rootHiProcInst.getDate("endTime") == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u4ec5\u652f\u6301\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u8fc1\u79fb\uff0c\u6d41\u7a0b\u5b9e\u4f8b[%s]\u4e3a\u5728\u9014\u6d41\u7a0b\u3002", (String)"HistoricActivityMakerPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]), rootHiProcInst.getLong("id")));
                        return;
                    }
                }
                ProcessInstData peocessData = this.getMigrateProcessData(rootProcInstId, actIds);
                IWorkflowService workflowService = (IWorkflowService)ServiceFactory.getService(WorkflowService.class);
                workflowService.makeProcessInst(peocessData);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"HistoricActivityMakerPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"HistoricActivityMakerPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        }
    }

    private ProcessInstData getMigrateProcessData(Long procInstId, List<Long> actIds) {
        WFDevopsService wfService = (WFDevopsService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(WFDevopsService.class);
        return wfService.getProcessMakeData(procInstId, actIds);
    }
}

