/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.mvc.bill.BillView;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;

public class ImageListApDemoPlugin
extends AbstractWorkflowPlugin
implements UploadListener {
    private static final String IMAGELISTURLS = "imagelisturl";
    private static final String IMAGELISTAP = "imagelistap";

    public void registerListener(EventObject e) {
        ImageList imageList = (ImageList)this.getControl(IMAGELISTAP);
        imageList.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        if (null == evt) {
            return;
        }
        Object[] urls = evt.getUrls();
        if (null == urls || 0 == urls.length) {
            return;
        }
        String imgerUrlValueNew = this.getImgerUrlValueStr(Arrays.asList(urls));
        if (imgerUrlValueNew.isEmpty()) {
            return;
        }
        Object imageUrlValue = this.getModel().getValue(IMAGELISTURLS);
        if (null != imageUrlValue && !imageUrlValue.toString().isEmpty()) {
            imgerUrlValueNew = imageUrlValue + "," + imgerUrlValueNew;
        }
        this.getModel().setValue(IMAGELISTURLS, (Object)imgerUrlValueNew);
    }

    public void remove(UploadEvent evt) {
        if (null == evt) {
            return;
        }
        Object[] urls = evt.getUrls();
        if (null == urls || 0 == urls.length) {
            return;
        }
        Object imageUrlValue = this.getModel().getValue(IMAGELISTURLS);
        if (null == imageUrlValue) {
            return;
        }
        String[] imageUrlValues = imageUrlValue.toString().split(",");
        if (null == imageUrlValues || 0 == imageUrlValues.length) {
            return;
        }
        ArrayList<String> imageUrlValuesList = new ArrayList<String>(Arrays.asList(imageUrlValues));
        imageUrlValuesList.removeAll(Arrays.asList(urls));
        String imgerUrlValueNew = this.getImgerUrlValueStr(imageUrlValuesList);
        this.getModel().setValue(IMAGELISTURLS, (Object)imgerUrlValueNew);
    }

    public void afterBindData(EventObject e) {
        if (null == e) {
            return;
        }
        BillView billView = (BillView)e.getSource();
        if (null == billView) {
            return;
        }
        Object imageUrl = billView.getModel().getDataEntity().get(IMAGELISTURLS);
        if (null == imageUrl || imageUrl.toString().isEmpty()) {
            return;
        }
        String[] urls = imageUrl.toString().split(",");
        ImageList imageList = (ImageList)this.getControl(IMAGELISTAP);
        imageList.setImageUrls(urls);
    }

    private String getImgerUrlValueStr(List imageUrlValuesList) {
        if (null == imageUrlValuesList || imageUrlValuesList.isEmpty()) {
            return "";
        }
        StringBuilder strB = new StringBuilder();
        for (Object url : imageUrlValuesList) {
            if (null == url || url.toString().isEmpty()) continue;
            strB.append(url).append(",");
        }
        if (strB.toString().isEmpty()) {
            return "";
        }
        return strB.substring(0, strB.length() - 1);
    }
}

