/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.fs.util.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.plugin.AbstractWorkflowSupportPlugin;

public class ResendFailJobPlugin
extends AbstractWorkflowSupportPlugin {
    private static final String BUTTON_RESEND_JOB = "button_resend_job";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_RESEND_JOB});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_RESEND_JOB.equals(ctrl.getKey())) {
            this.resendJob();
        }
    }

    private void resendJob() {
        IDataModel model = this.getModel();
        Object jobIdObj = model.getValue("jobId");
        Object dataSource = model.getValue("datasource");
        if (Objects.isNull(jobIdObj) || StringUtils.isEmpty((String)String.valueOf(jobIdObj))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165jobId", (String)"ResendFailJobPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("jobId", String.valueOf(jobIdObj).trim());
            params.put("dataSource", dataSource == null ? "dbRoute_wf" : String.valueOf(dataSource).trim());
            jobIdObj = model.getValue("type");
            params.put("type", jobIdObj);
            boolean result = this.getWorkflowSupportToolService().resendFailJobForProcess(params);
            if (result) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"job\u91cd\u53d1\u6210\u529f\u3002", (String)"ResendFailJobPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"job\u91cd\u53d1\u5931\u8d25\u3002", (String)"ResendFailJobPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        }
        catch (Exception e1) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"job\u91cd\u53d1\u5f02\u5e38\u3002", (String)"ResendFailJobPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u539f\u56e0\u63cf\u8ff0\uff1a%s", (String)"ResendFailJobPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]), WfUtils.getExceptionStacktrace((Throwable)e1)));
        }
    }
}

