/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.plugin.JobTraceTreeNode;
import kd.bos.workflow.support.plugin.TreeBuilderUtil;
import kd.bos.workflow.support.util.WfSupportUtil;

public class SearchWfJobrecordPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(SearchWfJobrecordPlugin.class);
    private static final String BUTTON_SEARCH = "btnsearch";
    private static final String BUTTON_CLOSE = "btnclose";
    private static final String SEARCH_KEY = "key";
    private static final String ENTRY_LOG = "entrylog";
    private static final String PROCINSTID = "procinstid";
    private static final String PROCDEFID = "procdefid";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String NODENUM = "nodenum";
    private static final String NODENAME = "nodename";
    private static final String DURATION = "duration";
    private static final String PDURATION = "pduration";
    private static final String JOBID = "jobid";
    private static final String ENDTIME = "endtime";
    private static final String HANDLERTYPE = "handlertype";
    private static final String SRCJOBID = "srcjobid";
    private static final String ROOTJOBID = "rootjobid";
    private static final String BUSINESSKEY = "businesskey";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String ENTITYNAME = "entityname";
    private static final String BILLNO = "billno";
    private static final String BIZTRACENO = "biztraceno";
    private static final String BUSINESSKEYS = "businessKeys";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_LOG);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BUTTON_SEARCH, BUTTON_CLOSE});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_SEARCH.equals(ctrl.getKey())) {
            this.searchJobrecords();
        }
        if (BUTTON_CLOSE.equals(ctrl.getKey())) {
            this.getView().close();
        }
    }

    private void searchJobrecords() {
        this.getPageCache().put(PROCINSTID, "");
        this.getPageCache().put(PROCDEFID, "");
        this.getModel().deleteEntryData(ENTRY_LOG);
        Object key = this.getModel().getValue("key");
        if (WfUtils.isEmptyString((Object)key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5355\u53f7/\u4e1a\u52a1\u4e3b\u952e/\u4e1a\u52a1\u8ddf\u8e2a\u53f7", (String)"SearchWfJobrecordPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        ArrayList<JobTraceTreeNode> jobrecords = new ArrayList();
        if (this.isBizTraceNo(key.toString()).booleanValue()) {
            String biztraceno = key.toString();
            this.getBusinesskey(biztraceno);
            jobrecords = this.getJobRecordByBKOrTraceNo(biztraceno, BIZTRACENO);
        } else {
            String businesskey = this.getBusinesskey(key.toString());
            jobrecords = this.getJobRecordByBKOrTraceNo(WfUtils.isEmpty((String)businesskey) ? key.toString() : businesskey, BUSINESSKEY);
        }
        this.buildListData(jobrecords);
    }

    private void buildListData(List<JobTraceTreeNode> jobrecords) {
        if (WfUtils.isNotEmptyForCollection(jobrecords)) {
            Map<String, String> pluginInfos = this.initPluginInfos();
            ArrayList<JobTraceTreeNode> allData = new ArrayList<JobTraceTreeNode>(16);
            List<String> rootNodeIds = this.findRootNodeId(jobrecords);
            ListIterator<String> iterator = rootNodeIds.listIterator();
            while (iterator.hasNext()) {
                String rootnodeId = (String)iterator.next();
                List<JobTraceTreeNode> treeNodeList = this.getTraceLevel(jobrecords, rootnodeId);
                allData.addAll(treeNodeList);
            }
            int size = allData.size();
            if (size > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRY_LOG, size);
                Map<String, String> hiActInfo = this.getHistoryActInfo();
                Map<String, String> procDefInfo = this.getProcDefInfo();
                for (int i = 0; i < allData.size(); ++i) {
                    this.rebuildData((JobTraceTreeNode)allData.get(i), i, pluginInfos, hiActInfo, procDefInfo);
                }
            }
        }
    }

    private void rebuildData(JobTraceTreeNode item, int i, Map<String, String> pluginInfos, Map<String, String> hiActInfo, Map<String, String> procDefInfo) {
        int d;
        Map<String, String> jobTypes = this.getJobTyps();
        this.getModel().setValue(JOBID, (Object)(this.getBlankCharLength(item.getLevel()) + item.getId()), i);
        this.getModel().setValue(SRCJOBID, (Object)item.getSrcjobid(), i);
        this.getModel().setValue(ROOTJOBID, (Object)item.getRootjobid(), i);
        this.getModel().setValue(ENTITYNUMBER, (Object)item.getEntitynumber(), i);
        this.getModel().setValue(ENTITYNAME, (Object)item.getEntityname(), i);
        this.getModel().setValue(BUSINESSKEY, (Object)item.getBusinesskey(), i);
        this.getModel().setValue("procnum", (Object)procDefInfo.get("key"), i);
        this.getModel().setValue("procname", (Object)procDefInfo.get(NAME), i);
        this.getModel().setValue("procversion", (Object)procDefInfo.get(VERSION), i);
        String elementId = item.getElementid();
        if (WfUtils.isNotEmpty((String)elementId)) {
            this.getModel().setValue(NODENUM, (Object)elementId, i);
            this.getModel().setValue(NODENAME, (Object)(hiActInfo.get(elementId) != null ? hiActInfo.get(elementId) : ""), i);
        }
        this.getModel().setValue("starttime", (Object)item.getCreatedate(), i);
        this.getModel().setValue(ENDTIME, (Object)item.getEndtime(), i);
        this.getModel().setValue("runat", (Object)WfSupportUtil.desensitizeIP(item.getExecutor()), i);
        this.getModel().setValue("traceid", (Object)item.getRoottraceno(), i);
        String state = item.getState();
        this.getModel().setValue("jobstate", (Object)state, i);
        if ("errored".equals(state)) {
            this.getModel().setValue("result", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u5f02\u5e38", (String)"SearchWfJobrecordPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), i);
        }
        String duration = item.getDuration();
        this.getModel().setValue(DURATION, (Object)this.getSeconds(duration), i);
        if (WfUtils.isNotEmpty((String)duration) && ((d = Integer.parseInt(duration)) > 1000 || d == 0)) {
            this.getModel().setValue("showsch", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8c03\u5ea6", (String)"SearchWfJobrecordPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]), i);
        }
        String handlerType = item.getHandlertype();
        String jobType = jobTypes.get(this.typeRebuild(handlerType, item.getHandlercfg()));
        this.getModel().setValue(HANDLERTYPE, (Object)(WfUtils.isNotEmpty((String)jobType) ? jobType : handlerType), i);
        this.getModel().setValue(BILLNO, (Object)item.getBillno(), i);
        this.getModel().setValue(BIZTRACENO, (Object)item.getBiztraceno(), i);
        String pduration = pluginInfos.get(item.getId());
        if (WfUtils.isNotEmpty((String)pduration)) {
            this.getModel().setValue(PDURATION, (Object)this.getSeconds(pduration), i);
        }
    }

    private List<String> findRootNodeId(List<JobTraceTreeNode> jobrecords) {
        ArrayList<String> rootIds = new ArrayList<String>(16);
        List children = jobrecords.stream().map(r -> r.getId()).collect(Collectors.toList());
        if (WfUtils.isNotEmptyForCollection(jobrecords)) {
            for (JobTraceTreeNode node : jobrecords) {
                if (!"address-process-event".equals(node.getHandlertype()) && !"start-process-event".equals(node.getHandlertype()) && !"async-trigger".equals(node.getHandlertype()) && !"0".equals(node.getSrcjobid()) || children.contains(node.getSrcjobid())) continue;
                rootIds.add(node.getId());
            }
        }
        return rootIds;
    }

    private String getBlankCharLength(int level) {
        String defaultBlack = "";
        if (level == 0) {
            return defaultBlack;
        }
        StringBuilder ret = new StringBuilder();
        String defaultChar = " ";
        for (int i = 1; i < level + 1; ++i) {
            ret = ret.append(defaultChar);
        }
        return ret.toString();
    }

    private List<JobTraceTreeNode> getTraceLevel(List<JobTraceTreeNode> jobrecords, String pid) {
        List<Object> jobTraceTrees = new ArrayList(16);
        for (int i = 0; i < jobrecords.size(); ++i) {
            JobTraceTreeNode jobTraceTreeNode = jobrecords.get(i);
            String srcjobid = String.valueOf(jobrecords.get(i).getSrcjobid());
            jobTraceTreeNode.setParentId(srcjobid);
            jobTraceTrees.add(jobTraceTreeNode);
        }
        List temp = TreeBuilderUtil.buildTree(jobTraceTrees, pid);
        if (WfUtils.isNotEmptyForCollection(temp)) {
            jobTraceTrees = temp.stream().filter(m -> m.getParentId() != null).collect(Collectors.toList());
        }
        ArrayList<JobTraceTreeNode> list = new ArrayList<JobTraceTreeNode>(16);
        jobTraceTrees = this.getTraceList((JobTraceTreeNode)jobTraceTrees.get(0), list);
        return jobTraceTrees;
    }

    private List<JobTraceTreeNode> getTraceList(JobTraceTreeNode jobTraceTreeNode, List<JobTraceTreeNode> list) {
        JobTraceTreeNode parent = jobTraceTreeNode;
        list.add(parent);
        List<JobTraceTreeNode> children = parent.getChildren();
        if (children != null) {
            for (JobTraceTreeNode child : children) {
                this.getTraceList(child, list);
            }
        }
        return list;
    }

    private String getBusinesskey(String key) {
        String ret = "";
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fbusinesskey,fname,fprocdefid,fbiztraceno from t_wf_hiprocinst ");
        sb.append("where (fbusinesskey=? or fbillno=? or fbiztraceno=? ) order by fcreatedate desc ");
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getBusinesskey", (DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])new Object[]{key, key, key});){
            Iterator iter = ds.iterator();
            String procinstIds = "";
            String procdefIds = "";
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                ret = row.getString("fbusinesskey");
                this.getPageCache().put(BIZTRACENO, row.getString("fbiztraceno"));
                procinstIds = procinstIds + "," + row.getLong("fid");
                procdefIds = procdefIds + "," + row.getLong("fprocdefid");
            }
            if (WfUtils.isNotEmpty((String)procinstIds)) {
                this.getPageCache().put(PROCINSTID, procinstIds.substring(1));
                this.getPageCache().put(PROCDEFID, procdefIds.substring(1));
            }
        }
        catch (Exception e) {
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return ret;
    }

    private Boolean isBizTraceNo(String searchKey) {
        QFilter qFilter = new QFilter(BIZTRACENO, "=", (Object)searchKey);
        return QueryServiceHelper.exists((String)"wf_hiprocinst", (QFilter[])new QFilter[]{qFilter});
    }

    private List<JobTraceTreeNode> getJobRecordByBKOrTraceNo(String searchKey, String type) {
        ArrayList<JobTraceTreeNode> ret = new ArrayList<JobTraceTreeNode>();
        ret.addAll(this.getDataFromTable("t_wf_hijobrecord", searchKey, type));
        ret.addAll(this.getDataFromTable("t_wf_jobrecord", searchKey, type));
        return ret;
    }

    private List<JobTraceTreeNode> getDataFromTable(String tableName, String searchKey, String type) {
        ArrayList<JobTraceTreeNode> ret = new ArrayList<JobTraceTreeNode>();
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fretries,fhandlertype,fhandlercfg,felementid,fcreatedate,fendtime,fexecutor,froottraceno,fduration,fstate,fsrcjobid,frootjobid,fentitynumber,fbusinesskey,fbiztraceno,fprocessinstanceid ");
        sb.append(String.format("from %s ", tableName));
        List<Object> businesskeys = new ArrayList(16);
        if (type.equalsIgnoreCase(BIZTRACENO)) {
            businesskeys = this.getBusinessKeysByTraceNo(searchKey, tableName);
        } else if (type.equalsIgnoreCase(BUSINESSKEY)) {
            businesskeys.add(searchKey);
        }
        if (WfUtils.isEmptyForCollection(businesskeys)) {
            return ret;
        }
        this.getView().getPageCache().put(BUSINESSKEYS, WfUtils.listToStringWithQuotes(businesskeys, (String)","));
        sb.append(" where fbusinesskey in (?)");
        sb.append(" order by fid ");
        String newSql = sb.toString().replaceAll("\\?", WfUtils.getQuestionMarkList((int)businesskeys.size()));
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getJobrecordByBusinesskey", (DBRoute)DBRoute.workflow, (String)newSql, (Object[])businesskeys.toArray());){
            Iterator iter = ds.iterator();
            JobTraceTreeNode jobTraceTreeNode = null;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                jobTraceTreeNode = new JobTraceTreeNode();
                jobTraceTreeNode.setId(row.getString("fid"));
                jobTraceTreeNode.setRetries(row.getString("fretries"));
                jobTraceTreeNode.setHandlertype(row.getString("fhandlertype"));
                jobTraceTreeNode.setHandlercfg(row.getString("fhandlercfg"));
                jobTraceTreeNode.setElementid(row.getString("felementid"));
                jobTraceTreeNode.setCreatedate(row.getString("fcreatedate"));
                jobTraceTreeNode.setEndtime(row.getString("fendtime"));
                jobTraceTreeNode.setExecutor(row.getString("fexecutor"));
                jobTraceTreeNode.setRoottraceno(row.getString("froottraceno"));
                jobTraceTreeNode.setDuration(row.getString("fduration"));
                jobTraceTreeNode.setState(row.getString("fstate"));
                jobTraceTreeNode.setSrcjobid(row.getString("fsrcjobid"));
                jobTraceTreeNode.setRootjobid(row.getString("frootjobid"));
                jobTraceTreeNode.setEntitynumber(row.getString("fentitynumber"));
                jobTraceTreeNode.setEntityname(this.getEntityName(row.getString("fentitynumber")));
                jobTraceTreeNode.setBusinesskey(row.getString("fbusinesskey"));
                jobTraceTreeNode.setBiztraceno(row.getString("fbiztraceno"));
                jobTraceTreeNode.setBillno(this.getBillNo(row.getString("fbusinesskey"), row.getString("fentitynumber")));
                jobTraceTreeNode.setProcinstid(row.getString("fprocessinstanceid"));
                ret.add(jobTraceTreeNode);
            }
        }
        return ret;
    }

    private List<Object> getBusinessKeysByTraceNo(String bizTraceNo, String tableName) {
        ArrayList<Object> businesskeys = new ArrayList<Object>(8);
        Set<Long> procinstIds = this.getHiProcinstIdsByTraceNo(bizTraceNo);
        if (procinstIds.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("select  fbusinesskey  from  %s  where  fprocessinstanceid  in (?) ", tableName));
            String newSql = sb.toString().replaceAll("\\?", WfUtils.getQuestionMarkList((int)procinstIds.size()));
            try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getBusinessKeysByTraceNo", (DBRoute)DBRoute.workflow, (String)newSql, (Object[])procinstIds.toArray());){
                for (Row row : ds) {
                    businesskeys.add(row.getString("fbusinesskey"));
                }
            }
        }
        return businesskeys;
    }

    private Set<Long> getHiProcinstIdsByTraceNo(String bizTraceNo) {
        HashSet<Long> procisntIds = new HashSet<Long>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select  fprocinstid   from  t_wf_hiprocinst  where  fbiztraceno = ").append("'").append(bizTraceNo).append("'").append(" and fprocesstype='BizFlow' ");
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getHiProcinstIdsByTraceNo", (DBRoute)DBRoute.workflow, (String)sb.toString(), null);){
            for (Row row : ds) {
                procisntIds.add(row.getLong("fprocinstid"));
            }
        }
        return procisntIds;
    }

    private String getBillNo(String businesskey, String entitynumber) {
        String ret = "";
        String querySql = "select  fbillno  from  t_wf_hiactinst  where  fbusinesskey=? and  fentitynumber=? ";
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getBillNo", (DBRoute)DBRoute.workflow, (String)querySql, (Object[])new Object[]{businesskey, entitynumber});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                ret = row.getString("fbillno");
            }
        }
        return ret;
    }

    private String getEntityName(String entitynumber) {
        if (WfUtils.isEmpty((String)entitynumber)) {
            return "";
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitynumber);
        return mainEntityType.getDisplayName().toString();
    }

    private Map<String, String> getHistoryActInfo() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String procInstId = this.getPageCache().get(PROCINSTID);
        if (WfUtils.isEmpty((String)procInstId)) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select factid,factname from t_wf_hiactinst ");
        sb.append("where fprocinstid in (");
        sb.append(procInstId);
        sb.append(") and facttype !='SequenceFlow' ");
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getHistoryActInfo", (DBRoute)DBRoute.workflow, (String)sb.toString(), null);){
            for (Row row : ds) {
                ret.put(row.getString("factid"), row.getString("factname"));
            }
        }
        return ret;
    }

    private Map<String, String> getProcDefInfo() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String procDefId = this.getPageCache().get(PROCDEFID);
        if (WfUtils.isEmpty((String)procDefId)) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fkey,fname,fversion from t_wf_procdef ");
        sb.append("where fid in (");
        sb.append(procDefId);
        sb.append(") ");
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.getProcDefInfo", (DBRoute)DBRoute.workflow, (String)sb.toString(), null);){
            for (Row row : ds) {
                ret.put("key", row.getString("fkey"));
                ret.put(NAME, row.getString("fname"));
                ret.put(VERSION, row.getString("fversion"));
            }
        }
        return ret;
    }

    private String getSeconds(String hm) {
        String ret = "";
        if ("0".equals(hm)) {
            return ret;
        }
        try {
            Long value = Long.parseLong(hm);
            BigDecimal bigDecimal = new BigDecimal(value);
            BigDecimal divDecimal = new BigDecimal(1000L);
            ret = bigDecimal.divide(divDecimal, 2, 2) + "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_LOG, currentRowIndex);
        String jobid = entryRowEntity.getString(JOBID);
        if (WfUtils.isNotEmpty((String)jobid)) {
            jobid = jobid.trim();
        }
        if (PDURATION.equals(fieldName)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setCustomParam(JOBID, (Object)jobid);
            parameter.setBillFormId("wf_pluginexedetail");
            parameter.setParentPageId(this.getView().getPageId());
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam(JOBID, (Object)jobid);
            if ("result".equals(fieldName)) {
                parameter.setFormId("wf_checker_msg");
            }
            if ("showsch".equals(fieldName)) {
                parameter.setFormId("wf_checker_sch");
            }
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setStatus(OperationStatus.VIEW);
            this.showForm(parameter);
        }
    }

    private Map<String, String> getJobTyps() {
        HashMap<String, String> ret = new HashMap<String, String>(8);
        String localeLang = RequestContext.get().getLang().toString();
        if (!"zh_CN".equalsIgnoreCase(localeLang)) {
            return ret;
        }
        ret.put("address-process-event", ResManager.loadKDString((String)"\u5355\u636e\u5bfb\u5740", (String)"SearchWfJobrecordPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-autoCoordinate", ResManager.loadKDString((String)"\u4efb\u52a1\u81ea\u52a8\u534f\u529e", (String)"SearchWfJobrecordPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-circulate", ResManager.loadKDString((String)"\u4efb\u52a1\u4f20\u9605", (String)"SearchWfJobrecordPlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-compensationTaskJob", ResManager.loadKDString((String)"\u4efb\u52a1\u8865\u507f\u5904\u7406", (String)"SearchWfJobrecordPlugin_7", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-continuation", ResManager.loadKDString((String)"\u8fdb\u5165\u8282\u70b9", (String)"SearchWfJobrecordPlugin_8", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-executionConversion", ResManager.loadKDString((String)"\u8282\u70b9\u5355\u636e\u8ba1\u7b97", (String)"SearchWfJobrecordPlugin_9", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-msg", ResManager.loadKDString((String)"\u53d1\u9001\u901a\u77e5\u6d88\u606f", (String)"SearchWfJobrecordPlugin_10", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-msg-link", ResManager.loadKDString((String)"\u53d1\u9001\u94fe\u63a5\u6d88\u606f", (String)"SearchWfJobrecordPlugin_11", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-msg-txt", ResManager.loadKDString((String)"\u53d1\u9001\u6587\u672c\u6d88\u606f", (String)"SearchWfJobrecordPlugin_12", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-taskRuleAnalysis", ResManager.loadKDString((String)"\u4efb\u52a1\u81ea\u52a8\u5904\u7406\u8bbe\u7f6e", (String)"SearchWfJobrecordPlugin_13", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-taskTransfer", ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u4ea4\u6d88\u606f", (String)"SearchWfJobrecordPlugin_14", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-timing", ResManager.loadKDString((String)"\u65f6\u95f4\u7b49\u5f85", (String)"SearchWfJobrecordPlugin_15", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-todo", ResManager.loadKDString((String)"\u6e20\u9053\u5f85\u529e", (String)"SearchWfJobrecordPlugin_16", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-todo-new", ResManager.loadKDString((String)"\u6e20\u9053\u5f85\u529e\u521b\u5efa", (String)"SearchWfJobrecordPlugin_26", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-todo-deal", ResManager.loadKDString((String)"\u6e20\u9053\u5f85\u529e\u5904\u7406", (String)"SearchWfJobrecordPlugin_27", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-todo-delete", ResManager.loadKDString((String)"\u6e20\u9053\u5f85\u529e\u5220\u9664", (String)"SearchWfJobrecordPlugin_28", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("async-trigger", ResManager.loadKDString((String)"\u91cd\u65b0\u6fc0\u6d3b\u6d41\u8f6c", (String)"SearchWfJobrecordPlugin_17", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("delay-broadcast", ResManager.loadKDString((String)"\u5ef6\u8fdf\u5e7f\u64ad", (String)"SearchWfJobrecordPlugin_18", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("donothing-event", ResManager.loadKDString((String)"\u7a7a\u6d88\u606f", (String)"SearchWfJobrecordPlugin_19", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("event-address-process", ResManager.loadKDString((String)"\u4e8b\u4ef6\u5bfb\u5740", (String)"SearchWfJobrecordPlugin_20", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("expireModelJobHandler", ResManager.loadKDString((String)"\u4efb\u52a1\u8fc7\u671f\u63a7\u5236", (String)"SearchWfJobrecordPlugin_21", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("multi-async-continuation", ResManager.loadKDString((String)"\u591a\u5b9e\u4f8b\u6d41\u8f6c", (String)"SearchWfJobrecordPlugin_22", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("start-process-event", ResManager.loadKDString((String)"\u542f\u52a8\u6d41\u7a0b", (String)"SearchWfJobrecordPlugin_23", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("start-rpa-process", ResManager.loadKDString((String)"RPA\u542f\u52a8\u6d41\u7a0b", (String)"SearchWfJobrecordPlugin_24", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("wait-event", ResManager.loadKDString((String)"\u4e8b\u4ef6\u7b49\u5f85", (String)"SearchWfJobrecordPlugin_25", (String)"bos-wf-unittest", (Object[])new Object[0]));
        return ret;
    }

    private Map<String, String> initPluginInfos() {
        String ids = this.getView().getPageCache().get(BUSINESSKEYS);
        HashMap<String, String> ret = new HashMap<String, String>(8);
        if (WfUtils.isEmpty((String)ids)) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fjobid,fduration from t_wf_pluginexedetail ");
        sb.append("where fbusinesskey in (");
        sb.append(ids);
        sb.append(") ");
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordPlugin.initPluginInfos", (DBRoute)DBRoute.workflow, (String)sb.toString(), null);){
            for (Row row : ds) {
                String jobid = row.getString("fjobid");
                Long dura = row.getLong("fduration");
                if (ret.containsKey(jobid)) {
                    String old = (String)ret.get(jobid);
                    BigDecimal oldValue = new BigDecimal(old);
                    ret.put(jobid, oldValue.add(new BigDecimal(dura)) + "");
                    continue;
                }
                ret.put(jobid, String.valueOf(dura));
            }
        }
        return ret;
    }

    private String typeRebuild(String type, String cfg) {
        if ("async-todo".equals(type) && WfUtils.isNotEmpty((String)cfg)) {
            if (cfg.contains("NEW")) {
                return type + "-new";
            }
            if (cfg.contains("DEAL")) {
                return type + "-deal";
            }
            if (cfg.contains("DELETE")) {
                return type + "-delete";
            }
        }
        return type;
    }
}

