/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.util.WfSupportUtil;

public class SearchWfJobrecordSchPlugin
extends AbstractWorkflowPlugin {
    private static final String RUNAT = "runat";
    private static final String DISPATCHTIME = "dispatchtime";
    private static final String ENDTIME = "endtime";
    private static final String STATUS = "status";

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String id = (String)parameter.getCustomParam("jobid");
        if (WfUtils.isEmpty((String)id)) {
            return;
        }
        this.initSchData(id);
    }

    private void initSchData(String jobId) {
        ArrayList schData = new ArrayList(3);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,frunat,fdispatchtime,fruntime,fendtime,fstatus from t_sch_task ");
        sb.append("where fjobid=? ");
        try (DataSet ds = DB.queryDataSet((String)"SearchWfJobrecordSchPlugin.initSchData", (DBRoute)DBRoute.base, (String)sb.toString(), (Object[])new Object[]{jobId});){
            for (Row row : ds) {
                HashMap<String, String> item = new HashMap<String, String>(6);
                item.put("id", row.getString("fid"));
                item.put(RUNAT, WfSupportUtil.desensitizeIP(row.getString("frunat")));
                item.put(DISPATCHTIME, row.getString("fdispatchtime"));
                item.put("runtime", row.getString("fruntime"));
                item.put(ENDTIME, row.getString("fendtime"));
                item.put(STATUS, row.getString("fstatus"));
                schData.add(item);
            }
        }
        StringBuilder builder = new StringBuilder();
        if (WfUtils.isNotEmptyForCollection(schData)) {
            int size = schData.size();
            this.getModel().batchCreateNewEntryRow("entryentity", size);
            for (int i = 0; i < size; ++i) {
                double rs;
                String runDuration;
                double ds;
                String dispatchDuration;
                Map t = (Map)schData.get(i);
                this.getModel().setValue("id", t.get("id"), i);
                this.getModel().setValue(STATUS, t.get(STATUS), i);
                this.getModel().setValue(RUNAT, t.get(RUNAT), i);
                String dtime = (String)t.get(DISPATCHTIME);
                String stime = (String)t.get("runtime");
                String etime = (String)t.get(ENDTIME);
                this.getModel().setValue(DISPATCHTIME, (Object)dtime, i);
                this.getModel().setValue("starttime", (Object)stime, i);
                this.getModel().setValue(ENDTIME, (Object)etime, i);
                if (WfUtils.isEmpty((String)etime)) {
                    builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u672a\u6267\u884c\u5b8c\u6210\uff0c\u8bf4\u660e\u8c03\u5ea6\u961f\u5217\u5f02\u5e38\u3002\n", (String)"SearchWfJobrecordSchPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]), i + 1));
                }
                if (WfUtils.isNotEmpty((String)(dispatchDuration = WfSupportUtil.calcDurations(dtime, stime))) && (ds = Double.parseDouble(dispatchDuration)) > 1.0) {
                    builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u5206\u53d1\u540e\u6267\u884c\u5ef6\u8fdf\uff0c\u8c03\u5ea6\u961f\u5217\u6709\u6392\u961f\u7684\u53ef\u80fd\u3002\n", (String)"SearchWfJobrecordSchPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), i + 1));
                }
                if (WfUtils.isNotEmpty((String)(runDuration = WfSupportUtil.calcDurations(stime, etime))) && (rs = Double.parseDouble(runDuration)) > 1.0) {
                    builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u6d88\u8d39\u8005\u6267\u884c\u7f13\u6162\u3002\n", (String)"SearchWfJobrecordSchPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), i + 1));
                }
                String duration = WfSupportUtil.calcDurations(dtime, etime);
                this.getModel().setValue("duration", (Object)duration, i);
                if (i != 1) continue;
                builder.append(ResManager.loadKDString((String)"\u8be5\u6d88\u606f\u88ab\u6361\u6f0f\u91cd\u8bd5\uff0c\u8bf7\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u3002\n", (String)"SearchWfJobrecordSchPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        } else {
            builder.append(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8c03\u5ea6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u3002\n", (String)"SearchWfJobrecordSchPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        this.getModel().setValue("result", (Object)builder.toString());
    }
}

