/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.plugin.AbstractWorkflowSupportPlugin;
import kd.bos.workflow.support.util.WfSupportUtil;

public class SearchWfSchJobLogPlugin
extends AbstractWorkflowSupportPlugin
implements HyperLinkClickListener {
    private static final String BUTTON_SEARCH_LOG = "button_search_log";
    private static final String BUTTON_CLOSE = "btnclose";
    private static final String BUTTON_SEARCH_ERROR_LOG = "button_search_error_log";
    private static final String SELECT_CONTROL_KEY = "combofield";
    private static final String ENTRY_ENTITY_SCHJOB_LOG = "entryentity_log";
    private static final int PAGE_SIZE = 20;
    private static final String APPID = "wf";
    private static final String FTASKID = "ftaskid";
    private static final String PLANNAME = "planname";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY_SCHJOB_LOG);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BUTTON_SEARCH_LOG, BUTTON_SEARCH_ERROR_LOG, BUTTON_CLOSE});
    }

    public void initialize() {
        this.produceSelector(SELECT_CONTROL_KEY, this.initDropdown());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_SEARCH_LOG.equals(ctrl.getKey())) {
            this.getSchJobLogDataList();
        }
        if (BUTTON_CLOSE.equals(ctrl.getKey())) {
            this.getView().close();
        }
    }

    private void produceSelector(String selectControlKey, Map<String, String> dataMap) {
        ArrayList comboItems = new ArrayList(dataMap.size());
        dataMap.forEach((k, v) -> {
            ComboItem comboItem = new ComboItem();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(k);
            comboItem.setCaption(localeString);
            comboItem.setValue(String.valueOf(v));
            comboItems.add(comboItem);
        });
        ComboEdit combEdit = (ComboEdit)this.getControl(selectControlKey);
        combEdit.setComboItems(comboItems);
    }

    private void getSchJobLogDataList() {
        int pageSize;
        this.getModel().deleteEntryData(ENTRY_ENTITY_SCHJOB_LOG);
        IDataModel model = this.getModel();
        Object selectedObj = model.getValue(SELECT_CONTROL_KEY);
        if (this.checkParam(selectedObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u5ea6\u7c7b\u578b\u3002", (String)"SearchWfSchJobLogPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("jobNumber", selectedObj == null ? "" : selectedObj);
        param.put("sch_job_log", "sch_job_log");
        List<Map<String, String>> dataList = this.getWorkflowSupportToolService().searchSchJobList(param);
        int n = pageSize = dataList.size() < 20 ? dataList.size() : 20;
        if (this.checkPageSize(pageSize)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u6b21\u67e5\u8be2\u3002", (String)"SearchWfSchJobLogPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY_SCHJOB_LOG, pageSize);
        Map<String, String> status = this.getJobStatus();
        for (int i = 0; i < pageSize; ++i) {
            Map<String, String> item = dataList.get(i);
            this.getModel().setValue("job_inner_number", (Object)String.valueOf(item.get("jobId")), i);
            this.getModel().setValue("job_dispatch_time", (Object)String.valueOf(item.get("dispatchtime")), i);
            this.getModel().setValue("job_exe_server_name", (Object)WfSupportUtil.desensitizeIP(String.valueOf(item.get("runat"))), i);
            String btime = String.valueOf(item.get("runtime"));
            String etime = String.valueOf(item.get("endtime"));
            this.getModel().setValue("job_begin_time", (Object)("null".equals(btime) ? "" : btime), i);
            this.getModel().setValue("job_end_time", (Object)("null".equals(etime) ? "" : etime), i);
            String durations = WfSupportUtil.calcDurations(btime, etime);
            if (WfUtils.isNotEmpty((String)durations)) {
                this.getModel().setValue("duration", (Object)durations, i);
            }
            String jobStatus = String.valueOf(item.get("status"));
            this.getModel().setValue("job_state", (Object)status.get(jobStatus), i);
            if ("FAILED".equals(jobStatus)) {
                this.getModel().setValue("job_error_log", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u65e5\u5fd7", (String)"SearchWfSchJobLogPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), i);
            }
            this.getModel().setValue("taskid", (Object)String.valueOf(item.get("id")), i);
        }
    }

    private boolean checkParam(Object param) {
        if (Objects.isNull(param) || WfUtils.isEmpty((String)String.valueOf(param))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkPageSize(int pageSize) {
        if (0 == pageSize) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Map<String, String> initDropdown() {
        String localeLang = RequestContext.get().getLang().toString();
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        StringBuilder sqlBuilder = new StringBuilder("SELECT A.FID,B.FNUMBER,c.FNAME FROM T_SCH_JOB A  ");
        sqlBuilder.append(" LEFT JOIN T_SCH_TASKDEFINE B ON A.FTASKDEFINEID = B.FID ");
        sqlBuilder.append(" left join t_sch_taskdefine_l c on a.ftaskdefineid = c.fid ");
        sqlBuilder.append(" WHERE B.FAPPID =? and C.flocaleid =? ");
        DataSet ds = DB.queryDataSet((String)"wf.support.ProduceSchJobComboxCmd.ids", (DBRoute)DBRoute.base, (String)sqlBuilder.toString(), (Object[])new Object[]{APPID, localeLang});
        for (Row row : ds) {
            resultMap.put(String.valueOf(row.get("FNAME")), String.valueOf(row.get("FID")));
        }
        return resultMap;
    }

    private Map<String, String> getJobStatus() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("SCHEDULED", ResManager.loadKDString((String)"\u8ba1\u5212\u4e2d", (String)"SearchWfSchJobLogPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("BEGIN", ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"SearchWfSchJobLogPlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("FAILED", ResManager.loadKDString((String)"\u5931\u8d25", (String)"SearchWfSchJobLogPlugin_7", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("COMPLETED", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"SearchWfSchJobLogPlugin_8", (String)"bos-wf-unittest", (Object[])new Object[0]));
        ret.put("TIMEOUT", ResManager.loadKDString((String)"\u8d85\u65f6", (String)"SearchWfSchJobLogPlugin_9", (String)"bos-wf-unittest", (Object[])new Object[0]));
        return ret;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY_SCHJOB_LOG, currentRowIndex);
        String taskId = entryRowEntity.getString("taskid");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sch_errorjob");
        FormShowParameter showParameter = new FormShowParameter();
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        StringBuilder sqlBuffTemp = new StringBuilder();
        String sql = sqlBuffTemp.append("SELECT A.fjobid,A.fjobid\"id\",A.fexecutetime,E.fnumber,A.ftaskid,A.frunat,A.ferrorreason ,B.FSCHEDULEID ,B.FNUMBER,D.FNAME,C.FNAME \"jobName\" FROM t_sch_errorjob A ").append("LEFT JOIN T_SCH_TASK B ON A.FTASKID = B.FID ").append("LEFT JOIN T_SCH_JOB_L C ON A.FJOBID = C.FID AND C.FLOCALEID ='").append(lang).append("'").append("LEFT JOIN T_SCH_JOB E ON C.FID  = E.FID ").append("LEFT JOIN T_SCH_SCHEDULE_L D ON D.FID = B.FSCHEDULEID AND D.FLOCALEID ='").append(lang).append("'").append("WHERE A.FTASKID IN").append("(").append("?").append(")").toString();
        HashMap data = new HashMap();
        Object[] params = new SqlParameter[]{new SqlParameter(FTASKID, type.getPrimaryKey().getDbType(), (Object)taskId)};
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                data.put(FTASKID, rs.getString("fnumber"));
                data.put("id", rs.getString(FTASKID));
                data.put("jobnametemp", rs.getString("jobName"));
                data.put(PLANNAME, rs.getString("fname"));
                data.put("frunat", rs.getString("frunat"));
                data.put("ferrorreason", rs.getString("ferrorreason"));
            }
            return data;
        });
        showParameter.setFormId("sch_errorjob_details");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)taskId);
        showParameter.setCustomParam("jobnumber", data.get(FTASKID));
        showParameter.setCustomParam("jobname", data.get("jobnametemp"));
        showParameter.setCustomParam(PLANNAME, data.get(PLANNAME));
        this.getView().showForm(showParameter);
    }
}

