/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.support.plugin.TreeNode;

public class TreeBuilderUtil {
    public static <T extends TreeNode> List<T> buildTree(List<T> nodes, String pId) {
        ArrayList<TreeNode> roots = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            if (!node.getId().equals(pId) && (!node.getParentId().equals("0") || !pId.equals("0") && !pId.equals(node.getId()))) continue;
            node.setLevel(0);
            roots.add(node);
        }
        for (TreeNode root : roots) {
            TreeBuilderUtil.buildChildren(root, nodes);
        }
        return roots;
    }

    private static <T extends TreeNode> void buildChildren(T node, List<T> nodes) {
        for (TreeNode child : nodes) {
            if (child.getParentId() == null || !child.getParentId().equals(node.getId())) continue;
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList());
            }
            child.setLevel(node.getLevel() + 1);
            node.getChildren().add(child);
            TreeBuilderUtil.buildChildren(child, nodes);
        }
    }
}

