/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.plugin.ClearBillOpVerifyCachePlugin;

public class UpdateProcessDataPlugin
extends AbstractWorkflowPlugin {
    private static Log log = LogFactory.getLog(ClearBillOpVerifyCachePlugin.class);
    private static final String CMB_PROCESSTABLE = "cmb_processtable";
    private static final String TXT_UPDATESQL = "txt_updatesql";
    private static final String TXT_WHERESQL = "txt_wheresql";
    private static final String BTN_UPDATE = "btn_update";
    private Map<String, String> processTableMap;

    public void initialize() {
        this.initializeProcessTableMap();
        this.setComboItems();
    }

    private void initializeProcessTableMap() {
        this.processTableMap = new HashMap<String, String>(13);
        this.processTableMap.put("t_wf_execution", ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b", (String)"UpdateProcessDataPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_PARTICIPANT", ResManager.loadKDString((String)"\u6d41\u7a0b\u4efb\u52a1\u53c2\u4e0e\u8005", (String)"UpdateProcessDataPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_VARIABLE", ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf", (String)"UpdateProcessDataPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_TASK", ResManager.loadKDString((String)"\u6d41\u7a0b\u4efb\u52a1", (String)"UpdateProcessDataPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_DEADLETTERJOB", ResManager.loadKDString((String)"\u5f02\u5e38\u6d88\u606f", (String)"UpdateProcessDataPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_JOBRecord", ResManager.loadKDString((String)"\u5f02\u6b65\u5de5\u4f5c", (String)"UpdateProcessDataPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_HIPROCINST", ResManager.loadKDString((String)"\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b", (String)"UpdateProcessDataPlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_HIACTINST", ResManager.loadKDString((String)"\u5386\u53f2\u6d3b\u52a8\u5b9e\u4f8b", (String)"UpdateProcessDataPlugin_7", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_HITASKINST", ResManager.loadKDString((String)"\u5386\u53f2\u4efb\u52a1\u5b9e\u4f8b", (String)"UpdateProcessDataPlugin_8", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_HIPARTICIPANT", ResManager.loadKDString((String)"\u5386\u53f2\u53c2\u4e0e\u4eba\u4fe1\u606f", (String)"UpdateProcessDataPlugin_9", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_HIVARINST", ResManager.loadKDString((String)"\u5386\u53f2\u53d8\u91cf", (String)"UpdateProcessDataPlugin_10", (String)"bos-wf-unittest", (Object[])new Object[0]));
        this.processTableMap.put("T_WF_HICOMMENT", ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u7ed3\u679c", (String)"UpdateProcessDataPlugin_11", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    private void setComboItems() {
        ComboItem comboItem = null;
        LocaleString localeString = null;
        Set<Map.Entry<String, String>> entrySet = this.processTableMap.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(entrySet.size());
        Map.Entry<String, String> entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            comboItem = new ComboItem();
            localeString = new LocaleString();
            localeString.setLocaleValue(entry.getValue());
            comboItem.setCaption(localeString);
            comboItem.setValue(entry.getKey());
            comboItems.add(comboItem);
        }
        ComboEdit processTableControl = (ComboEdit)this.getControl(CMB_PROCESSTABLE);
        processTableControl.setComboItems(comboItems);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_UPDATE});
    }

    public void click(EventObject evt) {
        if (null == evt) {
            log.debug("kd.bos.workflow.support.UpdateProcessDataPlugin.click(EventObject) evt is null.");
            return;
        }
        Control control = (Control)evt.getSource();
        if (null == control) {
            log.debug("kd.bos.workflow.support.UpdateProcessDataPlugin.click(EventObject) control is null.");
            return;
        }
        String key = control.getKey();
        log.debug("kd.bos.workflow.support.UpdateProcessDataPlugin.click(EventObject) key : " + key);
        switch (key) {
            case "btn_update": {
                this.doUpdate();
                break;
            }
        }
    }

    private void doUpdate() {
        String processTableNumber = (String)this.getModel().getValue(CMB_PROCESSTABLE);
        Object whereSqlObj = this.getModel().getValue(TXT_WHERESQL);
        Object updateSqlPart = this.getModel().getValue(TXT_UPDATESQL);
        String updateSql = "update " + processTableNumber + " set " + updateSqlPart + " where " + whereSqlObj;
        boolean executeSuccess = false;
        String errorMsg = null;
        try {
            executeSuccess = DB.execute((DBRoute)DBRoute.workflow, (String)updateSql);
        }
        catch (Exception e) {
            errorMsg = WfUtils.getExceptionStacktrace((Throwable)e);
        }
        if (executeSuccess) {
            this.getView().showSuccessNotification("Update success.");
        } else {
            this.getView().showErrMessage("Update failed", errorMsg);
        }
    }
}

