/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WfGetAllPluginInfoPlugin
extends AbstractWorkflowPlugin {
    private static final String WF_PLUGININFOS = "wf_plugininfos";
    private static final String BTN_OK = "ok";
    private static final String BTN_DEL = "del";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String ENTRABILL_FLAG = "entrabillFlag";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_DEL, ENTITYNUMBER});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (BTN_OK.equals(key)) {
            String entraBill = this.getPageCache().get(ENTITYNUMBER);
            if (WfUtils.isEmptyString((Object)entraBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"WfGetAllPluginInfoPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            this.getAllPluginInfo(entraBill);
        }
        if (BTN_DEL.equals(key)) {
            this.cleanTable();
        }
        if (ENTITYNUMBER.equals(key)) {
            DesignerModelUtil.openSelectEntitiesPage((IFormView)this.getView(), (IFormPlugin)this, (String)ENTRABILL_FLAG);
        }
    }

    private void getAllPluginInfo(String entraBill) {
        DynamicObjectCollection items = QueryServiceHelper.query((String)"wf_processdefinition", (String)"key,version,versionstate,resourceid,enable,entrabill", (QFilter[])new QFilter[]{new QFilter("entrabill", "=", (Object)entraBill)});
        if (items != null) {
            for (DynamicObject dynamicObject : items) {
                Object nodeInfos;
                Long resourceId = dynamicObject.getLong("resourceid");
                String key = dynamicObject.getString("key");
                String version = dynamicObject.getString("version");
                String versionstate = dynamicObject.getString("versionstate");
                String entrabill = dynamicObject.getString("entrabill");
                ResourceEntity resourceEntity = this.getRepositoryService().getResourceById(resourceId);
                if (resourceEntity == null || resourceEntity.getData() == null) continue;
                JSONObject model = null;
                try {
                    model = JSON.parseObject((String)resourceEntity.getData());
                }
                catch (Exception e) {
                    continue;
                }
                if (model == null || (nodeInfos = BpmnModelUtil.getProperty((Map)model, (String)"childShapes")) == null) continue;
                for (Object obj : (JSONArray)nodeInfos) {
                    Object plugins3;
                    Object plugins2;
                    DetailInfo item;
                    ArrayList<DetailInfo> list = new ArrayList<DetailInfo>();
                    JSONObject node = (JSONObject)obj;
                    Object nodeNum = BpmnModelUtil.getProperty((Map)node, (String)"properties.number");
                    Object nodeName = BpmnModelUtil.getProperty((Map)node, (String)"properties.name");
                    Object plugins1 = BpmnModelUtil.getProperty((Map)node, (String)"properties.taskListeners.implementation");
                    if (plugins1 != null) {
                        for (Object plugin : (JSONArray)plugins1) {
                            JSONObject p = (JSONObject)plugin;
                            Object implementation = BpmnModelUtil.getProperty((Map)p, (String)"implementation");
                            item = new DetailInfo();
                            item.setPlugin((String)implementation);
                            list.add(item);
                        }
                    }
                    if ((plugins2 = BpmnModelUtil.getProperty((Map)node, (String)"properties.executionListeners.implementation")) != null) {
                        Object plugin;
                        plugin = ((JSONArray)plugins2).iterator();
                        while (plugin.hasNext()) {
                            Object plugin2 = plugin.next();
                            JSONObject p = (JSONObject)plugin2;
                            Object implementation = BpmnModelUtil.getProperty((Map)p, (String)"implementation");
                            DetailInfo item2 = new DetailInfo();
                            item2.setPlugin((String)implementation);
                            list.add(item2);
                        }
                    }
                    if ((plugins3 = BpmnModelUtil.getProperty((Map)node, (String)"properties.service.extItf")) != null) {
                        for (Object plugin : (JSONArray)plugins3) {
                            item = new DetailInfo();
                            item.setPlugin((String)plugin);
                            list.add(item);
                        }
                    }
                    if (list.isEmpty()) continue;
                    for (DetailInfo bean : list) {
                        DynamicObject up = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WF_PLUGININFOS));
                        up.set("procnumber", (Object)key);
                        up.set("version", (Object)version);
                        up.set("nodenumber", nodeNum);
                        up.set("nodename", nodeName);
                        up.set("plugin", (Object)bean.getPlugin());
                        up.set("versionstate", (Object)versionstate);
                        up.set("entrabill", (Object)entrabill);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{up});
                    }
                }
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u5b8c\u6210\u3002", (String)"WfGetAllPluginInfoPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    private void cleanTable() {
        try {
            DeleteServiceHelper.delete((String)WF_PLUGININFOS, (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u5b8c\u6210\u3002", (String)"WfGetAllPluginInfoPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (ENTRABILL_FLAG.equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map ret = (Map)evt.getReturnData();
            this.getPageCache().put(ENTITYNUMBER, ret.get("number").toString());
            this.getModel().setValue(ENTITYNUMBER, ret.get("name"));
        }
    }

    static class DetailInfo {
        private String plugin;

        DetailInfo() {
        }

        public String getPlugin() {
            return this.plugin;
        }

        public void setPlugin(String plugin) {
            this.plugin = plugin;
        }
    }
}

