/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkFlowHistoricProcDataWidePlugin
extends AbstractListPlugin {
    private static final String RECOVER_BTN = "recover";
    private static final String REFRESH_BTN = "btnrefresh";

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "recover": {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                this.recoverProcData(rows);
                this.refresh();
                break;
            }
            case "btnrefresh": {
                this.refresh();
                break;
            }
        }
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    private void recoverProcData(ListSelectedRowCollection rows) {
        IListView listView = (IListView)this.getView();
        IListModel listModel = listView.getListModel();
        String archiveRouteKey = listModel.getAchiveKey();
        if (WfUtils.isNotEmpty((String)archiveRouteKey) && !WfUtils.WFS.getRouteKey().equals(archiveRouteKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5f52\u6863\u6570\u636e\u4e0d\u652f\u6301\u6062\u590d\u3002", (String)"WorkFlowHistoricProcDataWidePlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (WfUtils.isEmptyForCollection((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"WorkFlowHistoricProcDataWidePlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (rows.size() > 50) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u52fe\u900950\u6761\u8bb0\u5f55\uff0c\u60a8\u5df2\u52fe\u9009[%s]\u6761\u8bb0\u5f55\u3002", (String)"WorkFlowHistoricProcDataWidePlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), rows.size()), Integer.valueOf(3000));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            Object pk = row.getPrimaryKeyValue();
            if (pk == null) continue;
            ids.add(Long.parseLong(pk.toString()));
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        wfService.getHistoryService().recoverProcDataFromWide(ids);
    }
}

