/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowDataQueryToolPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String HIVARINSTFIELDSTRING = "processinstanceid,executionid,taskid,name,typename,doublevalue,longvalue,textvalue,time,createdate,modifydate,actinstid";
    private static final String BIZTRACENO = "biztraceno";
    private static final String SRCJOBID = "srcjobid";
    private static final String JOBTYPE = "jobtype";
    private static final String ACTIVITYID = "activityid";
    private static final String HICOMMENTFIELDSTRING = "type,userid,taskid,processinstanceid,activityid,resultname,resultnumber,decisiontype,activityname,businesskey,entitynumber,time";
    private static final String USERID = "userid";
    private static final String TASKID = "taskid";
    private static final String EXECUTIONID = "executionid";
    private static final String TASKFIELDSTRING = "name,taskdefinitionkey,entityname,businesskey,executionid,processinstanceid,processdefinitionid,createdate,modifydate,billno,processtype";
    private static final String ACTIVITYNAME = "activityname";
    private static final String PROCESSDEFINITIONID = "processdefinitionid";
    private static final String MODIFYDATE = "modifydate";
    private static final String CREATEDATE = "createdate";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String PUBILCFIELDSTRING = "processinstanceid,businessid,billno,name,suspensionstate,createdate,modifydate,entrabillname,businesskey,processtype";
    private static final String PROCESSTYPE = "processtype";
    private static final String ENTRABILLNAME = "entrabillname";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String BUSINESSKEY = "businesskey";
    private static final String BILLNUMBER = "billnumber";
    private static final String INSTANCEID = "instanceid";
    private static final String HISTORYPROCESSTAB = "historyprocesstab";
    private static final String EXECUTIONTAB = "executiontab";
    private static final String HIACTINSTTAB = "hiactinsttab";
    private static final String TASKTAB = "tasktab";
    private static final String HITASKINSTTAB = "hitaskinsttab";
    private static final String PARTICIPANTTAB = "participanttab";
    private static final String HIPARTICIPANTTAB = "hiparticipanttab";
    private static final String HICOMMENTTAB = "hicommenttab";
    private static final String TRDHICOMMENTTAB = "trdhicommenttab";
    private static final String JOBRCORDTAB = "jobrcordtab";
    private static final String TIMERJOBTAB = "timerjobtab";
    private static final String DEADLETTERJOBTAB = "deadletterjobtab";
    private static final String SUSPENDEDJOBTAB = "suspendedjobtab";
    private static final String HICONDITIONINSTTAB = "hiconditioninsttab";
    private static final String VARIABLETAB = "variabletab";
    private static final String HIVARINSTTAB = "hivarinsttab";
    private static final String TABAP = "tabap";
    private static final String BUTTON = "button";
    private static final String BILLNO = "billno";

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        Button btn = (Button)this.getView().getControl(BUTTON);
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        if (BUTTON.equals(((Control)evt.getSource()).getKey())) {
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab(HISTORYPROCESSTAB);
            this.openHistoricProcInstancePage();
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey;
        switch (subTabKey = event.getTabKey()) {
            case "executiontab": {
                this.openTab("wf_execution", this.getExecuteFields(), EXECUTIONTAB, INSTANCEID);
                break;
            }
            case "hiactinsttab": {
                this.openTab("wf_hiactinst", this.getHiactinstFields(), HIACTINSTTAB, INSTANCEID);
                break;
            }
            case "tasktab": {
                this.openTab("wf_task", this.getTaskFields(), TASKTAB, INSTANCEID);
                break;
            }
            case "hitaskinsttab": {
                this.openTab("wf_hitaskinst", this.getHitaskinstFields(), HITASKINSTTAB, INSTANCEID);
                break;
            }
            case "participanttab": {
                this.openTab("wf_participant", this.getParticipantFields(), PARTICIPANTTAB, INSTANCEID);
                break;
            }
            case "hiparticipanttab": {
                this.openTab("wf_hiparticipant", this.getHiparticipantFields(), HIPARTICIPANTTAB, INSTANCEID);
                break;
            }
            case "hicommenttab": {
                this.openTab("wf_hicomment", this.getHicommentFields(), HICOMMENTTAB, INSTANCEID);
                break;
            }
            case "trdhicommenttab": {
                this.openTab("wf_trdhicomment", this.getTrdhicommentFields(), TRDHICOMMENTTAB, INSTANCEID);
                break;
            }
            case "jobrcordtab": {
                this.openTab("wf_eventlogentry", this.getJobrcordFields(), JOBRCORDTAB, BUSINESSKEY);
                break;
            }
            case "timerjobtab": {
                this.openTab("wf_timerjob", this.getTimerJobFields(), TIMERJOBTAB, BUSINESSKEY);
                break;
            }
            case "deadletterjobtab": {
                this.openTab("wf_deadletterjob", this.getDeadLetterJobFields(), DEADLETTERJOBTAB, BUSINESSKEY);
                break;
            }
            case "suspendedjobtab": {
                this.openTab("wf_suspendedjob", this.getSuspendedJobFields(), SUSPENDEDJOBTAB, BUSINESSKEY);
                break;
            }
            case "hiconditioninsttab": {
                this.openTab("wf_hiconditioninst", this.getHiconditioninstFields(), HICONDITIONINSTTAB, BUSINESSKEY);
                break;
            }
            case "variabletab": {
                this.openTab("wf_variableinstance", this.getVariableFields(), VARIABLETAB, INSTANCEID);
                break;
            }
            case "hivarinsttab": {
                this.openTab("wf_hivarinst", this.getHivarinstFields(), HIVARINSTTAB, INSTANCEID);
                break;
            }
        }
    }

    private void openHistoricProcInstancePage() {
        String instanceId = (String)this.getModel().getValue(INSTANCEID);
        String billNumber = (String)this.getModel().getValue(BILLNUMBER);
        String businessKey = (String)this.getModel().getValue(BUSINESSKEY);
        if (!instanceId.isEmpty()) {
            QFilter filter = new QFilter("processInstanceId", "=", (Object)Long.valueOf(instanceId));
            this.setDataByForm("wf_hiprocinst", new QFilter[]{filter}, true, this.getProcInstanceFields());
            this.getView().getPageCache().put(INSTANCEID, instanceId);
        } else if (!businessKey.isEmpty() && !billNumber.isEmpty()) {
            QFilter filter = new QFilter("businessKey", "=", (Object)businessKey);
            filter.and(new QFilter(BILLNO, "=", (Object)billNumber));
            this.setDataByForm("wf_hiprocinst", new QFilter[]{filter}, false, this.getProcInstanceFields());
        } else if (!businessKey.isEmpty()) {
            QFilter filter = new QFilter("businessKey", "=", (Object)businessKey);
            this.setDataByForm("wf_hiprocinst", new QFilter[]{filter}, false, this.getProcInstanceFields());
        } else if (!billNumber.isEmpty()) {
            QFilter filter = new QFilter(BILLNO, "=", (Object)billNumber);
            this.setDataByForm("wf_hiprocinst", new QFilter[]{filter}, false, this.getProcInstanceFields());
        } else {
            this.showTips();
        }
    }

    private void showTips() {
        this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5b9e\u4f8bID/\u4e1a\u52a1\u4e3b\u952e/\u5355\u53f7", (String)"WorkflowDataQueryToolPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
    }

    private void setDataByForm(String dataName, QFilter[] filters, boolean flag, String fields) {
        if (flag) {
            DynamicObject dynamicObj = QueryServiceHelper.queryOne((String)dataName, (String)fields, (QFilter[])filters);
            if (dynamicObj == null) {
                this.showTips();
                return;
            }
            this.getModel().batchCreateNewEntryRow("entryentity1", 1);
            this.setDataToDefaultPage(dynamicObj, 0);
            this.getModel().clearNoDataRow();
        } else {
            DynamicObjectCollection dynamicObjCollection = QueryServiceHelper.query((String)dataName, (String)fields, (QFilter[])filters);
            if (dynamicObjCollection == null) {
                this.showTips();
            } else if (!dynamicObjCollection.isEmpty()) {
                int size = dynamicObjCollection.size();
                this.getModel().batchCreateNewEntryRow("entryentity1", size);
                for (int i = 0; i < size; ++i) {
                    DynamicObject dynamicObj = (DynamicObject)dynamicObjCollection.get(i);
                    this.setDataToDefaultPage(dynamicObj, i);
                }
                this.getModel().clearNoDataRow();
            }
        }
    }

    public String getProcInstanceFields() {
        return "processDefinitionId,processInstanceId,businessKey,billno,entitynumber,createDate,modifyDate,entrabillname,processtype";
    }

    private void setDataToDefaultPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("instanceid1", dynamicObj.get("processInstanceId"), index);
        this.getModel().setValue("procdefid1", dynamicObj.get("processDefinitionId"), index);
        this.getModel().setValue("businesskey1", dynamicObj.get("businessKey"), index);
        this.getModel().setValue("billno1", dynamicObj.get(BILLNO), index);
        this.getModel().setValue("entitynumber1", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("createdate1", dynamicObj.get("createDate"), index);
        this.getModel().setValue("modifydate1", dynamicObj.get("modifyDate"), index);
        this.getModel().setValue("entrabillname1", dynamicObj.get(ENTRABILLNAME), index);
        this.getModel().setValue("processtype1", dynamicObj.get(PROCESSTYPE), index);
        this.getView().getPageCache().put(BUSINESSKEY, String.valueOf(dynamicObj.get("businessKey")));
        this.getView().getPageCache().put(INSTANCEID, String.valueOf(dynamicObj.get("processInstanceId")));
    }

    public String getExecuteFields() {
        return PUBILCFIELDSTRING;
    }

    private void setDataToExecutionPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("processinstanceid2", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("businessid2", dynamicObj.get("businessid"), index);
        this.getModel().setValue("billno2", dynamicObj.get(BILLNO), index);
        this.getModel().setValue("name2", dynamicObj.get("name"), index);
        this.getModel().setValue("suspensionstate2", dynamicObj.get("suspensionstate"), index);
        this.getModel().setValue("createdate2", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate2", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("entrabillname2", dynamicObj.get(ENTRABILLNAME), index);
        this.getModel().setValue("businesskey2", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("processtype2", dynamicObj.get(PROCESSTYPE), index);
    }

    private void openTab(String mateDataID, String fields, String tabName, String parameterType) {
        String instanceId = this.getView().getPageCache().get(INSTANCEID);
        String businessKey = this.getView().getPageCache().get(BUSINESSKEY);
        if (instanceId == null && businessKey == null) {
            String businessKeyTemp = (String)this.getModel().getValue(BUSINESSKEY);
            if (WfUtils.isEmpty((String)businessKeyTemp)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b", (String)"WorkflowDataQueryToolPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            businessKey = businessKeyTemp;
        }
        QFilter filter = null;
        switch (parameterType) {
            case "instanceid": {
                filter = new QFilter(PROCESSINSTANCEID, "=", (Object)Long.valueOf(instanceId));
                break;
            }
            case "businesskey": {
                filter = new QFilter(BUSINESSKEY, "=", (Object)businessKey);
                break;
            }
        }
        String entryKey = String.format("%sentry", tabName);
        DynamicObjectCollection dynamicObjCollection = QueryServiceHelper.query((String)mateDataID, (String)fields, (QFilter[])new QFilter[]{filter});
        if (dynamicObjCollection == null || dynamicObjCollection.isEmpty()) {
            this.getModel().deleteEntryData(entryKey);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u67e5\u8be2\u7ed3\u679c", (String)"WorkflowDataQueryToolPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
        } else if (!dynamicObjCollection.isEmpty()) {
            int size = dynamicObjCollection.size();
            this.getModel().batchCreateNewEntryRow(entryKey, size);
            block42: for (int i = 0; i < size; ++i) {
                DynamicObject dynamicObj = (DynamicObject)dynamicObjCollection.get(i);
                switch (tabName) {
                    case "executiontab": {
                        this.setDataToExecutionPage(dynamicObj, i);
                        continue block42;
                    }
                    case "hiactinsttab": {
                        this.setFieldToHiactinstPage(dynamicObj, i);
                        continue block42;
                    }
                    case "tasktab": {
                        this.setFieldToTaskPage(dynamicObj, i);
                        continue block42;
                    }
                    case "hitaskinsttab": {
                        this.setFieldToHitaskinstPage(dynamicObj, i);
                        continue block42;
                    }
                    case "participanttab": {
                        this.setFieldToParticipantPage(dynamicObj, i);
                        continue block42;
                    }
                    case "hiparticipanttab": {
                        this.setFieldToHiparticipantPage(dynamicObj, i);
                        continue block42;
                    }
                    case "hicommenttab": {
                        this.setFieldToHicommentPage(dynamicObj, i);
                        continue block42;
                    }
                    case "trdhicommenttab": {
                        this.setFieldToTrdhicommentPage(dynamicObj, i);
                        continue block42;
                    }
                    case "jobrcordtab": {
                        this.setFieldToJobrcordPage(dynamicObj, i);
                        continue block42;
                    }
                    case "timerjobtab": {
                        this.setFieldToTimerJobPage(dynamicObj, i);
                        continue block42;
                    }
                    case "deadletterjobtab": {
                        this.setFieldToDeadLetterJobPage(dynamicObj, i);
                        continue block42;
                    }
                    case "suspendedjobtab": {
                        this.setFieldToSuspendedJobPage(dynamicObj, i);
                        continue block42;
                    }
                    case "hiconditioninsttab": {
                        this.setFieldToHiconditioninstPage(dynamicObj, i);
                        continue block42;
                    }
                    case "variabletab": {
                        this.setFieldToVariablePage(dynamicObj, i);
                        continue block42;
                    }
                    case "hivarinsttab": {
                        this.setFieldToHivarinstPage(dynamicObj, i);
                        continue block42;
                    }
                }
            }
            this.getModel().clearNoDataRow();
        }
    }

    private String getHiactinstFields() {
        return "processinstanceid,processdefinitionid,createdate,modifydate,entitynumber,businesskey,billno,activityname,realdurationinmillis";
    }

    private void setFieldToHiactinstPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("processinstanceid3", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefinitionid3", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("createdate3", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate3", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("entitynumber3", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("businesskey3", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("billno3", dynamicObj.get(BILLNO), index);
        this.getModel().setValue("activityname3", dynamicObj.get(ACTIVITYNAME), index);
        this.getModel().setValue("realdurationinmillis3", dynamicObj.get("realdurationinmillis"), index);
    }

    private String getTaskFields() {
        return TASKFIELDSTRING;
    }

    private void setFieldToTaskPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("name4", dynamicObj.get("name"), index);
        this.getModel().setValue("taskdefinitionkey4", dynamicObj.get("taskdefinitionkey"), index);
        this.getModel().setValue("entityname4", dynamicObj.get("entityname"), index);
        this.getModel().setValue("businesskey4", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("executionid4", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("processinstanceid4", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefinitionid4", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("createdate4", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate4", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("billno4", dynamicObj.get(BILLNO), index);
        this.getModel().setValue("processtype4", dynamicObj.get(PROCESSTYPE), index);
    }

    private String getHitaskinstFields() {
        return "taskdefinitionkey,executionid,processinstanceid,processdefinitionid,realdurationinmillis,name,businesskey,createdate,modifydate,billno";
    }

    private void setFieldToHitaskinstPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("taskdefinitionkey5", dynamicObj.get("taskdefinitionkey"), index);
        this.getModel().setValue("executionid5", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("processinstanceid5", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefinitionid5", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("realdurationinmillis5", dynamicObj.get("realdurationinmillis"), index);
        this.getModel().setValue("name5", dynamicObj.get("name"), index);
        this.getModel().setValue("businesskey5", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("createdate5", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate5", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("billno5", dynamicObj.get(BILLNO), index);
    }

    private String getParticipantFields() {
        return "taskid,processinstanceid,processdefid,username,userid,trustname,createdate,modifydate";
    }

    private void setFieldToParticipantPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("taskid6", dynamicObj.get(TASKID), index);
        this.getModel().setValue("processinstanceid6", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefid6", dynamicObj.get("processdefid"), index);
        this.getModel().setValue("username6", dynamicObj.get("username"), index);
        this.getModel().setValue("userid6", dynamicObj.get(USERID), index);
        this.getModel().setValue("trustname6", dynamicObj.get("trustname"), index);
        this.getModel().setValue("createdate6", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate6", dynamicObj.get(MODIFYDATE), index);
    }

    private String getHiparticipantFields() {
        return "type,userid,processinstanceid,processdefid,ownerid,trustname,transferopinion,createdate,modifydate";
    }

    private void setFieldToHiparticipantPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("type7", dynamicObj.get("type"), index);
        this.getModel().setValue("userid7", dynamicObj.get(USERID), index);
        this.getModel().setValue("processinstanceid7", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefid7", dynamicObj.get("processdefid"), index);
        this.getModel().setValue("ownerid7", dynamicObj.get("ownerid"), index);
        this.getModel().setValue("trustname7", dynamicObj.get("trustname"), index);
        this.getModel().setValue("transferopinion7", dynamicObj.get("transferopinion"), index);
        this.getModel().setValue("createdate7", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate7", dynamicObj.get(MODIFYDATE), index);
    }

    private String getHicommentFields() {
        return HICOMMENTFIELDSTRING;
    }

    private void setFieldToHicommentPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("type8", dynamicObj.get("type"), index);
        this.getModel().setValue("userid8", dynamicObj.get(USERID), index);
        this.getModel().setValue("taskid8", dynamicObj.get(TASKID), index);
        this.getModel().setValue("processinstanceid8", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("activityid8", dynamicObj.get(ACTIVITYID), index);
        this.getModel().setValue("resultname8", dynamicObj.get("resultname"), index);
        this.getModel().setValue("resultnumber8", dynamicObj.get("resultnumber"), index);
        this.getModel().setValue("decisiontype8", dynamicObj.get("decisiontype"), index);
        this.getModel().setValue("activityname8", dynamicObj.get(ACTIVITYNAME), index);
        this.getModel().setValue("businesskey8", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("entitynumber8", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("time8", dynamicObj.get("time"), index);
    }

    private String getTrdhicommentFields() {
        return "type,userid,taskid,processinstanceid,activityid,resultname,resultnumber,decisiontype,activityname,businesskey,entitynumber,time,sourcesystem,sourceapp,assignorname";
    }

    private void setFieldToTrdhicommentPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("type9", dynamicObj.get("type"), index);
        this.getModel().setValue("userid9", dynamicObj.get(USERID), index);
        this.getModel().setValue("taskid9", dynamicObj.get(TASKID), index);
        this.getModel().setValue("processinstanceid9", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("activityid9", dynamicObj.get(ACTIVITYID), index);
        this.getModel().setValue("resultname9", dynamicObj.get("resultname"), index);
        this.getModel().setValue("resultnumber9", dynamicObj.get("resultnumber"), index);
        this.getModel().setValue("decisiontype9", dynamicObj.get("decisiontype"), index);
        this.getModel().setValue("activityname9", dynamicObj.get(ACTIVITYNAME), index);
        this.getModel().setValue("businesskey9", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("entitynumber9", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("time9", dynamicObj.get("time"), index);
        this.getModel().setValue("sourcesystem9", dynamicObj.get("sourcesystem"), index);
        this.getModel().setValue("sourceapp9", dynamicObj.get("sourceapp"), index);
        this.getModel().setValue("assignorname9", dynamicObj.get("assignorname"), index);
    }

    private String getJobrcordFields() {
        return "type,businesskey,processdefinitionid,processinstanceid,timestamp,taskid,jobid,jobtype,srcjobid,elementid,billno,traceno";
    }

    private void setFieldToJobrcordPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("type10", dynamicObj.get("type"), index);
        this.getModel().setValue("processinstanceid10", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("businesskey10", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("processdefinitionid10", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("timestamp10", dynamicObj.get("timestamp"), index);
        this.getModel().setValue("taskid10", dynamicObj.get(TASKID), index);
        this.getModel().setValue("jobid10", dynamicObj.get("jobid"), index);
        this.getModel().setValue("jobtype10", dynamicObj.get(JOBTYPE), index);
        this.getModel().setValue("srcjobid10", dynamicObj.get(SRCJOBID), index);
        this.getModel().setValue("elementid10", dynamicObj.get("elementid"), index);
        this.getModel().setValue("billno10", dynamicObj.get(BILLNO), index);
        this.getModel().setValue("traceno10", dynamicObj.get("traceno"), index);
    }

    private String getTimerJobFields() {
        return "jobtype,lockexpirationtime,executionid,processinstanceid,processdefinitionid,retries,exceptionmessage,duedate,repeat,jobhandlertype,createdate,modifydate,entitynumber,srcjobid,roottraceno,biztraceno";
    }

    private void setFieldToTimerJobPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("jobtype11", dynamicObj.get(JOBTYPE), index);
        this.getModel().setValue("lockexpirationtime11", dynamicObj.get("lockexpirationtime"), index);
        this.getModel().setValue("executionid11", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("processinstanceid11", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefinitionid11", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("retries11", dynamicObj.get("retries"), index);
        this.getModel().setValue("exceptionmessage11", dynamicObj.get("exceptionmessage"), index);
        this.getModel().setValue("duedate11", dynamicObj.get("duedate"), index);
        this.getModel().setValue("repeat11", dynamicObj.get("repeat"), index);
        this.getModel().setValue("jobhandlertype11", dynamicObj.get("jobhandlertype"), index);
        this.getModel().setValue("createdate11", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate11", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("entitynumber11", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("srcjobid11", dynamicObj.get(SRCJOBID), index);
        this.getModel().setValue("roottraceno11", dynamicObj.get("roottraceno"), index);
        this.getModel().setValue("biztraceno11", dynamicObj.get(BIZTRACENO), index);
    }

    private String getDeadLetterJobFields() {
        return "entrabillname,entitynumber,businesskey,elementid,elementname,createdate,errorcode";
    }

    private void setFieldToDeadLetterJobPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("entrabillname12", dynamicObj.get(ENTRABILLNAME), index);
        this.getModel().setValue("entitynumber12", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("businesskey12", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("elementid12", dynamicObj.get("elementid"), index);
        this.getModel().setValue("elementname12", dynamicObj.get("elementname"), index);
        this.getModel().setValue("createdate12", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("errorcode12", dynamicObj.get("errorcode"), index);
    }

    private String getSuspendedJobFields() {
        return "jobtype,executionid,processinstanceid,processdefinitionid,retries,exceptionmessage,duedate,repeat,jobhandlertype,createdate,modifydate,businesskey,operation,entitynumber,srcjobid,roottraceno,biztraceno";
    }

    private void setFieldToSuspendedJobPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("jobtype13", dynamicObj.get(JOBTYPE), index);
        this.getModel().setValue("executionid13", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("processinstanceid13", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("processdefinitionid13", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("retries13", dynamicObj.get("retries"), index);
        this.getModel().setValue("exceptionmessage13", dynamicObj.get("exceptionmessage"), index);
        this.getModel().setValue("duedate13", dynamicObj.get("duedate"), index);
        this.getModel().setValue("repeat13", dynamicObj.get("repeat"), index);
        this.getModel().setValue("jobhandlertype13", dynamicObj.get("jobhandlertype"), index);
        this.getModel().setValue("createdate13", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate13", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("businesskey13", dynamicObj.get(BUSINESSKEY), index);
        this.getModel().setValue("operation13", dynamicObj.get("operation"), index);
        this.getModel().setValue("entitynumber13", dynamicObj.get(ENTITYNUMBER), index);
        this.getModel().setValue("srcjobid13", dynamicObj.get(SRCJOBID), index);
        this.getModel().setValue("roottraceno13", dynamicObj.get("roottraceno"), index);
        this.getModel().setValue("biztraceno13", dynamicObj.get(BIZTRACENO), index);
    }

    private String getHiconditioninstFields() {
        return "processdefinitionid,processinstanceid,executionid,activityid,activityinstid,conditionalruleid,endtime,durationinmillis,createdate,modifydate,key,businesskey";
    }

    private void setFieldToHiconditioninstPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("processdefinitionid14", dynamicObj.get(PROCESSDEFINITIONID), index);
        this.getModel().setValue("processinstanceid14", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("executionid14", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("activityid14", dynamicObj.get(ACTIVITYID), index);
        this.getModel().setValue("activityinstid14", dynamicObj.get("activityinstid"), index);
        this.getModel().setValue("conditionalruleid14", dynamicObj.get("conditionalruleid"), index);
        this.getModel().setValue("endtime14", dynamicObj.get("endtime"), index);
        this.getModel().setValue("durationinmillis14", dynamicObj.get("durationinmillis"), index);
        this.getModel().setValue("createdate14", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate14", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("key14", dynamicObj.get("key"), index);
        this.getModel().setValue("businesskey14", dynamicObj.get(BUSINESSKEY), index);
    }

    private String getVariableFields() {
        return "typename,name,executionid,processinstanceid,taskid,doublevalue,longvalue,textvalue,actinstid,createdate,modifydate";
    }

    private void setFieldToVariablePage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("typename15", dynamicObj.get("typename"), index);
        this.getModel().setValue("name15", dynamicObj.get("name"), index);
        this.getModel().setValue("executionid15", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("processinstanceid15", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("taskid15", dynamicObj.get(TASKID), index);
        this.getModel().setValue("doublevalue15", dynamicObj.get("doublevalue"), index);
        this.getModel().setValue("longvalue15", dynamicObj.get("longvalue"), index);
        this.getModel().setValue("textvalue15", dynamicObj.get("textvalue"), index);
        this.getModel().setValue("actinstid15", dynamicObj.get("actinstid"), index);
        this.getModel().setValue("createdate15", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate15", dynamicObj.get(MODIFYDATE), index);
    }

    private String getHivarinstFields() {
        return HIVARINSTFIELDSTRING;
    }

    private void setFieldToHivarinstPage(DynamicObject dynamicObj, int index) {
        this.getModel().setValue("processinstanceid16", dynamicObj.get(PROCESSINSTANCEID), index);
        this.getModel().setValue("executionid16", dynamicObj.get(EXECUTIONID), index);
        this.getModel().setValue("taskid16", dynamicObj.get(TASKID), index);
        this.getModel().setValue("name16", dynamicObj.get("name"), index);
        this.getModel().setValue("typename16", dynamicObj.get("typename"), index);
        this.getModel().setValue("doublevalue16", dynamicObj.get("doublevalue"), index);
        this.getModel().setValue("longvalue16", dynamicObj.get("longvalue"), index);
        this.getModel().setValue("textvalue16", dynamicObj.get("textvalue"), index);
        this.getModel().setValue("time16", dynamicObj.get("time"), index);
        this.getModel().setValue("createdate16", dynamicObj.get(CREATEDATE), index);
        this.getModel().setValue("modifydate16", dynamicObj.get(MODIFYDATE), index);
        this.getModel().setValue("actinstid16", dynamicObj.get("actinstid"), index);
    }
}

