/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.Modify;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfDBUtils;

public class WorkflowRepairTaskListPlugin
extends AbstractListPlugin {
    private static final String BTNSHOWLOG = "btnshowlog";
    private static final String BTNENABLE = "btnenable";
    private static final String BTNDISABLE = "btndisable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (args.getSource() instanceof Modify && rows != null && rows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"WorkflowRepairTaskListPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTNSHOWLOG.equals(evt.getItemKey())) {
            this.showRepairLogList();
        }
        if (BTNENABLE.equals(evt.getItemKey())) {
            this.stateConvert("1");
        }
        if (BTNDISABLE.equals(evt.getItemKey())) {
            this.stateConvert("0");
        }
    }

    private void showRepairLogList() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null) {
            if (rows.size() == 1) {
                long id = (Long)rows.get(0).getPrimaryKeyValue();
                IFormView settingsFormView = DesignerModelUtil.getTabControlView((IFormView)this.getView());
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("wf_repairlog");
                parameter.setFormId("bos_list");
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setFilter(new QFilter("taskid", "=", (Object)id));
                parameter.setListFilterParameter(listFilterParameter);
                if (settingsFormView != null) {
                    parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                    parameter.getOpenStyle().setTargetKey("_submaintab_");
                    parameter.setCustomParam("isOpenNewTab", (Object)true);
                    settingsFormView.showForm((FormShowParameter)parameter);
                    this.getView().sendFormAction(settingsFormView);
                } else {
                    parameter.getOpenStyle().setShowType(ShowType.NonModal);
                    this.getView().showForm((FormShowParameter)parameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"WorkflowRepairTaskListPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        }
    }

    private void stateConvert(String state) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null) {
            if (!rows.isEmpty()) {
                ArrayList<Object[]> ids = new ArrayList<Object[]>(rows.size());
                for (int i = 0; i < rows.size(); ++i) {
                    ids.add(new Object[]{rows.get(i).getPrimaryKeyValue()});
                }
                String sql = "update t_wf_repairtask set fenable='" + state + "' where fid= ? ;";
                WfDBUtils.executeBatch((String)sql, ids, (Integer)100);
                this.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WorkflowRepairTaskListPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"WorkflowRepairTaskListPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        }
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }
}

