/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowRepaireDataPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CLEANTEMP = "cleantemp";
    private static final String BTN_LOADTEMP = "loadtemp";
    private static final String BTN_REPAIREROLE = "repairerole";
    private static final String BTN_REPAIRERESOURCE = "repaireresource";
    private static final String FIELD_KEYS = "keys";
    private static final String FIELD_OBJID = "objid";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String OK = "OK";
    private static final String WF_REPAIREDATA = "wf_repairedata";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CLEANTEMP, BTN_LOADTEMP, BTN_REPAIREROLE, BTN_REPAIRERESOURCE});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "cleantemp": {
                this.deleteTempData();
                break;
            }
            case "loadtemp": {
                this.loadRoleDataToTemp();
                break;
            }
            case "repairerole": {
                this.repaireRole();
                break;
            }
            case "repaireresource": {
                this.repaireResource();
                break;
            }
        }
    }

    private void deleteTempData() {
        try {
            DeleteServiceHelper.delete((String)WF_REPAIREDATA, (QFilter[])new QFilter[]{new QFilter(ID, "!=", (Object)0L)});
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.getView().showSuccessNotification(OK);
    }

    private void loadRoleDataToTemp() {
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        try {
            DynamicObjectCollection items = QueryServiceHelper.query((String)"wf_role", (String)ID, (QFilter[])new QFilter[]{new QFilter(ID, "!=", (Object)0L)});
            if (WfUtils.isNotEmptyForCollection((Collection)items)) {
                for (DynamicObject item : items) {
                    Long id = (Long)item.get(ID);
                    DynamicObject role = BusinessDataServiceHelper.loadSingle((Object)id, (String)"wf_role");
                    DynamicObjectCollection roleEntry = role.getDynamicObjectCollection("roleentry");
                    if (!WfUtils.isNotEmptyForCollection((Collection)roleEntry)) continue;
                    for (DynamicObject row : roleEntry) {
                        Long orgId;
                        DynamicObject user = row.getDynamicObject("user");
                        DynamicObject org = row.getDynamicObject("org");
                        if (null == user || null == org) continue;
                        Long userId = (Long)user.getPkValue();
                        if (!userIds.contains(userId)) {
                            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)WF_REPAIREDATA);
                            obj.set(FIELD_OBJID, (Object)userId);
                            obj.set(NUMBER, user.get(NUMBER));
                            obj.set("type", (Object)"user");
                            obj.set("key", user.get(NUMBER));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                            userIds.add(userId);
                        }
                        if (orgIds.contains(orgId = (Long)org.getPkValue())) continue;
                        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)WF_REPAIREDATA);
                        obj.set(FIELD_OBJID, (Object)orgId);
                        obj.set(NUMBER, org.get(NUMBER));
                        obj.set("type", (Object)"org");
                        obj.set("key", org.get(NUMBER));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                        orgIds.add(orgId);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.getView().showSuccessNotification(OK);
    }

    private void repaireRole() {
        try {
            DynamicObjectCollection temps = QueryServiceHelper.query((String)WF_REPAIREDATA, (String)"id,objid,number,type,key", (QFilter[])new QFilter[]{new QFilter(ID, "!=", (Object)0L)});
            if (WfUtils.isNotEmptyForCollection((Collection)temps)) {
                ArrayList<Object[]> userParam = new ArrayList<Object[]>();
                ArrayList<Object[]> orgParam = new ArrayList<Object[]>();
                for (DynamicObject temp : temps) {
                    DynamicObject org;
                    Long trueId;
                    Long id;
                    String num = temp.getString(NUMBER);
                    if (WfUtils.isEmpty((String)num)) continue;
                    String type = (String)temp.get("type");
                    if ("user".equals(type)) {
                        DynamicObject user;
                        id = temp.getLong(FIELD_OBJID);
                        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)num)});
                        if (null != users && users.length > 0 && !(trueId = (Long)(user = users[0]).getPkValue()).equals(id)) {
                            userParam.add(new Object[]{trueId, id});
                        }
                    }
                    if (!"org".equals(type)) continue;
                    id = temp.getLong(FIELD_OBJID);
                    DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)num)});
                    if (null == orgs || orgs.length <= 0 || (trueId = (Long)(org = orgs[0]).getPkValue()).equals(id)) continue;
                    orgParam.add(new Object[]{trueId, id});
                }
                if (WfUtils.isNotEmptyForCollection(userParam)) {
                    String sql = "update t_wf_roleentry set fuser= ? where fuser= ? ";
                    WfDBUtils.executeBatch((String)sql, userParam, (Integer)500);
                }
                if (WfUtils.isNotEmptyForCollection(orgParam)) {
                    String sql1 = "update t_wf_roleentry set forg=? where forg= ? ";
                    String sql2 = "update t_wf_procdef set forgunitid=? where forgunitid= ? ";
                    String sql3 = "update t_wf_model set forgunitid=? where forgunitid= ? ";
                    WfDBUtils.executeBatch((String)sql1, orgParam, (Integer)500);
                    WfDBUtils.executeBatch((String)sql2, orgParam, (Integer)500);
                    WfDBUtils.executeBatch((String)sql3, orgParam, (Integer)500);
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.getView().showSuccessNotification(OK);
    }

    private void repaireResource() {
        Object keys = this.getModel().getValue(FIELD_KEYS);
        if (WfUtils.isEmptyString((Object)keys)) {
            this.getView().showTipNotification("keys can not be empty");
            return;
        }
        try {
            Map<Long, Long> idMap = this.getTempKeys();
            String[] procKeys = keys.toString().split(",");
            if (null != procKeys && procKeys.length > 0) {
                for (String key : procKeys) {
                    if (!WfUtils.isEmpty((String)key)) continue;
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.getView().showSuccessNotification(OK);
    }

    private Map<Long, Long> getTempKeys() {
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        try {
            DynamicObjectCollection temps = QueryServiceHelper.query((String)WF_REPAIREDATA, (String)"id,objid,number,type,key", (QFilter[])new QFilter[]{new QFilter(ID, "!=", (Object)0L)});
            if (WfUtils.isNotEmptyForCollection((Collection)temps)) {
                for (DynamicObject temp : temps) {
                    DynamicObject org;
                    DynamicObject[] orgs;
                    DynamicObject user;
                    Long trueId;
                    DynamicObject[] users;
                    String num = temp.getString(NUMBER);
                    if (WfUtils.isEmpty((String)num)) continue;
                    String type = (String)temp.get("type");
                    Long id = temp.getLong(FIELD_OBJID);
                    if ("user".equals(type) && null != (users = BusinessDataServiceHelper.load((String)"bos_user", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)num)})) && users.length > 0 && !(trueId = (Long)(user = users[0]).getPkValue()).equals(id)) {
                        idMap.put(id, trueId);
                    }
                    if (!"org".equals(type) || null == (orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)num)})) || orgs.length <= 0 || (trueId = (Long)(org = orgs[0]).getPkValue()).equals(id)) continue;
                    idMap.put(id, trueId);
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return idMap;
    }
}

