/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.message.service.util.MessageCacheUtils;
import kd.bos.workflow.support.plugin.AbstractWorkflowSupportPlugin;

public class WorkflowVerificationPlugin
extends AbstractWorkflowSupportPlugin {
    private static final String FORMID = "formid";
    private static final String FORMNUMBER = "formnumber";
    private static final String APPNUMBER = "appnumber";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FORMID});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("true".equals(this.getPageCache().get("modify"))) {
            return;
        }
        Object formId = this.getModel().getValue(FORMID);
        if (null != formId) {
            DynamicObject billedObject = (DynamicObject)formId;
            this.initDorpDown(String.valueOf(billedObject.getString("number")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object formId = this.getModel().getValue(FORMID);
        if (null == formId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868\u5355\u5bf9\u8c61\u3002", (String)"WorkflowVerificationPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Object appNumber = this.getModel().getValue(APPNUMBER);
        if (WfUtils.isEmptyString((Object)appNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9a8c\u6743\u5e94\u7528\u3002", (String)"WorkflowVerificationPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String op = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(op)) {
            String formNumber = (String)this.getModel().getValue(FORMNUMBER);
            MessageCacheUtils.cleanCheckRightAppIdCache((String)formNumber);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (FORMID.equals(propName)) {
            this.getPageCache().put("modify", "true");
            DynamicObject billObject = (DynamicObject)newValue;
            String formNumber = String.valueOf(billObject.getString("number"));
            this.initDorpDown(formNumber);
            this.getModel().setValue(FORMNUMBER, (Object)formNumber);
        }
    }

    private void initDorpDown(String formNumber) {
        if (WfUtils.isEmpty((String)formNumber) || "null".equalsIgnoreCase(formNumber)) {
            return;
        }
        ArrayList comboItems = new ArrayList();
        HashMap dataMap = new HashMap();
        if (WfUtils.isNotEmptyString((Object)formNumber)) {
            List publishAppIds;
            DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
            HashMap<String, String> idToNumber = new HashMap<String, String>();
            HashMap<String, String> numberToName = new HashMap<String, String>();
            if (WfUtils.isNotEmptyForCollection((Collection)apps)) {
                for (DynamicObject obj : apps) {
                    String id = obj.getString("id");
                    String number = obj.getString("number");
                    idToNumber.put(id, number);
                    String name = obj.getString("name");
                    numberToName.put(number, name);
                }
            }
            String entityNum = FormMetadataCache.getFormConfig((String)formNumber).getEntityTypeId();
            String appIdOfEntity = EntityMetadataCache.getDataEntityType((String)entityNum).getBizAppNumber();
            dataMap.put(appIdOfEntity, numberToName.get(appIdOfEntity));
            PermissionControlType permissionControlType = EntityMetadataCache.getPermissionControlType((String)entityNum);
            if (permissionControlType != null && WfUtils.isNotEmptyForCollection((Collection)(publishAppIds = permissionControlType.getPublishApps()))) {
                for (String id : publishAppIds) {
                    String appNumber = (String)idToNumber.get(id);
                    dataMap.put(appNumber, numberToName.get(appNumber));
                }
            }
        }
        dataMap.forEach((k, v) -> {
            ComboItem comboItem = new ComboItem();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(v + '(' + k + ')');
            comboItem.setCaption(localeString);
            comboItem.setValue(k);
            comboItems.add(comboItem);
        });
        ComboEdit combEdit = (ComboEdit)this.getControl(APPNUMBER);
        combEdit.setComboItems(comboItems);
    }
}

