/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class ArchiveHiparticipantRepairTaskExecutor
implements HistoryRepairTaskExecutor {
    private static Log logger = LogFactory.getLog(ArchiveHiparticipantRepairTaskExecutor.class);
    private static final String ENTITY_HIPARTICIPANT = "wf_hiparticipant";
    private static final String PROCINSTID = "processinstanceid";
    private static final String ENTITY_HITASK = "wf_hitaskinst";
    private static final String HIDATAENDDATE = "hiDataEndDate";
    private static final String TARGETDATE = "targetDate";
    private static final String CREATEDATE = "createdate";
    private static final String ISFINISH = "isFinish";
    private static final String TASKID = "taskid";
    private static final String ID = "id";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        HistoryRepairTaskResult repairTaskResult = new HistoryRepairTaskResult();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        int limitSize = param.getLimitSize();
        int times = param.getTimes();
        Map<String, Object> require = param.getRequire();
        Date lastQueryDate = null;
        Date hiDataEndDate = null;
        if (require != null && !require.isEmpty()) {
            if (require.get(TARGETDATE) != null) {
                String date = (String)require.get(TARGETDATE);
                try {
                    lastQueryDate = sdf.parse(date);
                }
                catch (ParseException e) {
                    logger.debug("HistoryRepairTaskResult--targetdate invoke error" + e.getMessage());
                }
            }
            if (require.get(HIDATAENDDATE) != null) {
                String endDate = (String)require.get(HIDATAENDDATE);
                try {
                    hiDataEndDate = sdf.parse(endDate);
                }
                catch (ParseException e) {
                    logger.debug("HistoryRepairTaskResult--targetdate invoke error" + e.getMessage());
                }
            } else {
                hiDataEndDate = this.getHiparticipantDataEndDate();
            }
        } else {
            hiDataEndDate = this.getHiparticipantDataEndDate();
        }
        logger.debug(String.format("HistoryRepairTaskResult and targetDate[%s], hiDataEndDate[%s]", lastQueryDate, hiDataEndDate));
        if (hiDataEndDate == null) {
            repairTaskResult.setState(RepairTaskState.FINISHED);
            return repairTaskResult;
        }
        boolean isFinish = Boolean.FALSE;
        Map<String, Object> repairResult = null;
        for (int i = 0; i < times; ++i) {
            repairResult = this.correctHiparticipant(limitSize, lastQueryDate, hiDataEndDate);
            if (repairResult == null) continue;
            lastQueryDate = (Date)repairResult.get(TARGETDATE);
            isFinish = (Boolean)repairResult.get(ISFINISH);
            if (isFinish) break;
        }
        if (isFinish) {
            repairTaskResult.setState(RepairTaskState.FINISHED);
        } else {
            repairTaskResult.setState(RepairTaskState.RUNNING);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TARGETDATE, sdf.format(lastQueryDate));
        map.put(HIDATAENDDATE, sdf.format(hiDataEndDate));
        logger.debug(String.format("HistoryRepairTaskResult and map[%s]", ((Object)map).toString()));
        repairTaskResult.setRequire(map);
        return repairTaskResult;
    }

    private Date getHiparticipantDataEndDate() {
        Date date = null;
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)0L)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)ENTITY_HIPARTICIPANT, (String)CREATEDATE, (QFilter[])filters, (String)"createdate desc", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                date = ((Row)iterator.next()).getDate(CREATEDATE);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("HistoryRepairTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return date;
    }

    private Date getQueryEndDate(Date queryStartDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(queryStartDate);
        calendar.add(2, 3);
        return calendar.getTime();
    }

    private Map<String, Object> correctHiparticipant(int limitSize, Date lastQueryDate, Date hiDataEndDate) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Date queryStartDate = this.getQueryStartDate(lastQueryDate);
        Date queryEndDate = this.getQueryEndDate(queryStartDate);
        logger.debug(String.format("HistoryRepairTaskResult and queryStartDate[%s], queryEndDate[%s]", queryStartDate, queryEndDate));
        HashSet<Long> taskIds = new HashSet<Long>();
        Date endDate = null;
        QFilter f1 = new QFilter(PROCINSTID, "=", (Object)0L);
        QFilter f2 = new QFilter(TASKID, ">", (Object)0L);
        QFilter f3 = new QFilter(CREATEDATE, ">=", (Object)queryStartDate).and(CREATEDATE, "<", (Object)queryEndDate);
        String selectProperties = "taskid,createdate";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"entity_hiparticipantquery", (String)ENTITY_HIPARTICIPANT, (String)selectProperties, (QFilter[])new QFilter[]{f1, f2, f3}, (String)"createdate asc", (int)limitSize);){
            for (Row row : dataSet) {
                Long id = row.getLong(TASKID);
                if (!WfUtils.isNotEmpty((Long)id)) continue;
                taskIds.add(row.getLong(TASKID));
                endDate = row.getDate(CREATEDATE);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("HistoryRepairTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        Date date = endDate == null ? queryEndDate : endDate;
        data.put(TARGETDATE, date);
        if (hiDataEndDate.before(date) || new Date().before(queryEndDate)) {
            data.put(ISFINISH, Boolean.TRUE);
        } else {
            data.put(ISFINISH, Boolean.FALSE);
        }
        if (taskIds.isEmpty()) {
            data.put(TARGETDATE, queryEndDate);
            return data;
        }
        ArrayList<Long[]> paramsList = new ArrayList<Long[]>();
        QFilter[] taskFilters = new QFilter[]{new QFilter(ID, "in", taskIds)};
        try (DataSet taskDataSet = QueryServiceHelper.queryDataSet((String)"entity_queryHitask", (String)ENTITY_HITASK, (String)"id,processinstanceid", (QFilter[])taskFilters, null);){
            for (Row taskRow : taskDataSet) {
                Long[] param = new Long[]{taskRow.getLong(PROCINSTID), taskRow.getLong(ID)};
                paramsList.add(param);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("HistoryRepairHiTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (paramsList.isEmpty()) {
            data.put(TARGETDATE, endDate);
            return data;
        }
        logger.debug("HistoryRepairTaskResult and repair hiparticipant");
        try {
            String updateSql = "update t_wf_hiparticipant set fprocinstid = ? where ftaskid = ?;";
            WfUtils.executeBatch((String)updateSql, paramsList, (Integer)1000);
        }
        catch (Exception e) {
            logger.debug(String.format("HistoryRepairTaskResult--updateHiparticipantDataIsError and info:%s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return data;
    }

    private Date getQueryStartDate(Date targetDate) {
        Date queryStartDate = null;
        if (targetDate != null) {
            queryStartDate = targetDate;
        } else {
            QFilter[] filterTime = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)0L)};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)ENTITY_HIPARTICIPANT, (String)CREATEDATE, (QFilter[])filterTime, (String)"createdate asc", (int)1);){
                Iterator iterator = dataSet.iterator();
                if (iterator.hasNext()) {
                    queryStartDate = ((Row)iterator.next()).getDate(CREATEDATE);
                }
            }
            catch (Exception e) {
                logger.debug(String.format("HistoryRepairHiPartparentResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        return queryStartDate;
    }
}

