/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class HistorySmsUsedQuantityExecutor
implements HistoryRepairTaskExecutor {
    private static final String WF_MSG_MESSAGE = "wf_msg_message";
    private static final String WF_MSG_HIMESSAGE = "wf_msg_himessage";
    private static final String WF_MSG_FAILMESSAGE = "wf_msg_failmessage";
    private static final String WF_CONFCENTER = "wf_confcenter";
    private static final String WF_SMSUSINGQUANTITY = "wf_smsusingquantity";
    private static final String VALUE = "value";
    private static final String CREATEDATE = "createdate";
    private static final String CHANNELS = "channels";
    private static final String CHANNEL = "channel";
    private static final String SMSNUMBER = "smsNumber";
    private static final String PERMITENDDATE = "permitEndDate";
    private static final String STATE = "state";
    private static final String SERVICECLASS = "serviceclass";
    private static final String SERVICECLASSNAME = "kd.bos.workflow.engine.msg.handler.SMSServiceHandler";
    private static final String PREFIX = "d@f*g:";
    private static Log logger = LogFactory.getLog(HistorySmsUsedQuantityExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        logger.debug("HistorySmsUsedQuantityExecutor-limitsize:" + param.getLimitSize() + "times :" + param.getTimes());
        try (TXHandle tx = TX.requiresNew((String)"HistorySmsUsedQuantityExecutor");){
            String smsNumber = "";
            DynamicObject smsObj = null;
            Long smsUsedNum = 0L;
            DynamicObject[] smsUsingObjs = BusinessDataServiceHelper.load((String)WF_SMSUSINGQUANTITY, (String)"id, smsNumber, permitEndDate", null, (String)"permitEndDate desc");
            if (smsUsingObjs != null && smsUsingObjs.length > 0) {
                logger.debug("HistorySmsUsedQuantityExecutor-smsUsingObjs.length:" + smsUsingObjs.length);
                if (smsUsingObjs.length > 1) {
                    this.delteConfCenterPropertys();
                    result.setState(RepairTaskState.FINISHED);
                    HistoryRepairTaskResult historyRepairTaskResult = result;
                    return historyRepairTaskResult;
                }
                smsObj = smsUsingObjs[0];
                smsNumber = smsObj.getString(SMSNUMBER);
                try {
                    smsNumber = smsNumber.startsWith(PREFIX) ? Encrypters.decode((String)smsNumber) : smsNumber;
                    smsUsedNum = WfUtils.isNotEmpty((String)smsNumber) ? Long.parseLong(smsNumber) : 0L;
                    logger.debug("HistorySmsUsedQuantityExecutor-smsNumber:" + smsNumber);
                    logger.debug("HistorySmsUsedQuantityExecutor-smsUsedNum:" + smsUsedNum);
                }
                catch (Exception e) {
                    logger.debug("HistorySmsUsedQuantityExecutor is error, errorinfo is : smsUsedNumber is Destroyed");
                }
            } else {
                result.setState(RepairTaskState.TOHANDLE);
                HistoryRepairTaskResult e = result;
                return e;
            }
            Date permitStartDate = this.getPermitStartDate();
            if (permitStartDate == null) {
                result.setState(RepairTaskState.ERRORED);
                throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"HistorySmsUsedQuantityExecutor permitStartDate is null "});
            }
            if (permitStartDate.compareTo(new Date()) >= 0) {
                logger.debug("HistorySmsUsedQuantityExecutor-permitStartDate > now");
                result.setState(RepairTaskState.FINISHED);
                HistoryRepairTaskResult historyRepairTaskResult = result;
                return historyRepairTaskResult;
            }
            Long msgNum = 0L;
            Long hiMsgNum = 0L;
            Long failMsgNum = 0L;
            for (int i = 0; i < param.getTimes(); ++i) {
                DynamicObject msgObj = HistorySmsUsedQuantityExecutor.getConfCenterProperty("message", "msg.sms.msgcreatedate");
                DynamicObject hiMsgObj = HistorySmsUsedQuantityExecutor.getConfCenterProperty("message", "msg.sms.himsgcreatedate");
                DynamicObject failMsgObj = HistorySmsUsedQuantityExecutor.getConfCenterProperty("message", "msg.sms.failmsgcreatedate");
                if (msgObj == null && hiMsgObj == null && failMsgObj == null) {
                    logger.debug("HistorySmsUsedQuantityExecutor-is finished");
                    result.setState(RepairTaskState.FINISHED);
                    break;
                }
                msgNum = msgNum + this.getHiSmsUsedNumber(WF_MSG_MESSAGE, msgObj, permitStartDate, "msg.sms.msgcreatedate", param.getLimitSize());
                hiMsgNum = hiMsgNum + this.getHiSmsUsedNumber(WF_MSG_HIMESSAGE, hiMsgObj, permitStartDate, "msg.sms.himsgcreatedate", param.getLimitSize());
                failMsgNum = failMsgNum + this.getFailSmsNumber(failMsgObj, permitStartDate, "msg.sms.failmsgcreatedate", param.getLimitSize());
                logger.debug("HistorySmsUsedQuantityExecutor-msgNum:" + msgNum);
                logger.debug("HistorySmsUsedQuantityExecutor-hiMsgNum:" + hiMsgNum);
                logger.debug("HistorySmsUsedQuantityExecutor-failMsgNum:" + failMsgNum);
            }
            smsUsedNum = smsUsedNum + msgNum + hiMsgNum - failMsgNum;
            smsObj.set(SMSNUMBER, (Object)Encrypters.encode((String)smsUsedNum.toString()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{smsObj});
        }
        return result;
    }

    private Long getHiSmsUsedNumber(String entityName, DynamicObject obj, Date permitStartDate, String key, int limitSize) {
        Long num = 0L;
        if (obj != null) {
            Date createDate = obj.getDate(VALUE);
            DynamicObjectCollection cl = null;
            QFilter q1 = new QFilter(CREATEDATE, ">", (Object)permitStartDate);
            QFilter q2 = new QFilter(CREATEDATE, "<", (Object)createDate);
            QFilter q3 = new QFilter(CHANNELS, "!=", (Object)" ");
            cl = QueryServiceHelper.query((String)entityName, (String)"createdate, channels", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"createdate desc", (int)limitSize);
            if (WfUtils.isNotEmptyForCollection((Collection)cl) && cl.size() > 0) {
                createDate = ((DynamicObject)cl.get(cl.size() - 1)).getDate(CREATEDATE);
                for (DynamicObject dynamicObject : cl) {
                    String channels = dynamicObject.getString(CHANNELS);
                    if (!channels.contains("475773159430184960") && !channels.contains("sms")) continue;
                    Long l = num;
                    Long l2 = num = Long.valueOf(num + 1L);
                }
                logger.debug("HistorySmsUsedQuantityExecutor-entityName:" + entityName + " num : " + num);
            } else {
                logger.debug("HistorySmsUsedQuantityExecutor-entityName:" + entityName + "is finish");
                createDate = permitStartDate;
            }
            this.compareDate(permitStartDate, createDate, key, obj);
        }
        return num;
    }

    private Long getFailSmsNumber(DynamicObject obj, Date permitStartDate, String key, int limitSize) {
        Long num = 0L;
        if (obj != null) {
            Date createDate = obj.getDate(VALUE);
            DynamicObjectCollection cl = null;
            QFilter q1 = new QFilter(CREATEDATE, ">", (Object)permitStartDate);
            QFilter q2 = new QFilter(CREATEDATE, "<", (Object)createDate);
            QFilter q3 = new QFilter(CHANNEL, "=", (Object)"sms");
            QFilter q4 = new QFilter(STATE, "=", (Object)"fail");
            QFilter q5 = new QFilter(SERVICECLASS, "=", (Object)SERVICECLASSNAME);
            cl = QueryServiceHelper.query((String)WF_MSG_FAILMESSAGE, (String)CREATEDATE, (QFilter[])new QFilter[]{q1, q2, q3, q4, q5}, (String)"createdate desc", (int)limitSize);
            if (WfUtils.isNotEmptyForCollection((Collection)cl) && cl.size() > 0) {
                createDate = ((DynamicObject)cl.get(cl.size() - 1)).getDate(CREATEDATE);
                num = cl.size();
            } else {
                logger.debug("HistorySmsUsedQuantityExecutor-entityName:wf_msg_failmessage is finish");
                createDate = permitStartDate;
            }
            this.compareDate(permitStartDate, createDate, key, obj);
        }
        return num;
    }

    private void compareDate(Date permitStartDate, Date createDate, String key, DynamicObject obj) {
        if (permitStartDate.compareTo(createDate) >= 0) {
            this.delteConfCenterProperty("message", key);
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            obj.set(VALUE, (Object)format.format(createDate));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    private void delteConfCenterProperty(String type, String key) {
        QFilter f1 = new QFilter("type", "=", (Object)type);
        QFilter f2 = new QFilter("key", "=", (Object)key);
        DeleteServiceHelper.delete((String)WF_CONFCENTER, (QFilter[])new QFilter[]{f1, f2});
    }

    private void delteConfCenterPropertys() {
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("msg.sms.msgcreatedate");
        list.add("msg.sms.himsgcreatedate");
        list.add("msg.sms.failmsgcreatedate");
        QFilter f1 = new QFilter("type", "=", (Object)"message");
        QFilter f2 = new QFilter("key", "in", list);
        DeleteServiceHelper.delete((String)WF_CONFCENTER, (QFilter[])new QFilter[]{f1, f2});
    }

    private Date getPermitStartDate() {
        Date permitStartDate = null;
        Map map = LicenseServiceHelper.getGroupTimeRange((Long)MessageCenterServiceImpl.GROUPID);
        if (map != null && !map.isEmpty()) {
            permitStartDate = (Date)map.get("beginDate");
            logger.debug("HistorySmsUsedQuantityExecutor-permitStartDate:" + permitStartDate);
        }
        return permitStartDate;
    }

    private static DynamicObject getConfCenterProperty(String type, String key) {
        DynamicObject obj = null;
        try {
            QFilter f1 = new QFilter("type", "=", (Object)type);
            QFilter f2 = new QFilter("key", "=", (Object)key);
            obj = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)"id,type,key,value", (QFilter[])new QFilter[]{f1, f2});
        }
        catch (Exception e) {
            logger.debug("getConfigCenterProperty:" + e.getMessage());
        }
        return obj;
    }
}

