/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizType;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataState;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class PreheatMessageQuantitySummaryExecutor
implements HistoryRepairTaskExecutor {
    static final Log logger = LogFactory.getLog(PreheatMessageQuantitySummaryExecutor.class);
    private static final int queryLevel = 500;
    private static final String PREHEATSTARTTIME = "preheatStartTime";
    private static final String PREHEATENDTIME = "preheatEndTime";
    public static final String ENTITY_CONCURRENTDATA = "wf_concurrentdata";
    public static final String ENTITY_QUANTITYSUMMARY = "msg_quantitysum";
    public static final String CREATER = "creater";
    public static final String TYPE = "type";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        result.setState(RepairTaskState.RUNNING);
        Map<String, Object> resultRequire = result.getRequire();
        if (resultRequire == null) {
            resultRequire = new HashMap<String, Object>();
            result.setRequire(resultRequire);
        }
        if (!this.isNeedPreheat(param)) {
            result.setState(RepairTaskState.FINISHED);
            resultRequire.put("dscription", "notNeedPreheat");
            return result;
        }
        Date preheatStartTime = this.getPreHeatStartTime(param);
        resultRequire.put(PREHEATSTARTTIME, preheatStartTime);
        Map<Long, Long> userInfos = this.getTargetUserInfos(param);
        if (!userInfos.isEmpty()) {
            this.executeTask(param, userInfos);
            if (!QueryServiceHelper.exists((String)ENTITY_CONCURRENTDATA, (QFilter[])new QFilter[]{new QFilter(TYPE, "=", (Object)this.getCurrentDateType())})) {
                result.setState(RepairTaskState.FINISHED);
                resultRequire.put(PREHEATENDTIME, TimeServiceHelper.now());
            }
        } else {
            result.setState(RepairTaskState.FINISHED);
            resultRequire.put(PREHEATENDTIME, TimeServiceHelper.now());
        }
        return result;
    }

    protected void executeTask(HistoryRepairTaskParam param, Map<Long, Long> userInfos) {
        int limitSize = param.getLimitSize();
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        ArrayList<Long> userIds = new ArrayList<Long>(userInfos.keySet());
        for (int times = param.getTimes(); times > 0 && !userIds.isEmpty(); --times) {
            List<Long> subUserIds = userIds.size() >= limitSize ? userIds.subList(0, limitSize) : userIds.subList(0, userIds.size());
            this.executeTaskOneTime(service, subUserIds);
            userIds.removeAll(subUserIds);
        }
        this.deleteTargetUser(userInfos);
    }

    protected void deleteTargetUser(Map<Long, Long> userInfos) {
        Collection<Long> values = userInfos.values();
        DeleteServiceHelper.delete((String)ENTITY_CONCURRENTDATA, (QFilter[])new QFilter[]{new QFilter("id", "in", values)});
    }

    private void executeTaskOneTime(MessageQuantitySummaryServcie service, List<Long> userIdsOneTime) {
        int batch = 5;
        int total = userIdsOneTime.size();
        int page = total % batch != 0 ? total / batch + 1 : total / batch;
        for (int i = 0; i < page; ++i) {
            List<Long> userIds = userIdsOneTime.subList(i * batch, Math.min((i + 1) * batch, total));
            service.correctQuantitySummaryFromBizDataNoRecoredResult(userIds);
        }
    }

    protected String getCurrentDateType() {
        return ConcurrentBizType.MESSAGEQUANTITYSUMMARYPREHEAT.getType();
    }

    protected Map<Long, Long> getTargetUserInfos(HistoryRepairTaskParam param) {
        this.initializeTargetUserInfo(param);
        HashMap<Long, Long> targetUserInfos = new HashMap<Long, Long>();
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        QFilter[] filters = new QFilter[]{new QFilter(TYPE, "=", (Object)this.getCurrentDateType())};
        DynamicObjectCollection concurrentDatas = QueryServiceHelper.query((String)ENTITY_CONCURRENTDATA, (String)"id, creater", (QFilter[])filters, null, (int)(times * limitSize));
        if (concurrentDatas != null && !concurrentDatas.isEmpty()) {
            for (DynamicObject concurrentData : concurrentDatas) {
                targetUserInfos.put(concurrentData.getLong(CREATER), concurrentData.getLong("id"));
            }
        }
        return targetUserInfos;
    }

    private int getPreheatMsgQsInfoRange() {
        int range = 12;
        try {
            QFilter qs = new QFilter("key", "=", (Object)"msg.preheatMsgQsInfoRange");
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{qs});
            if (ret != null) {
                range = ret.getInt("value");
            }
        }
        catch (Exception e) {
            logger.info("getQuantitySummaryTraceUserIds function has exception:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return -range;
    }

    protected void initializeTargetUserInfo(HistoryRepairTaskParam param) {
        Map<String, Object> require = param.getRequire();
        if (require != null && require.containsKey(PREHEATSTARTTIME)) {
            return;
        }
        String limitTime = "";
        try {
            Date currentTime = TimeServiceHelper.now();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentTime);
            calendar.add(2, this.getPreheatMsgQsInfoRange());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            limitTime = sdf.format(calendar.getTime());
        }
        catch (Exception currentTime) {
            // empty catch block
        }
        StringBuilder sql = new StringBuilder("select * from (select count(1) summary, fuserid userId from t_wf_hicomment ");
        if (WfUtils.isNotEmpty((String)limitTime)) {
            sql.append("where ftime >= {ts '").append(limitTime).append("'}");
        }
        sql.append("group by fuserid) as tempTab ").append("where tempTab.summary >= ").append(500).append(";");
        ArrayList<Long> targetUserIds = new ArrayList<Long>();
        try {
            DataSet rows = DB.queryDataSet((String)"queryTargetUserIds", (DBRoute)DBRoute.workflow, (String)sql.toString());
            Object object = null;
            try {
                while (rows.hasNext()) {
                    Row row = rows.next();
                    targetUserIds.add(row.getLong("userId"));
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (rows != null) {
                    if (object != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u521d\u59cb\u5316\u76ee\u6807\u7528\u6237\u5931\u8d25, \u5931\u8d25\u539f\u56e0[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (targetUserIds.isEmpty()) {
            return;
        }
        try {
            ArrayList<DynamicObject> concurrentDatas = new ArrayList<DynamicObject>(targetUserIds.size());
            for (Long userId : targetUserIds) {
                DynamicObject concurrentData = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_CONCURRENTDATA);
                concurrentData.set(CREATER, (Object)String.valueOf(userId));
                concurrentData.set("state", (Object)ConcurrentDataState.CREATE.getState());
                concurrentData.set(TYPE, (Object)ConcurrentBizType.MESSAGEQUANTITYSUMMARYPREHEAT.getType());
                concurrentDatas.add(concurrentData);
            }
            DynamicObject[] concurrentDataArray = new DynamicObject[concurrentDatas.size()];
            SaveServiceHelper.save((DynamicObject[])concurrentDatas.toArray(concurrentDataArray));
        }
        catch (Exception e) {
            logger.error(String.format("\u521d\u59cb\u5316\u76ee\u6807\u7528\u6237\u5931\u8d25, \u5931\u8d25\u539f\u56e0[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    private boolean isNeedPreheat(HistoryRepairTaskParam param) {
        Date preheatStartTime = this.getPreHeatStartTime(param);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preheatStartTime);
        calendar.add(5, -2);
        Date limitDate = calendar.getTime();
        QFilter[] filters = new QFilter[]{new QFilter("updatedate", "<", (Object)limitDate)};
        return !QueryServiceHelper.exists((String)ENTITY_QUANTITYSUMMARY, (QFilter[])filters);
    }

    private Date getPreHeatStartTime(HistoryRepairTaskParam param) {
        Date preheatStartTime = null;
        try {
            Map<String, Object> require = param.getRequire();
            if (require != null && require.containsKey(PREHEATSTARTTIME)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                preheatStartTime = sdf.parse((String)require.get(PREHEATSTARTTIME));
            } else {
                preheatStartTime = TimeServiceHelper.now();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return preheatStartTime;
    }
}

