/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.upgrade.WorkflowPresetProcTemplateServiceImpl;

public class PresetProcessTemplateServiceExecutor
extends WorkflowPresetProcTemplateServiceImpl
implements HistoryRepairTaskExecutor {
    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        result.setState(RepairTaskState.FINISHED);
        String fields = "id, filename, filecontent, issuccess, executiontime, errorinfo";
        QFilter[] filters = new QFilter[]{new QFilter("issuccess", "=", (Object)false), new QFilter("type", "=", (Object)"proctpl")};
        DynamicObject[] deployInfos = BusinessDataServiceHelper.load((String)"wf_deploysql", (String)fields, (QFilter[])filters, (String)"id desc");
        if (deployInfos.length < 1) {
            this.log.debug("No unsuccessful scripts executed.");
            return result;
        }
        boolean success = true;
        for (DynamicObject deployInfo : deployInfos) {
            this.log.debug(String.format("begin deploy procTemplate %s.", deployInfo.getString("filename")));
            UpgradeResult ret = this.deployProcTemplate(deployInfo);
            if (ret.isSuccess()) continue;
            success = false;
        }
        if (!success) {
            result.setState(RepairTaskState.TOHANDLE);
        }
        return result;
    }
}

