/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigFactory;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class RepairCompactHiProcDataExecutor
implements HistoryRepairTaskExecutor {
    private Log logger = LogFactory.getLog(RepairCompactHiProcDataExecutor.class);
    private static final String START_EXE_DATE = "startExeDate";
    private static final String MAX_EXE_DATE = "maxExeDate";
    private Date startExeDate;
    private Date lastExeDate;
    private Date maxExeDate;
    protected WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        this.logger.debug("\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u538b\u7f29\u5f00\u59cb\uff01");
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        if (!WfConfigurationUtil.useCleanFrame()) {
            result.setState(RepairTaskState.FINISHED);
            this.logger.debug(String.format("\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u538b\u7f29\u7ed3\u675f\uff0c\u6e05\u7406\u6846\u67b6\u53c2\u6570[%s]\u672a\u5f00\u542f\uff01", "workflow.runtime.usecleanFrame"));
            return result;
        }
        int times = param.getTimes() == 0 ? 20 : param.getTimes();
        int limitSize = param.getLimitSize() == 0 ? 3 : param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(2);
        }
        for (int i = 0; i < times; ++i) {
            if (!this.compactProcData(require, limitSize)) continue;
            result.setRequire(require);
            result.setState(RepairTaskState.FINISHED);
            return result;
        }
        result.setRequire(require);
        result.setState(RepairTaskState.RUNNING);
        this.logger.debug("\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u538b\u7f29\u7ed3\u675f!");
        return result;
    }

    private boolean compactProcData(Map<String, Object> require, int limitSize) {
        boolean result = false;
        this.initExeDates(require, limitSize);
        if (this.startExeDate == null) {
            return true;
        }
        this.logger.debug(String.format("\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u538b\u7f29\u8fdb\u884c\u4e2d\uff0c[%s]-[%s]\u4e4b\u95f4\u7684\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u5c06\u88ab\u538b\u7f29\uff01", this.startExeDate, this.lastExeDate));
        Date retentionDate = this.lastExeDate;
        QFilter[] filters = new QFilter[]{new QFilter("endTime", ">=", (Object)this.startExeDate), new QFilter("endTime", "<=", (Object)this.lastExeDate), new QFilter("processtype", "in", (Object)new String[]{ProcessType.AuditFlow.name(), ProcessType.BizFlow.name()})};
        int i = 0;
        ArrayList<Long> procInstIds = new ArrayList<Long>(10);
        String selectFeilds = String.format("%s,%s", "endTime", "processInstanceId");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"RepairCompactHiProcDataExecutor.compactProcData", (String)"wf_hiprocinst", (String)selectFeilds, (QFilter[])filters, (String)String.format("%s asc", "endTime"), (int)50000);){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                procInstIds.add(row.getLong("processInstanceId"));
                this.lastExeDate = row.getDate("endTime");
                if (++i % 50 != 0) continue;
                this.disposePartData(procInstIds);
                procInstIds.clear();
            }
        }
        if (i % 50 > 0) {
            this.disposePartData(procInstIds);
        }
        this.logger.debug(String.format("\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u538b\u7f29\u8fdb\u884c\u4e2d\uff0c[%s]-[%s]\u4e4b\u95f4\u7684\u5386\u53f2\u6d41\u7a0b\u6570\u636e\u5df2\u7ecf\u88ab\u538b\u7f29\uff01", this.startExeDate, this.lastExeDate));
        if (i < 50000) {
            this.lastExeDate = retentionDate;
        }
        require.put(START_EXE_DATE, this.lastExeDate.getTime());
        result = this.lastExeDate.equals(this.maxExeDate) || this.lastExeDate.after(this.maxExeDate);
        return result;
    }

    protected void disposePartData(List<Long> procInstIds) {
        this.logger.debug("RepairCompactHiProcDataExecutor\u64cd\u4f5c\u65e5\u5fd7\u5206\u6279\u5f00\u59cb\u538b\u7f29");
        if (WfUtils.isNotEmptyForCollection(procInstIds)) {
            this.wfService.getHistoryService().compactFinishedProcessDatas(procInstIds, EntityCompactConfigFactory.getCompactConfig((String)"wf_hiactinst"));
        }
        this.logger.debug("RepairCompactHiProcDataExecutor\u64cd\u4f5c\u65e5\u5fd7\u5206\u6279\u5f00\u59cb\u538b\u7f29");
    }

    private void initExeDates(Map<String, Object> require, int limitSize) {
        Calendar calendar;
        block19: {
            calendar = Calendar.getInstance();
            Long maxExeDateTime = (Long)require.get(MAX_EXE_DATE);
            Long startExeDateTime = (Long)require.get(START_EXE_DATE);
            if (WfUtils.isEmpty((Long)maxExeDateTime)) {
                this.maxExeDate = WfUtils.now();
                require.put(MAX_EXE_DATE, this.maxExeDate.getTime());
            } else {
                this.maxExeDate = new Date(maxExeDateTime);
            }
            if (WfUtils.isEmpty((Long)startExeDateTime)) {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"RepairCompactHiProcDataExecutor.initExeDates", (String)"wf_hiprocinst", (String)"endTime", (QFilter[])new QFilter[]{new QFilter("endTime", "is not null", null)}, (String)String.format("%s asc", "endTime"), (int)1);){
                    if (dataSet != null && dataSet.hasNext()) {
                        Row row = dataSet.next();
                        this.startExeDate = row.getDate("endTime");
                        break block19;
                    }
                    this.logger.debug("\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5df2\u7ed3\u675f\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u6d41\u7a0b\u538b\u7f29\u5386\u53f2\u6570\u636e\u4fee\u590d\u4efb\u52a1\u7ed3\u675f\u3002");
                    return;
                }
            }
            this.startExeDate = new Date(startExeDateTime);
        }
        calendar.setTime(this.startExeDate);
        calendar.add(5, limitSize);
        this.lastExeDate = calendar.getTime();
        if (this.lastExeDate.after(this.maxExeDate)) {
            this.lastExeDate = this.maxExeDate;
        }
    }
}

