/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.util.WfSupportUtil;

public class RepairMessageExecutor
implements HistoryRepairTaskExecutor {
    private static final String STARTDATE = "startDate";
    private static final String LASTDATE = "lastdate";
    private static final int LIMITDAYS = -1;
    private static final String CREATEDATE = "createdate";
    private static final String WF_MSG_MESSAGE = "wf_msg_message";
    private static final String WF_MSG_RECEIVER = "wf_msg_receiver";
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Log logger = LogFactory.getLog(RepairMessageExecutor.class);

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(3);
        }
        if (require.get(STARTDATE) == null) {
            require.put(STARTDATE, this.getStartDate());
        }
        if (require.get(LASTDATE) == null) {
            require.put(LASTDATE, this.format.format(WfUtils.now()));
        }
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        this.logger.debug("RepairMessageExecutor--limitsize: " + limitSize + ", times: " + times + ", require: " + require);
        for (int i = 0; i < times; ++i) {
            if (!this.repairMessageData(limitSize, require).booleanValue()) continue;
            this.logger.debug("RepairMessageExecutor--repair is finished");
            result.setState(RepairTaskState.FINISHED);
            result.setRequire(require);
            return result;
        }
        this.logger.debug("RepairMessageExecutor--lastDate: " + require.get(LASTDATE));
        result.setRequire(require);
        result.setState(RepairTaskState.RUNNING);
        return result;
    }

    private Boolean repairMessageData(int limitSize, Map<String, Object> require) {
        Date startDate = this.getDateFromParam(require, STARTDATE);
        Date endDateOfThisTime = this.getDateFromParam(require, LASTDATE);
        if (startDate == null || endDateOfThisTime == null || endDateOfThisTime.compareTo(startDate) <= 0) {
            return Boolean.TRUE;
        }
        Date startDateOfThisTime = this.getStartDate(endDateOfThisTime, require);
        Set<Long> msgIdsInMessage = this.queryMsgIdsInMessage(require, startDateOfThisTime, endDateOfThisTime, limitSize);
        if (WfUtils.isEmptyForCollection(msgIdsInMessage)) {
            if (startDate.before(startDateOfThisTime)) {
                require.put(LASTDATE, this.format.format(startDateOfThisTime));
                this.logger.debug("RepairMessageExecutor--repairMessageData lastDate: " + this.format.format(startDateOfThisTime));
                return Boolean.FALSE;
            }
            this.logger.debug("RepairMessageExecutor--repairMessageData is finished");
            return Boolean.TRUE;
        }
        Set<Long> msgIdsInReceiver = this.queryMsgIdsInReceiver(msgIdsInMessage);
        msgIdsInMessage.removeAll(msgIdsInReceiver);
        if (WfUtils.isNotEmptyForCollection(msgIdsInMessage)) {
            DeleteServiceHelper.delete((String)WF_MSG_MESSAGE, (QFilter[])new QFilter[]{new QFilter("id", "in", msgIdsInMessage)});
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> queryMsgIdsInMessage(Map<String, Object> require, Date startDate, Date endDate, int limitSize) {
        HashSet<Long> msgIdsInMessage = new HashSet<Long>(limitSize);
        try (DataSet dataSet = null;){
            QFilter q1 = new QFilter(CREATEDATE, ">", (Object)startDate);
            QFilter q2 = new QFilter(CREATEDATE, "<=", (Object)endDate);
            QFilter[] timeFilter = new QFilter[]{q1, q2};
            dataSet = QueryServiceHelper.queryDataSet((String)"query_message_fids", (String)WF_MSG_MESSAGE, (String)"id,createdate", (QFilter[])timeFilter, (String)"createdate desc", (int)limitSize);
            if (!dataSet.isEmpty()) {
                int tag = 0;
                Date createDate = null;
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    ++tag;
                    Row row = (Row)iterator.next();
                    msgIdsInMessage.add(row.getLong("id"));
                    createDate = row.getDate(CREATEDATE);
                }
                if (createDate != null) {
                    String thisDate = this.format.format(createDate);
                    if (thisDate.equals(this.format.format(endDate)) && tag < limitSize) {
                        this.logger.debug("RepairMessageExecutor thisDate :" + thisDate + " tag:" + tag);
                        thisDate = this.format.format(startDate);
                    }
                    require.put(LASTDATE, thisDate);
                }
            }
        }
        return msgIdsInMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> queryMsgIdsInReceiver(Set<Long> msgIdsInMessage) {
        HashSet<Long> msgIdsInReceiver = new HashSet<Long>(msgIdsInMessage.size());
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{new QFilter("messageid", "in", msgIdsInMessage)};
            dataSet = QueryServiceHelper.queryDataSet((String)"query_msgreceiver_fids", (String)WF_MSG_RECEIVER, (String)"messageid", (QFilter[])qFilters, null);
            if (!dataSet.isEmpty()) {
                for (Row row : dataSet) {
                    msgIdsInReceiver.add(row.getLong("messageid"));
                }
            }
        }
        return msgIdsInReceiver;
    }

    private String getStartDate() {
        String firstDate = "";
        QFilter[] timeFilter = new QFilter[]{new QFilter(CREATEDATE, "is not null", null)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_message_createdate", (String)WF_MSG_MESSAGE, (String)CREATEDATE, (QFilter[])timeFilter, (String)"id asc", (int)1);){
            Date date;
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext() && (date = ((Row)iterator.next()).getDate(CREATEDATE)) != null) {
                firstDate = this.format.format(date);
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("RepairMessageExecutor--getFirstDate is Error %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return firstDate;
    }

    private Date getDateFromParam(Map<String, Object> require, String key) {
        Date date = null;
        if (require == null) {
            return date;
        }
        if (StringUtils.isNotBlank((Object)require.get(key))) {
            try {
                date = this.format.parse((String)require.get(key));
            }
            catch (Exception e) {
                this.logger.debug("RepairMessageExecutor formatDate getDateFromParam is error:" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return date;
    }

    private Date getStartDate(Date endTime, Map<String, Object> require) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(endTime);
        cal.add(5, this.getLimitDays(require));
        return cal.getTime();
    }

    private int getLimitDays(Map<String, Object> require) {
        int limitDays = -1;
        if (require != null && StringUtils.isNotBlank((Object)require.get("limitDays")) && WfSupportUtil.isInteger((String)require.get("limitDays"))) {
            limitDays = Integer.parseInt((String)require.get("limitDays")) * -1;
        }
        return limitDays;
    }
}

