/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.util.WfSupportUtil;
import org.jsoup.Jsoup;

public class RepairMsgReceiverContentSummaryExecutor
implements HistoryRepairTaskExecutor {
    private static final String LASTDATE = "lastdate";
    private static final String FIRSTDATE = "firstdate";
    private static final String FIRSTDATE_VALUE = "2017-01-01 00:00:00";
    private static final int SAVECOUNT = 300;
    private static final int LIMITDAYS = -10;
    private static final String WF_MSG_MESSAGE = "wf_msg_message";
    private static final String WF_MSG_RECEIVER = "wf_msg_receiver";
    private static final String CREATEDATE = "createdate";
    private static final String MESSAGEID = "messageId";
    private Log logger = LogFactory.getLog(RepairMsgReceiverContentSummaryExecutor.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(3);
        }
        require.put(FIRSTDATE, this.getFirstDate());
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        this.logger.debug("RepairMsgReceiverContentSummaryExecutor--limitsize: " + limitSize + ", times: " + times + ", require: " + require);
        for (int i = 0; i < times; ++i) {
            if (!this.repairMsgReceiverData(limitSize, require).booleanValue()) continue;
            this.logger.debug("RepairMsgReceiverContentSummaryExecutor--repair is finished");
            WfSupportUtil.updateWfConfCenterInfo("global", "msg.msgreceiver.repaireMsgContentSummaryFinish", "true", "repaire msgreceiver contentSummary");
            result.setState(RepairTaskState.FINISHED);
            result.setRequire(require);
            return result;
        }
        this.logger.debug("RepairMsgReceiverContentSummaryExecutor--lastDate: " + require.get(LASTDATE));
        result.setRequire(require);
        result.setState(RepairTaskState.RUNNING);
        return result;
    }

    private String getFirstDate() {
        Date date = null;
        QFilter[] timeFilter = new QFilter[]{new QFilter(CREATEDATE, "is not null", null)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)WF_MSG_RECEIVER, (String)CREATEDATE, (QFilter[])timeFilter, (String)"id", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                date = ((Row)iterator.next()).getDate(CREATEDATE);
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("RepairMsgReceiverContentSummaryExecutor--getFirstDate is Error %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (date != null) {
            return this.format.format(date);
        }
        return FIRSTDATE_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean repairMsgReceiverData(int limitSize, Map<String, Object> require) {
        block15: {
            Date firstTime;
            Date endTime = this.getTimeFromParm(require, LASTDATE);
            if (endTime.compareTo(firstTime = this.getTimeFromParm(require, FIRSTDATE)) <= 0) {
                return Boolean.TRUE;
            }
            Date startTime = this.getStartTime(endTime, require);
            this.logger.debug("RepairMsgReceiverContentSummaryExecutor--repairMsgReceiverData endTime: " + endTime + ", startTime: " + startTime);
            QFilter q1 = new QFilter(CREATEDATE, ">", (Object)startTime);
            QFilter q2 = new QFilter(CREATEDATE, "<=", (Object)endTime);
            QFilter[] timeFilter = new QFilter[]{q1, q2};
            try (DataSet dataSet = null;){
                dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)WF_MSG_RECEIVER, (String)"id,messageId,createdate", (QFilter[])timeFilter, (String)"createdate desc", (int)limitSize);
                if (!dataSet.isEmpty()) {
                    int tag = 0;
                    HashSet<Long> ids = new HashSet<Long>(limitSize);
                    HashMap<Long, Long> reveiverMap = new HashMap<Long, Long>();
                    Iterator iterator = dataSet.iterator();
                    while (iterator.hasNext()) {
                        boolean isEnd;
                        Row row = (Row)iterator.next();
                        Long messageId = row.getLong(MESSAGEID);
                        Date createDate = row.getDate(CREATEDATE);
                        reveiverMap.put(row.getLong("id"), messageId);
                        ids.add(messageId);
                        boolean bl = isEnd = !iterator.hasNext();
                        if (++tag % 300 == 0 || isEnd) {
                            Map<Long, DynamicObject> msgMap = this.queryMsgData(ids);
                            this.updateMsgReceiverData(msgMap, reveiverMap);
                            reveiverMap.clear();
                            msgMap.clear();
                            ids.clear();
                        }
                        if (createDate == null || !isEnd) continue;
                        String thisDate = this.format.format(createDate);
                        if (thisDate.equals(this.format.format(endTime)) && tag < limitSize) {
                            this.logger.debug("RepairMsgReceiverContentSummaryExecutor thisDate :" + thisDate + " tag:" + tag);
                            thisDate = this.format.format(startTime);
                        }
                        require.put(LASTDATE, thisDate);
                    }
                    break block15;
                }
                String firstDate = (String)require.get(FIRSTDATE);
                try {
                    Date ff = this.format.parse(firstDate);
                    if (ff.before(startTime)) {
                        require.put(LASTDATE, this.format.format(startTime));
                        this.logger.debug("RepairMsgReceiverContentSummaryExecutor--repairMsgReceiverData lastDate: " + this.format.format(startTime));
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                }
                catch (ParseException e) {
                    this.logger.debug("repairMsgReceiverData first date is null:" + e.getMessage());
                }
                this.logger.debug("RepairMsgReceiverContentSummaryExecutor--repairMsgReceiverData is finished");
                Boolean bl = Boolean.TRUE;
                return bl;
            }
        }
        return Boolean.FALSE;
    }

    private void updateMsgReceiverData(Map<Long, DynamicObject> msgMap, Map<Long, Long> reveiverMap) {
        ArrayList<Long> updateReceiverIds = new ArrayList<Long>(1);
        ArrayList<Long> deleteReceiverIds = new ArrayList<Long>(1);
        if (reveiverMap == null || reveiverMap.isEmpty()) {
            return;
        }
        if (msgMap.isEmpty()) {
            deleteReceiverIds.addAll(reveiverMap.keySet().stream().collect(Collectors.toList()));
        } else {
            for (Map.Entry<Long, Long> entry : reveiverMap.entrySet()) {
                if (msgMap.get(entry.getValue()) == null) {
                    deleteReceiverIds.add(entry.getKey());
                    continue;
                }
                updateReceiverIds.add(entry.getKey());
            }
        }
        this.updateData(updateReceiverIds, deleteReceiverIds, msgMap);
    }

    private void updateData(List<Long> updateReceiverIds, List<Long> deleteReceiverIds, Map<Long, DynamicObject> msgMap) {
        try {
            if (updateReceiverIds != null && !updateReceiverIds.isEmpty()) {
                QFilter f1 = new QFilter("id", "in", updateReceiverIds);
                DynamicObject[] objects = BusinessDataServiceHelper.load((String)WF_MSG_RECEIVER, (String)"id,messageid,content_summary,contenturl", (QFilter[])new QFilter[]{f1});
                if (objects != null && objects.length > 0) {
                    ArrayList<DynamicObject> msgReceiverList = new ArrayList<DynamicObject>();
                    for (DynamicObject msgReceiverObj : objects) {
                        DynamicObject msgObj = msgMap.get(msgReceiverObj.getLong("messageid"));
                        if (msgObj == null) continue;
                        ILocaleString content = msgObj.getLocaleString("content");
                        if (WfUtils.isNotEmpty((ILocaleString)content)) {
                            for (Map.Entry entry : content.entrySet()) {
                                String val = Jsoup.parse((String)((String)entry.getValue())).text();
                                if (val != null && val.length() >= 255) {
                                    val = val.substring(0, 251) + "...";
                                }
                                content.put(entry.getKey(), (Object)val);
                            }
                            msgReceiverObj.set("content_summary", (Object)content);
                        }
                        msgReceiverObj.set("contenturl", msgObj.get("contenturl"));
                        msgReceiverList.add(msgReceiverObj);
                    }
                    if (msgReceiverList != null && !msgReceiverList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])msgReceiverList.toArray(new DynamicObject[0]));
                        msgReceiverList.clear();
                    }
                }
                updateReceiverIds.clear();
            }
            if (deleteReceiverIds != null && !deleteReceiverIds.isEmpty()) {
                QFilter[] q2 = new QFilter[]{new QFilter("id", "in", deleteReceiverIds)};
                DeleteServiceHelper.delete((String)WF_MSG_RECEIVER, (QFilter[])q2);
                deleteReceiverIds.clear();
            }
        }
        catch (Exception e) {
            this.logger.debug("RepairMsgReceiverContentSummaryExecutor--updateData is error: " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, DynamicObject> queryMsgData(Set<Long> ids) {
        HashMap<Long, DynamicObject> msgMap = new HashMap<Long, DynamicObject>();
        try (DataSet dataSet = null;){
            String sql = "select fid,fcontenturl from t_wf_message where fid in (?) ;";
            sql = sql.replaceAll("\\?", WfUtils.getQuestionMarkList((int)ids.size()));
            dataSet = DB.queryDataSet((String)"queryMsgData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])ids.toArray());
            if (dataSet == null) {
                HashMap<Long, DynamicObject> hashMap = msgMap;
                return hashMap;
            }
            int tag = 0;
            Iterator iterator = dataSet.iterator();
            ArrayList<Object> messageIds = new ArrayList<Object>(300);
            while (iterator.hasNext()) {
                boolean isEnd;
                ++tag;
                Row row = (Row)iterator.next();
                Long messageId = row.getLong("fid");
                messageIds.add(messageId);
                DynamicObject msgObj = BusinessDataServiceHelper.newDynamicObject((String)WF_MSG_MESSAGE);
                msgObj.set("contenturl", row.get("fcontenturl"));
                msgObj.set("id", (Object)messageId);
                msgMap.put(messageId, msgObj);
                boolean bl = isEnd = !iterator.hasNext();
                if (tag % 300 != 0 && !isEnd) continue;
                this.queryMultiMsgDataAndPackageData(messageIds, msgMap);
                messageIds.clear();
            }
        }
        return msgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryMultiMsgDataAndPackageData(List<Object> messageIds, Map<Long, DynamicObject> msgMap) {
        if (WfUtils.isEmptyForMap(msgMap)) {
            return;
        }
        try (DataSet dataSet = null;){
            String sql = "select fid,flocaleid,substring(fcontent,0,256) fcontent from t_wf_message_l where fid in (?) ;";
            sql = sql.replaceAll("\\?", WfUtils.getQuestionMarkList((int)messageIds.size()));
            dataSet = DB.queryDataSet((String)"queryMultiMsgDataAndPackageData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])messageIds.toArray());
            if (dataSet == null) {
                return;
            }
            Iterator iterator = dataSet.iterator();
            HashMap<Long, ILocaleString> contentMap = new HashMap<Long, ILocaleString>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long messageId = row.getLong("fid");
                String lang = row.getString("flocaleid");
                ILocaleString content = (ILocaleString)contentMap.get(messageId);
                if (WfUtils.isEmpty((ILocaleString)content)) {
                    content = new LocaleString();
                }
                content.put((Object)lang, (Object)row.getString("fcontent"));
                contentMap.put(messageId, content);
            }
            if (WfUtils.isEmptyForMap(contentMap)) {
                return;
            }
            for (Map.Entry<Long, DynamicObject> entry : msgMap.entrySet()) {
                DynamicObject msgObj = entry.getValue();
                msgObj.set("content", contentMap.get(entry.getKey()));
            }
        }
    }

    private Date getStartTime(Date endTime, Map<String, Object> require) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(endTime);
        cal.add(5, this.getLimitDays(require));
        return cal.getTime();
    }

    private int getLimitDays(Map<String, Object> require) {
        int limitDays = -10;
        if (require != null && StringUtils.isNotBlank((Object)require.get("limitDays")) && WfSupportUtil.isInteger((String)require.get("limitDays"))) {
            limitDays = Integer.parseInt((String)require.get("limitDays")) * -1;
        }
        return limitDays;
    }

    private Date getTimeFromParm(Map<String, Object> require, String key) {
        Date time = WfUtils.now();
        if (require != null && StringUtils.isNotBlank((Object)require.get(key))) {
            try {
                time = this.format.parse((String)require.get(key));
            }
            catch (Exception e) {
                this.logger.debug("repairMsgReceiverData formate getTimeFromParm is error:" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return time;
    }
}

