/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.util.WfSupportUtil;

public class RepairOperationLogFieldExecutor
implements HistoryRepairTaskExecutor {
    private static Log logger = LogFactory.getLog(RepairOperationLogFieldExecutor.class);
    private static final String CLASS_NAME = "RepairOperationLogFieldExecutor";
    private static final Integer BATCH_NUM = 1000;
    private static final Integer TOPNUMBER = 50000;
    private static final String FID = "FID";
    private static final String MINFID = "MINFID";
    private static final String WF_CONF_KEY = "workflow.isCompletedRepairOperationLogField";
    private static final String TRUE = "true";
    private static final String WF_CONF_TYPE = "global";
    private static final String WF_CONF_DESC = "completed repair operationLog field";
    private static final Long TASK_FID = 1560228909079907328L;

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        HistoryRepairTaskResult exeResult = new HistoryRepairTaskResult();
        try {
            int topNum;
            exeResult.setState(RepairTaskState.RUNNING);
            Map<String, Object> paramMap = param.getRequire();
            Map<String, Boolean> isCompleteMap = new HashMap<String, Boolean>(2);
            int n = topNum = param.getLimitSize() == 0 ? TOPNUMBER.intValue() : param.getLimitSize();
            if (WfUtils.isNotEmptyForMap(paramMap)) {
                for (Map.Entry<String, Object> params : paramMap.entrySet()) {
                    String tableName = params.getKey();
                    Map value = (Map)params.getValue();
                    Long fid = Long.parseLong(String.valueOf(value.get(FID)));
                    Long minFid = Long.parseLong(String.valueOf(value.get(MINFID)));
                    List<Object[]> ids = RepairOperationLogFieldExecutor.getFIdList(tableName, fid, minFid, paramMap, topNum);
                    RepairOperationLogFieldExecutor.updateField(tableName, ids);
                    if (ids.size() > 0) {
                        isCompleteMap = RepairOperationLogFieldExecutor.isComplete(tableName, (Long)ids.get(0)[0], minFid, isCompleteMap);
                        continue;
                    }
                    isCompleteMap = RepairOperationLogFieldExecutor.isComplete(tableName, fid, minFid, isCompleteMap);
                }
            }
            String tempValue = WfSupportUtil.getWfConfCenterInfo(WF_CONF_KEY);
            if (RepairOperationLogFieldExecutor.isAllCompleted(isCompleteMap).booleanValue() || TRUE.equalsIgnoreCase(tempValue)) {
                exeResult.setState(RepairTaskState.FINISHED);
            }
            return exeResult;
        }
        catch (Exception e) {
            logger.debug("RepairOperationLogFieldExecutor occurred exception:" + e.getMessage());
            exeResult.setState(RepairTaskState.ERRORED);
            return exeResult;
        }
    }

    private static Boolean isAllCompleted(Map<String, Boolean> isCompleteMap) {
        boolean completeFlag = false;
        for (Map.Entry<String, Boolean> params : isCompleteMap.entrySet()) {
            if (params.getValue().booleanValue()) continue;
            completeFlag = true;
        }
        if (!completeFlag) {
            WfSupportUtil.writeWfConfCenterInfo(WF_CONF_KEY, TRUE, WF_CONF_TYPE, WF_CONF_DESC);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Map<String, Boolean> isComplete(String tableName, Long currentFid, Long minFid, Map<String, Boolean> retMap) {
        if (currentFid.longValue() == minFid.longValue()) {
            retMap.put(tableName, true);
        } else {
            retMap.put(tableName, false);
        }
        return retMap;
    }

    private static List<Object[]> getFIdList(String tableName, Long fid, Long minFid, Map<String, Object> param, int topNum) {
        StringBuilder querySql = new StringBuilder("SELECT TOP ");
        querySql.append(topNum).append(" FID  FROM ").append(tableName);
        querySql.append(" WHERE FOPINION  IS NOT NULL AND FOPINION!=' '");
        if (fid != 0L) {
            querySql.append(" AND FID <= ").append(fid);
        }
        querySql.append(" ORDER BY FID DESC");
        List dataRet = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                ArrayList<Object[]> ids = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    ids.add(new Object[]{rs.getLong(RepairOperationLogFieldExecutor.FID)});
                }
                return ids;
            }
        });
        Long currentFid = fid;
        if (dataRet.size() > 0) {
            currentFid = (Long)((Object[])dataRet.get(dataRet.size() - 1))[0];
        }
        RepairOperationLogFieldExecutor.updateParam(tableName, currentFid, minFid, param);
        return dataRet;
    }

    private static void updateParam(String tableName, Long fid, Long minFid, Map<String, Object> requireMap) {
        Map valueMap = (Map)requireMap.get(tableName);
        if (0L == minFid) {
            valueMap.put(MINFID, RepairOperationLogFieldExecutor.getMinFId(tableName));
        }
        valueMap.put(FID, fid);
        requireMap.put(tableName, valueMap);
        StringBuilder sql = new StringBuilder("update t_wf_repairtask set fparams=").append("'").append(SerializationUtils.toJsonString(requireMap));
        sql.append("'").append(" where fid=").append(TASK_FID);
        DB.execute((DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[0]);
    }

    public static Long getMinFId(String tableName) {
        Long result = 0L;
        StringBuilder sql = new StringBuilder(" SELECT TOP 1 FID FROM ");
        sql.append(tableName).append(" ORDER BY FID ");
        DataSet dataset = DB.queryDataSet((String)WfUtils.createAlgoKey((String)CLASS_NAME), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[0]);
        Iterator iterator = dataset.iterator();
        if (iterator != null && iterator.hasNext()) {
            Row row = (Row)iterator.next();
            result = (Long)row.get(FID);
        }
        return result;
    }

    private static void updateField(String tableName, List<Object[]> updateParamsList) {
        try {
            StringBuilder batchSql = new StringBuilder();
            batchSql.append("UPDATE ").append(tableName).append(" SET fnopinion=substring(fopinion,1,2000)  WHERE FID=? ;");
            WfDBUtils.executeBatch((String)batchSql.toString(), updateParamsList, (Integer)BATCH_NUM);
        }
        catch (Exception e) {
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }
}

