/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.workCalendar.WorkCalendarUtil;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.util.WfSupportUtil;

public class RepairRealDurationExecutor
implements HistoryRepairTaskExecutor {
    private static Log logger = LogFactory.getLog(RepairRealDurationExecutor.class);
    private static final String FCREATEDATE = "FCREATEDATE";
    private static final String FENDTIME = "FENDTIME";
    private static final String FPROCINSTID = "FPROCINSTID";
    private static final String FID = "FID";
    private static final String WF_CONF_REAL_KEY = "workflow.isCompleteRepairApproveDuration";
    private static final String CLASS_NAME = "RepairRealDurationExecutor";
    private static final int DEAL_NUM = 5000;
    private static final Integer BATCH_NUM = 1000;
    private static final Long TASK_FID = 1414379604260441088L;
    private static final String MINFID = "MINFID";
    private static final String T_WF_HITASKINST = "T_WF_HITASKINST";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        HistoryRepairTaskResult ret = new HistoryRepairTaskResult();
        logger.debug("execute repair realDuration begin");
        try {
            Boolean success = this.executeRepair(param);
            if (success.booleanValue()) {
                ret.setState(RepairTaskState.RUNNING);
                String tempValue = WfSupportUtil.getWfConfCenterInfo(WF_CONF_REAL_KEY);
                if ("true".equalsIgnoreCase(tempValue)) {
                    ret.setState(RepairTaskState.FINISHED);
                    RepairRealDurationExecutor.deleteConferCenterKeyForAnalysisAlreadyDeal();
                    logger.debug("finish repair data");
                }
            }
            return ret;
        }
        catch (Exception e) {
            ret.setState(RepairTaskState.ERRORED);
            logger.debug(String.format("execute task occurred exception -{%s}", WfUtils.getExceptionStacktrace((Throwable)e)));
            return ret;
        }
    }

    private Boolean executeRepair(HistoryRepairTaskParam param) throws ParseException {
        int limitSize = param.getLimitSize() == 0 ? 5000 : param.getLimitSize();
        Map<String, Object> paramMap = param.getRequire();
        if (WfUtils.isEmptyForMap(paramMap)) {
            logger.debug("require param is empty!");
            return false;
        }
        Map<String, Boolean> isCompleted = new HashMap<String, Boolean>(paramMap.size());
        for (Map.Entry<String, Object> params : paramMap.entrySet()) {
            logger.debug(String.format("the param is-[%s]", param));
            String tableName = params.getKey();
            Map value = (Map)params.getValue();
            Long fid = Long.parseLong(String.valueOf(value.get(FID)));
            Long minFid = Long.parseLong(String.valueOf(value.get(MINFID)));
            List<Map<String, Object>> dataList = RepairRealDurationExecutor.getDataList(tableName, limitSize, fid, minFid, paramMap);
            if (WfUtils.isNotEmptyForCollection(dataList)) {
                this.executeTask(tableName, dataList);
                Long currentMinId = (Long)dataList.get(dataList.size() - 1).get(FID);
                isCompleted = RepairRealDurationExecutor.isComplete(tableName, currentMinId, minFid, isCompleted);
                continue;
            }
            isCompleted = RepairRealDurationExecutor.isComplete(tableName, fid, minFid, isCompleted);
        }
        if (WfUtils.isNotEmptyForMap(isCompleted)) {
            Boolean completeFlag = false;
            for (Map.Entry params : isCompleted.entrySet()) {
                if (((Boolean)params.getValue()).booleanValue()) continue;
                completeFlag = true;
            }
            if (!completeFlag.booleanValue()) {
                WfSupportUtil.writeWfConfCenterInfo(WF_CONF_REAL_KEY, "true", "global", "completed repair approve realDuration");
            }
        }
        return Boolean.TRUE;
    }

    private void executeTask(String table, List<Map<String, Object>> dataLists) throws ParseException {
        logger.debug(String.format("execute business logical,current table:[%s]", table));
        ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>(16);
        if (WfUtils.isNotEmptyForCollection(dataLists)) {
            for (Map<String, Object> data : dataLists) {
                Long id = (Long)data.get(FID);
                Date createDate = (Date)data.get(FCREATEDATE);
                Date endDate = (Date)data.get(FENDTIME);
                Long procInstId = (Long)data.get(FPROCINSTID);
                Long suspendDuration = RepairRealDurationExecutor.getSuspendDuration(procInstId, id, table);
                Long tempRealDuration = WorkCalendarUtil.getRealDuration((Date)createDate, (Date)endDate);
                Long realDuration = tempRealDuration - suspendDuration <= 0L ? 0L : tempRealDuration - suspendDuration;
                updateParamsList.add(new Object[]{realDuration, id});
            }
            RepairRealDurationExecutor.executeUpdate(updateParamsList, table);
        }
        logger.debug(String.format("repair data size-[%s]", dataLists.size()));
    }

    private static List<Map<String, Object>> getDataList(String tableName, int topNumber, Long fid, Long minFid, Map<String, Object> requireMap) {
        StringBuilder querySql = new StringBuilder("SELECT TOP ");
        querySql.append(topNumber).append(" FID,FCREATEDATE,FENDTIME,FPROCINSTID FROM ").append(tableName);
        querySql.append(" WHERE FENDTIME  IS NOT NULL ");
        if (fid != 0L) {
            querySql.append(" AND FID <= ").append(fid);
        }
        querySql.append(" ORDER BY FID DESC");
        List dataRet = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Object>> dataResult = new ArrayList<Map<String, Object>>(16);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> dataMap = new HashMap<String, Comparable<Long>>(8);
                    dataMap.put(RepairRealDurationExecutor.FID, Long.valueOf(rs.getLong(RepairRealDurationExecutor.FID)));
                    dataMap.put(RepairRealDurationExecutor.FCREATEDATE, rs.getTimestamp(RepairRealDurationExecutor.FCREATEDATE));
                    dataMap.put(RepairRealDurationExecutor.FENDTIME, rs.getTimestamp(RepairRealDurationExecutor.FENDTIME));
                    dataMap.put(RepairRealDurationExecutor.FPROCINSTID, Long.valueOf(rs.getLong(RepairRealDurationExecutor.FPROCINSTID)));
                    dataResult.add(dataMap);
                }
                return dataResult;
            }
        });
        Long currentMinFid = fid;
        if (dataRet.size() > 0) {
            currentMinFid = (Long)((Map)dataRet.get(dataRet.size() - 1)).get(FID);
        }
        RepairRealDurationExecutor.reWriteParam(tableName, currentMinFid, minFid, requireMap);
        return dataRet;
    }

    private static void reWriteParam(String tableName, Long fid, Long minFid, Map<String, Object> requireMap) {
        try {
            Map valueMap = (Map)requireMap.get(tableName);
            if (0L == minFid) {
                valueMap.put(MINFID, RepairRealDurationExecutor.getMinFId(tableName));
            }
            valueMap.put(FID, fid);
            requireMap.put(tableName, valueMap);
            StringBuilder sql = new StringBuilder("update t_wf_repairtask set fparams=").append("'").append(SerializationUtils.toJsonString(requireMap));
            sql.append("'").append(" where fid=").append(TASK_FID);
            DB.execute((DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.debug(String.format("execute update param occurred exception-[%s]", e.getMessage()));
        }
    }

    private static Long getSuspendDuration(Long procInstId, Long taskId, String tableName) {
        boolean exist;
        QFilter q1 = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter q2 = new QFilter("suspendduration", ">", (Object)0);
        QFilter[] qFilters = new QFilter[]{q1, q2};
        if (T_WF_HITASKINST.equalsIgnoreCase(tableName)) {
            QFilter q3 = new QFilter("taskid", "=", (Object)taskId);
            qFilters = new QFilter[]{q3, q1, q2};
        }
        if (!(exist = QueryServiceHelper.exists((String)"wf_durationdetail", (QFilter[])qFilters))) {
            return 0L;
        }
        StringBuilder sql = new StringBuilder("select  fsuspendtime,fundosusptime from  T_WF_DURATIONDETAIL   WHERE FPROCINSTID =").append(procInstId);
        if (T_WF_HITASKINST.equalsIgnoreCase(tableName)) {
            sql.append(" AND  FTASKID=").append(taskId);
        }
        Long suspendDurationInWorkTime = 0L;
        DataSet dataset = DB.queryDataSet((String)WfUtils.createAlgoKey((String)CLASS_NAME), (DBRoute)DBRoute.workflow, (String)sql.toString());
        Iterator iterator = dataset.iterator();
        if (iterator != null && iterator.hasNext()) {
            Row row = (Row)iterator.next();
            long suspendDuration = WorkCalendarUtil.getRealDuration((Date)row.getTimestamp("fsuspendtime"), (Date)row.getTimestamp("fundosusptime"));
            suspendDurationInWorkTime = suspendDuration + suspendDurationInWorkTime;
        }
        return suspendDurationInWorkTime;
    }

    public static Long getMinFId(String tableName) {
        Long result = 0L;
        StringBuilder sql = new StringBuilder(" SELECT TOP 1 FID FROM ");
        sql.append(tableName).append(" WHERE FENDTIME IS NOT NULL ORDER BY FID");
        DataSet dataset = DB.queryDataSet((String)WfUtils.createAlgoKey((String)CLASS_NAME), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[0]);
        Iterator iterator = dataset.iterator();
        if (iterator != null && iterator.hasNext()) {
            Row row = (Row)iterator.next();
            result = (Long)row.get(FID);
        }
        return result;
    }

    private static void executeUpdate(List<Object[]> updateParamsList, String table) {
        if (WfUtils.isNotEmptyForCollection(updateParamsList)) {
            try {
                StringBuilder batchSql = new StringBuilder();
                batchSql.append("UPDATE ").append(table).append(" SET FREALDURATION=?  WHERE FID=? ;");
                WfDBUtils.executeBatch((String)batchSql.toString(), updateParamsList, (Integer)BATCH_NUM);
            }
            catch (Exception e) {
                logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
    }

    private static Map<String, Boolean> isComplete(String tableName, Long currentFid, Long minFid, Map<String, Boolean> resultMap) {
        if (currentFid.longValue() == minFid.longValue()) {
            resultMap.put(tableName, true);
        } else {
            resultMap.put(tableName, false);
        }
        return resultMap;
    }

    private static void deleteConferCenterKeyForAnalysisAlreadyDeal() {
        DeleteServiceHelper.delete((String)"wf_confcenter", (QFilter[])new QFilter[]{new QFilter("key", "in", (Object)new String[]{"workflow.analysis.processAnalysisInit", "workflow.analysis.nodeAnalysisInit", "workflow.analysis.personAnalysisInit"})});
    }
}

