/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.service.exectors.RepairMessageExecutor;
import kd.bos.workflow.support.util.WfSupportUtil;

public class RepairWorkflowRoleExecutor
implements HistoryRepairTaskExecutor {
    private Log logger = LogFactory.getLog(RepairMessageExecutor.class);
    private static final String LASTENTRYID = "lastentryid";
    private static final String ORG = "org";
    private static final String ENTRYID = "entryId";
    private static final String ISADMINORG = "isAdminOrg";
    private static final String WF_CONF_KEY = "workflow.role.isRepairWorkflowRoleIncludeAdminSubComplete";
    private Long entryId = null;

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(2);
        }
        if (require.get(LASTENTRYID) != null) {
            this.entryId = (Long)require.get(LASTENTRYID);
        }
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        for (int i = 0; i < times; ++i) {
            if (!this.repairRoleEntry(limitSize, require)) continue;
            WfSupportUtil.writeWfConfCenterInfo(WF_CONF_KEY, "true", "global", null);
            result.setState(RepairTaskState.FINISHED);
            result.setRequire(require);
            return result;
        }
        result.setRequire(require);
        result.setState(RepairTaskState.RUNNING);
        return result;
    }

    private boolean repairRoleEntry(int limitSize, Map<String, Object> require) {
        DynamicObjectCollection collection = this.getNeedRepairRoleEntry(limitSize, this.entryId);
        HashSet orgIds = new HashSet(collection.size());
        collection.stream().filter(row -> row != null && WfUtils.isNotEmpty((Long)row.getLong(ORG))).forEach(row -> orgIds.add(row.getLong(ORG)));
        HashMap<Long, Boolean> adminOrgMap = new HashMap<Long, Boolean>(orgIds.size());
        if (!orgIds.isEmpty()) {
            DynamicObject[] adminOrgs;
            for (DynamicObject adminOrg : adminOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)ORG, (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)Long.valueOf("01")).and(new QFilter(ORG, "in", orgIds))})) {
                if (!WfUtils.isNotEmpty((Long)adminOrg.getLong("org.id"))) continue;
                adminOrgMap.put(adminOrg.getLong("org.id"), Boolean.TRUE);
            }
        }
        ArrayList paramsList = new ArrayList(collection.size());
        HashMap params = new HashMap(1);
        collection.forEach(row -> {
            ArrayList<Object> tmpParams = new ArrayList<Object>(2);
            tmpParams.add(adminOrgMap.get(row.getLong(ORG)) != null);
            params.put(ISADMINORG, adminOrgMap.get(row.getLong(ORG)) != null);
            tmpParams.add(SerializationUtils.toJsonString((Object)params));
            tmpParams.add(row.getLong(ENTRYID));
            paramsList.add(tmpParams.toArray(new Object[0]));
            params.clear();
        });
        WfDBUtils.executeBatch((String)"update t_wf_roleentry set fincludadminsub = ?, fparam = ? where fentryid = ?", paramsList, (Integer)limitSize);
        if (collection.size() != limitSize) {
            return Boolean.TRUE;
        }
        this.entryId = ((DynamicObject)collection.get(collection.size() - 1)).getLong(ENTRYID);
        require.put(LASTENTRYID, this.entryId);
        return Boolean.FALSE;
    }

    private DynamicObjectCollection getNeedRepairRoleEntry(int limitSize, Long entryId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(limitSize).append(" a.fentryid entryId, a.forg org from t_wf_roleentry a");
        if (WfUtils.isNotEmpty((Long)entryId)) {
            sql.append(" where a.fentryid < ").append(entryId);
        }
        sql.append(" order by a.fentryid desc");
        try (DataSet ds = DB.queryDataSet((String)"RepairWorkflowRoleExecutor", (DBRoute)DBRoute.workflow, (String)sql.toString());){
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }
}

