/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.service.exectors.RepaireHiCommentExecutor;

public class RepaireHiCommentDisplayPropertyExecutor
extends RepaireHiCommentExecutor
implements HistoryRepairTaskExecutor {
    private static final String DISPLAY_LASTDATE = "displayPrpLastDate";
    private static final String FIRSTDATE = "firstdate";
    private static final String FIRSTDATE_VALUE = "2022-05-07 15:55:00";
    private static final int SELECTCOUNT_IN = 300;
    private static final String REPAIREHICOMMENTDISPLAYPROPERTYCOMPLETE = "workflow.hitaskinst.repaireHiCommentDisplayProperty";
    private Log logger = LogFactory.getLog(RepaireHiCommentDisplayPropertyExecutor.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        int times = param.getTimes();
        int limitSize = param.getLimitSize() / 2;
        Map require = Optional.ofNullable(param.getRequire()).orElseGet(HashMap::new);
        if (require.get(FIRSTDATE) == null) {
            require.put(FIRSTDATE, this.getFirstDate());
        }
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        for (int i = 0; i < times; ++i) {
            Boolean b1 = this.repairHicommentDisplayPropDatas(limitSize, require);
            Boolean b2 = this.repairHicommentTable(limitSize, require);
            if (!b1.booleanValue() || !b2.booleanValue()) continue;
            this.updateSingleTableQuery(REPAIREHICOMMENTDISPLAYPROPERTYCOMPLETE);
            result.setState(RepairTaskState.FINISHED);
            result.setRequire(require);
            return result;
        }
        result.setRequire(require);
        result.setState(RepairTaskState.RUNNING);
        return result;
    }

    private Boolean repairHicommentDisplayPropDatas(int limitSize, Map<String, Object> require) {
        ArrayList hiTasks;
        Date firstTime = new Date();
        Date endTime = new Date();
        if (!require.isEmpty() && StringUtils.isNotBlank((Object)require.get(DISPLAY_LASTDATE))) {
            try {
                firstTime = this.format.parse(FIRSTDATE_VALUE);
                endTime = this.format.parse((String)require.get(DISPLAY_LASTDATE));
            }
            catch (Exception e) {
                this.logger.debug("\u65e5\u671f\u683c\u5f0f\u5316\u5831\u932f(\u4e0d\u8981\u624b\u8f38\u597d\u5427\uff0c\u8b93\u7cfb\u7d71\u81ea\u5df1\u5beb\u503c):" + e.getMessage());
            }
        }
        if (endTime.before(firstTime)) {
            return Boolean.TRUE;
        }
        Date startTime = this.getDateBeforeStep(endTime);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List hiComments = wfService.getTaskService().getTaskCommentsBetweenTime(startTime, endTime, "time desc", limitSize, Boolean.FALSE);
        if (!hiComments.isEmpty()) {
            int tag = 0;
            hiTasks = new ArrayList();
            ArrayList<Long> ids = new ArrayList<Long>(300);
            for (int i = 0; i < hiComments.size(); ++i) {
                ids.add(((CommentEntity)hiComments.get(i)).getTaskId());
                if (++tag != 300) continue;
                hiTasks.addAll(wfService.getTaskService().getHistoricTasks(ids));
                tag = 0;
                ids.clear();
            }
            if (!ids.isEmpty()) {
                hiTasks.addAll(wfService.getTaskService().getHistoricTasks(ids));
            }
        } else {
            try {
                Date ff = this.format.parse(FIRSTDATE_VALUE);
                if (ff.before(startTime)) {
                    require.put(DISPLAY_LASTDATE, this.format.format(startTime));
                    return Boolean.FALSE;
                }
            }
            catch (ParseException e) {
                this.logger.debug("first date is null:" + e.getMessage());
            }
            return Boolean.TRUE;
        }
        HashMap hiCommentMap = new HashMap(hiComments.size());
        hiComments.forEach(hiComment -> {
            List list = Optional.ofNullable(hiCommentMap.get(hiComment.getTaskId())).orElseGet(ArrayList::new);
            list.add(hiComment);
            hiCommentMap.put(hiComment.getTaskId(), list);
        });
        hiTasks.forEach(hiTask -> {
            List list = (List)hiCommentMap.get(hiTask.getId());
            list.forEach(hiComment -> {
                hiComment.setHandleState(hiTask.getHandleState());
                hiComment.setExecutionType(hiTask.getExecutionType());
                hiComment.setDisplay(hiTask.isDisplay());
            });
        });
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(hiComments.size());
        this.buildSqlParams(hiComments, paramsList);
        require.put(DISPLAY_LASTDATE, this.format.format(((CommentEntity)hiComments.get(hiComments.size() - 1)).getTime()));
        String hitaskSql = "update t_wf_hicomment set fhandlestate = ?, fexecutiontype = ?, fisdisplay = ? where fid = ?";
        WfDBUtils.executeBatch((String)hitaskSql, paramsList, (Integer)limitSize);
        return Boolean.FALSE;
    }

    @Override
    protected String getFirstDate() {
        return FIRSTDATE_VALUE;
    }

    @Override
    protected List<CommentEntity> getNeedRepairCommentDatas(Date startTime, Date endTime, int limitSize) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService().getCoordinateComments(startTime, endTime, "time desc", limitSize, false);
    }

    private void buildSqlParams(List<CommentEntity> hiComments, List<Object[]> paramsList) {
        hiComments.forEach(hiComment -> {
            ArrayList<Object> tempParamArr = new ArrayList<Object>(4);
            tempParamArr.add(hiComment.getHandleState());
            tempParamArr.add(hiComment.getExecutionType());
            tempParamArr.add(hiComment.isDisplay());
            tempParamArr.add(hiComment.getId());
            paramsList.add(tempParamArr.toArray());
        });
    }
}

