/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class RepaireHiCommentExecutor
implements HistoryRepairTaskExecutor {
    private static final String LASTDATE = "lastdate";
    private static final String FIRSTDATE = "firstdate";
    private static final String FIRSTDATE_VALUE = "2017-01-01 00:00:00";
    private static final int SELECTCOUNT_IN = 300;
    private static final int LIMITDAYS = -10;
    private static final String REPAIREHICOMMENTCOMPLETE = "workflow.hitaskinst.repaireHiCommentComplete";
    private Log logger = LogFactory.getLog(RepaireHiCommentExecutor.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(2);
        }
        if (require.get(FIRSTDATE) == null) {
            require.put(FIRSTDATE, this.getFirstDate());
        }
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        for (int i = 0; i < times; ++i) {
            if (!this.repairHicommentTable(limitSize, require).booleanValue()) continue;
            this.updateSingleTableQuery(REPAIREHICOMMENTCOMPLETE);
            result.setState(RepairTaskState.FINISHED);
            result.setRequire(require);
            return result;
        }
        result.setRequire(require);
        result.setState(RepairTaskState.RUNNING);
        return result;
    }

    protected String getFirstDate() {
        Date date = null;
        QFilter[] timeFilter = new QFilter[]{new QFilter("time", "is not null", null)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)"wf_hicomment", (String)"time", (QFilter[])timeFilter, (String)"id", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                date = ((Row)iterator.next()).getDate("time");
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("HistoryRepairTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (date != null) {
            return this.format.format(date);
        }
        return FIRSTDATE_VALUE;
    }

    protected Boolean repairHicommentTable(int limitSize, Map<String, Object> require) {
        HashMap<Long, ArrayList<CommentEntity>> hiCommentMap;
        ArrayList hiParticipants;
        ArrayList hiTasks;
        Date firstTime = new Date();
        Date endTime = new Date();
        if (require != null && StringUtils.isNotBlank((Object)require.get(LASTDATE))) {
            try {
                firstTime = this.format.parse((String)require.get(FIRSTDATE));
                endTime = this.format.parse((String)require.get(LASTDATE));
            }
            catch (Exception e) {
                this.logger.debug("\u65e5\u671f\u683c\u5f0f\u5316\u5831\u932f(\u4e0d\u8981\u624b\u8f38\u597d\u5427\uff0c\u8b93\u7cfb\u7d71\u81ea\u5df1\u5beb\u503c):" + e.getMessage());
            }
        }
        if (endTime.before(firstTime)) {
            return Boolean.TRUE;
        }
        Date startTime = this.getDateBeforeStep(endTime);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List<CommentEntity> hiComments = this.getNeedRepairCommentDatas(startTime, endTime, limitSize);
        if (!hiComments.isEmpty()) {
            int tag = 0;
            hiTasks = new ArrayList();
            hiParticipants = new ArrayList();
            ArrayList<Long> ids = new ArrayList<Long>(300);
            for (int i = 0; i < hiComments.size(); ++i) {
                ids.add(hiComments.get(i).getTaskId());
                if (++tag != 300) continue;
                hiTasks.addAll(wfService.getTaskService().getHistoricTasks(ids));
                hiParticipants.addAll(wfService.getTaskService().getParticipantInfoByTaskIds(ids));
                tag = 0;
                ids.clear();
            }
            hiTasks.addAll(wfService.getTaskService().getHistoricTasks(ids));
            hiParticipants.addAll(wfService.getTaskService().getParticipantInfoByTaskIds(ids));
            hiCommentMap = new HashMap<Long, ArrayList<CommentEntity>>(hiComments.size());
            for (int i = 0; i < hiComments.size(); ++i) {
                CommentEntity hiComment = hiComments.get(i);
                ArrayList<CommentEntity> list = (ArrayList<CommentEntity>)hiCommentMap.get(hiComment.getTaskId());
                if (list == null) {
                    list = new ArrayList<CommentEntity>();
                }
                list.add(hiComment);
                hiCommentMap.put(hiComment.getTaskId(), list);
                if (i != hiComments.size() - 1 || hiComments.get(i).getTime() == null) continue;
                require.put(LASTDATE, this.format.format(hiComments.get(i).getTime()));
            }
        } else {
            String firstDate = (String)require.get(FIRSTDATE);
            try {
                Date ff = this.format.parse(firstDate);
                if (ff.before(startTime)) {
                    require.put(LASTDATE, this.format.format(startTime));
                    return Boolean.FALSE;
                }
            }
            catch (ParseException e) {
                this.logger.debug("first date is null:" + e.getMessage());
            }
            return Boolean.TRUE;
        }
        hiTasks.forEach(hiTask -> {
            List list = (List)hiCommentMap.get(hiTask.getId());
            list.forEach(hiComment -> {
                hiComment.setBillNo(hiTask.getBillNo());
                hiComment.setEntityName(hiTask.getEntityName());
                hiComment.setSenderNameFormat(WfMultiLangUtils.subString((ILocaleString)hiTask.getSenderNameFormat(), (int)0, (int)255));
                hiComment.setStarterId(hiTask.getStarterId());
                hiComment.setPresentAssignee(WfMultiLangUtils.subString((ILocaleString)hiTask.getPresentAssignee(), (int)0, (int)1000));
                hiComment.setProcessingPage(hiTask.getProcessingPage());
                hiComment.setProcessingMobilePage(hiTask.getProcessingMobilePage());
                hiComment.setHandleState(hiTask.getHandleState());
                hiComment.setCategory(StringUtils.substring((String)hiTask.getCategory(), (int)0, (int)50));
                hiComment.setSenderName(WfMultiLangUtils.subString((ILocaleString)hiTask.getSenderName(), (int)0, (int)400));
                hiComment.setCreateDate(hiTask.getCreateDate());
                hiComment.setExecutionType(hiTask.getExecutionType());
                hiComment.setDisplay(hiTask.isDisplay());
                hiComment.setEndType(hiTask.getEndType());
                hiComment.setBillType(hiTask.getBillType());
                hiComment.setSource(hiTask.getSource());
                hiComment.setSourceName(hiTask.getSourceName());
                hiComment.setStartName(WfMultiLangUtils.subString((ILocaleString)hiTask.getStartName(), (int)0, (int)255));
                hiComment.setStartNameFormat(WfMultiLangUtils.subString((ILocaleString)hiTask.getStartNameFormat(), (int)0, (int)255));
                if (WfUtils.isEmpty((ILocaleString)hiComment.getCurrentSubject())) {
                    hiComment.setCurrentSubject(hiTask.getSubject());
                }
            });
        });
        hiParticipants.forEach(hiParticipant -> {
            List list = (List)hiCommentMap.get(hiParticipant.getTaskId());
            list.forEach(hiComment -> {
                if (hiComment.getUserId() != null && hiComment.getUserId().equals(hiParticipant.getUserId())) {
                    hiComment.setDelegateId(hiParticipant.getDelegateId());
                }
            });
        });
        wfService.getTaskService().updateHicommentsData(hiComments, limitSize);
        return Boolean.FALSE;
    }

    protected List<CommentEntity> getNeedRepairCommentDatas(Date startTime, Date endTime, int limitSize) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService().getTaskCommentsBetweenTime(startTime, endTime, "time desc", limitSize, Boolean.TRUE);
    }

    Date getDateBeforeStep(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -10);
        return cal.getTime();
    }

    protected void updateSingleTableQuery(String key) {
        Object[] params;
        String sql;
        QFilter filter = new QFilter("key", "=", (Object)key);
        QFilter filter2 = new QFilter("type", "=", (Object)"global");
        DynamicObject obj = QueryServiceHelper.queryOne((String)"wf_confcenter", (String)"id, value", (QFilter[])new QFilter[]{filter, filter2});
        if (obj != null) {
            sql = "update t_wf_confcenter set fvalue = 'true' where fid = ?";
            Long id = obj.getLong("id");
            params = new Object[]{id};
        } else {
            sql = "insert into t_wf_confcenter (fid, ftype, fkey, fvalue) values (?, 'global', ?, 'true')";
            Long id = DBServiceHelper.genGlobalLongId();
            params = new Object[]{id, key};
        }
        DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])params);
    }
}

