/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class RepaireIdentityLinkExecutor
implements HistoryRepairTaskExecutor {
    private Log logger = LogFactory.getLog(RepaireIdentityLinkExecutor.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String FIRSTDATE_VALUE = "2017-01-01 00:00:00";
    private static final String LASTDATE = "lastdate";
    private static final String FIRSTDATE = "firstdate";
    private static final int SELECTCOUNT_IN = 300;
    private static final int LIMITDAYS = -3;
    private static final String REPAIREIDENTITYLINKCOMPLETE = "workflow.taskentity.repaireIdentityLinkComplete";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(2);
        }
        if (require.get(FIRSTDATE) == null) {
            require.put(FIRSTDATE, this.getFirstDate());
        }
        Map<String, String> extendBusinessField = this.getBusinessField("wf_task");
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        try {
            for (int i = 1; i <= times; ++i) {
                if (!this.repairIdentitylinkTable(limitSize, require, extendBusinessField).booleanValue()) continue;
                this.updateSingleTableQuery(REPAIREIDENTITYLINKCOMPLETE);
                result.setState(RepairTaskState.FINISHED);
                result.setRequire(require);
                return result;
            }
            result.setRequire(require);
            result.setState(RepairTaskState.RUNNING);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getBusinessField(String scope) {
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)scope);
        Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
        dataEntityType.getAllFields().entrySet().forEach(entry -> {
            if (allowExtendTaskFields.booleanValue() && TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)((IDataEntityProperty)entry.getValue()))) {
                if (StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)entry.getValue()).getTableGroup())) {
                    fieldMap.put((String)entry.getKey(), ((IDataEntityProperty)entry.getValue()).getTableGroup() + "." + ((IDataEntityProperty)entry.getValue()).getAlias());
                } else {
                    fieldMap.put((String)entry.getKey(), ((IDataEntityProperty)entry.getValue()).getAlias());
                }
            }
        });
        return fieldMap;
    }

    protected Boolean repairIdentitylinkTable(int limitSize, Map<String, Object> require, Map<String, String> extendBusinessField) {
        HashMap extendBusinessValue;
        Date firstTime = new Date();
        Date endTime = new Date();
        if (require != null && StringUtils.isNotBlank((Object)require.get(LASTDATE))) {
            try {
                firstTime = this.format.parse((String)require.get(FIRSTDATE));
                endTime = this.format.parse((String)require.get(LASTDATE));
            }
            catch (Exception e) {
                this.logger.debug("\u65e5\u671f\u683c\u5f0f\u5316\u5831\u932f(\u4e0d\u8981\u624b\u8f38\u597d\u5427\uff0c\u8b93\u7cfb\u7d71\u81ea\u5df1\u5beb\u503c):" + e.getMessage());
            }
        }
        if (endTime.before(firstTime)) {
            return Boolean.TRUE;
        }
        Date startTime = this.getDateBeforeStep(endTime);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List identityLinkEntities = wfService.getTaskService().getTaskIdentityLinkEntityBetweenTime(startTime, endTime, "createdate desc", limitSize);
        ArrayList taskEntities = new ArrayList();
        if (identityLinkEntities != null && identityLinkEntities.size() > 0) {
            int tag = 0;
            HashSet<Long> ids = new HashSet<Long>(300);
            for (int i = 0; i < identityLinkEntities.size(); ++i) {
                ids.add(((IdentityLinkEntity)identityLinkEntities.get(i)).getTaskId());
                if (++tag != 300) continue;
                taskEntities.addAll(wfService.getTaskService().findTasksByFilter(new QFilter[]{new QFilter("id", "in", ids)}));
                tag = 0;
                ids.clear();
            }
            if (ids.size() > 0) {
                taskEntities.addAll(wfService.getTaskService().findTasksByFilter(new QFilter[]{new QFilter("id", "in", ids)}));
            }
            HashMap<Long, TaskEntity> taskMap = new HashMap<Long, TaskEntity>(taskEntities.size());
            for (TaskEntity taskEntity : taskEntities) {
                taskMap.put(taskEntity.getId(), taskEntity);
            }
            extendBusinessValue = new HashMap(taskEntities.size());
            if (taskEntities.size() == 0 && identityLinkEntities.size() < limitSize) {
                require.put(LASTDATE, this.format.format(startTime));
            } else {
                require.put(LASTDATE, this.format.format(((IdentityLinkEntity)identityLinkEntities.get(identityLinkEntities.size() - 1)).getCreateDate()));
            }
            for (int i = 0; i < identityLinkEntities.size(); ++i) {
                IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)identityLinkEntities.get(i);
                TaskEntity taskEntity = (TaskEntity)taskMap.get(identityLinkEntity.getTaskId());
                if (taskEntity == null) continue;
                this.setTaskPropertityToParticipant(taskEntity, identityLinkEntity);
                ArrayList<Object> value = new ArrayList<Object>();
                DynamicObject object = taskEntity.getDynamicObject();
                for (Map.Entry<String, String> entry : extendBusinessField.entrySet()) {
                    value.add(object.get(entry.getKey()));
                }
                if (value.size() <= 0) continue;
                extendBusinessValue.put(identityLinkEntity.getId(), value);
            }
        } else {
            String firstDate = (String)require.get(FIRSTDATE);
            try {
                Date ff = this.format.parse(firstDate);
                if (ff.before(startTime)) {
                    require.put(LASTDATE, this.format.format(startTime));
                    return Boolean.FALSE;
                }
            }
            catch (ParseException e) {
                this.logger.debug("first date is null:" + e.getMessage());
            }
            return Boolean.TRUE;
        }
        wfService.getTaskService().updateIdentityLinkEntityData(identityLinkEntities, limitSize, extendBusinessField, extendBusinessValue);
        return Boolean.FALSE;
    }

    private void setTaskState(IdentityLinkEntity entity, TaskEntity taskEntity) {
        String taskState = taskEntity.getHandleState();
        if (!taskEntity.isActive()) {
            taskState = "freeze";
        }
        if (!ManagementConstants.ACTIVE.getStateCode().equals(taskEntity.getSuspensionState())) {
            taskState = "manualSuspended";
        }
        entity.setTaskState(taskState);
    }

    private void setTaskPropertityToParticipant(TaskEntity taskEntity, IdentityLinkEntity entity) {
        entity.setName(taskEntity.getName());
        entity.setTaskDisplay(Boolean.valueOf(taskEntity.isDisplay()));
        entity.setExecutionId(taskEntity.getExecutionId());
        entity.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        entity.setMobileFormKey(taskEntity.getMobileFormKey());
        entity.setCategory(taskEntity.getCategory());
        entity.setEntityNumber(taskEntity.getEntityNumber());
        entity.setEntityName(taskEntity.getEntityName());
        entity.setBusinessKey(taskEntity.getBusinessKey());
        entity.setProcessingMobilePage(taskEntity.getProcessingMobilePage());
        entity.setProcessingPage(taskEntity.getProcessingPage());
        entity.setSenderId(taskEntity.getSenderId());
        entity.setSenderName(taskEntity.getSenderName());
        entity.setStartName(taskEntity.getStartName());
        entity.setSenderNameFormat(taskEntity.getSenderNameFormat());
        entity.setStartNameFormat(taskEntity.getStartNameFormat());
        this.setTaskState(entity, taskEntity);
        entity.setBillNo(taskEntity.getBillNo());
        entity.setStarterId(taskEntity.getStarterId());
        entity.setEndType(taskEntity.getEndType());
        entity.setParticipantName(taskEntity.getParticipantName());
        entity.setGroupNumber(taskEntity.getGroupNumber());
        entity.setBillType(taskEntity.getBillType());
        entity.setBizTraceNo(taskEntity.getBizTraceNo());
        entity.setProcessType(taskEntity.getProcessType());
        entity.setBusinessDate(taskEntity.getBusinessDate());
        entity.setBusinessNumber(taskEntity.getBusinessNumber());
        entity.setBusinessFormat(taskEntity.getBusinessFormat());
        entity.setBusinessStr1(taskEntity.getBusinessStr1());
        entity.setBusinessStr2(taskEntity.getBusinessStr2());
        entity.setBusinessDate2(taskEntity.getBusinessDate2());
        entity.setBusinessNumber2(taskEntity.getBusinessNumber2());
        entity.setBusinessMulStr1(taskEntity.getBusinessMulStr1());
        entity.setBusinessMulStr2(taskEntity.getBusinessMulStr2());
        if (WfUtils.isEmpty((ILocaleString)entity.getCurrentSubject())) {
            entity.setCurrentSubject(taskEntity.getSubject());
        }
        entity.setBizType(taskEntity.getYzjGroupId());
        entity.setSource(taskEntity.getSource());
        entity.setSourceName(taskEntity.getSourceName());
    }

    Date getDateBeforeStep(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -3);
        return cal.getTime();
    }

    protected String getFirstDate() {
        Date date = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_createdate", (String)"wf_participant", (String)"createdate", null, (String)"id", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                date = ((Row)iterator.next()).getDate("createdate");
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("HistoryRepairTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (date != null) {
            return this.format.format(date);
        }
        return FIRSTDATE_VALUE;
    }

    protected void updateSingleTableQuery(String key) {
        Object[] params;
        String sql;
        QFilter filter = new QFilter("key", "=", (Object)key);
        QFilter filter2 = new QFilter("type", "=", (Object)"global");
        DynamicObject obj = QueryServiceHelper.queryOne((String)"wf_confcenter", (String)"id, value", (QFilter[])new QFilter[]{filter, filter2});
        if (obj != null) {
            sql = "update t_wf_confcenter set fvalue = 'true' where fid = ?";
            Long id = obj.getLong("id");
            params = new Object[]{id};
        } else {
            sql = "insert into t_wf_confcenter (fid, ftype, fkey, fvalue) values (?, 'global', ?, 'true')";
            Long id = DBServiceHelper.genGlobalLongId();
            params = new Object[]{id, key};
        }
        DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])params);
    }
}

