/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.service.exectors.RepaireIdentityLinkExecutor;

public class RepaireTaskHandleLogExecutor
implements HistoryRepairTaskExecutor {
    private Log logger = LogFactory.getLog(RepaireIdentityLinkExecutor.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String FIRSTDATE_VALUE = "2017-01-01 00:00:00";
    private static final String LASTDATE = "lastdate";
    private static final String FIRSTDATE = "firstdate";
    private static final int SELECTCOUNT_IN = 300;
    private static final int LIMITDAYS = -10;
    private static final String REPAIRETASKHANDLELOGCOMPLETE = "workflow.taskentity.repaireTaskHandleLogComplete";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(2);
        }
        if (require.get(FIRSTDATE) == null) {
            require.put(FIRSTDATE, this.getFirstDate());
        }
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        try {
            for (int i = 1; i <= times; ++i) {
                if (!this.repairTaskHandleLogTable(limitSize, require).booleanValue()) continue;
                this.updateSingleTableQuery(REPAIRETASKHANDLELOGCOMPLETE);
                result.setState(RepairTaskState.FINISHED);
                result.setRequire(require);
                return result;
            }
            result.setRequire(require);
            result.setState(RepairTaskState.RUNNING);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Boolean repairTaskHandleLogTable(int limitSize, Map<String, Object> require) {
        HashMap<Long, HistoricTaskInstanceEntity> historicTaskMap;
        HashMap<Long, DynamicObject> taskEntityMap;
        Date firstTime = new Date();
        Date endTime = new Date();
        if (require != null && StringUtils.isNotBlank((Object)require.get(LASTDATE))) {
            try {
                firstTime = this.format.parse((String)require.get(FIRSTDATE));
                endTime = this.format.parse((String)require.get(LASTDATE));
            }
            catch (Exception e) {
                this.logger.debug("\u65e5\u671f\u683c\u5f0f\u5316\u5831\u932f(\u4e0d\u8981\u624b\u8f38\u597d\u5427\uff0c\u8b93\u7cfb\u7d71\u81ea\u5df1\u5beb\u503c):" + e.getMessage());
            }
        }
        if (endTime.before(firstTime)) {
            return Boolean.TRUE;
        }
        Date startTime = this.getDateBeforeStep(endTime);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List taskHandleLogEntities = wfService.getTaskService().getTaskHandleLogBetweenTime(startTime, endTime, "createdate desc", limitSize);
        ArrayList<DynamicObjectCollection> taskEntities = new ArrayList<DynamicObjectCollection>();
        ArrayList hisTaskEntities = new ArrayList();
        ArrayList identityLinkEntities = new ArrayList();
        HashSet<Long> userIds = new HashSet<Long>(300);
        if (taskHandleLogEntities != null && taskHandleLogEntities.size() > 0) {
            void var16_25;
            int tag = 0;
            HashSet<Long> ids = new HashSet<Long>(300);
            for (int i = 0; i < taskHandleLogEntities.size(); ++i) {
                ids.add(((TaskHandleLogEntity)taskHandleLogEntities.get(i)).getTaskId());
                userIds.add(((TaskHandleLogEntity)taskHandleLogEntities.get(i)).getOwnerId());
                if (++tag != 300) continue;
                DynamicObjectCollection tasks = QueryServiceHelper.query((String)"wf_task", (String)"id,display,handlestate,active,suspensionState,source,yzjgroupid,groupnumber,biztraceno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (tasks != null) {
                    taskEntities.add(tasks);
                }
                hisTaskEntities.addAll(wfService.getTaskService().getHistoricTasks(new ArrayList(ids)));
                tag = 0;
                ids.clear();
            }
            if (ids.size() > 0) {
                DynamicObjectCollection tasks = QueryServiceHelper.query((String)"wf_task", (String)"id,display,handlestate,active,suspensionState,source,yzjgroupid,groupnumber,biztraceno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (tasks != null) {
                    taskEntities.add(tasks);
                }
                hisTaskEntities.addAll(wfService.getTaskService().getHistoricTasks(new ArrayList(ids)));
            }
            taskEntityMap = new HashMap<Long, DynamicObject>(taskEntities.size());
            for (DynamicObjectCollection dynamicObjectCollection : taskEntities) {
                for (DynamicObject taskEntity : dynamicObjectCollection) {
                    taskEntityMap.put(taskEntity.getLong("id"), taskEntity);
                }
            }
            historicTaskMap = new HashMap<Long, HistoricTaskInstanceEntity>(hisTaskEntities.size());
            for (HistoricTaskInstanceEntity hiTaskEntity : hisTaskEntities) {
                historicTaskMap.put(hiTaskEntity.getId(), hiTaskEntity);
            }
            boolean bl = false;
            while (var16_25 < taskHandleLogEntities.size()) {
                DynamicObject taskEntity;
                TaskHandleLogEntity taskHandleLogEntity = (TaskHandleLogEntity)taskHandleLogEntities.get((int)var16_25);
                taskEntity = (DynamicObject)taskEntityMap.get(taskHandleLogEntity.getTaskId());
                HistoricTaskInstanceEntity hisTaskEntity = (HistoricTaskInstanceEntity)historicTaskMap.get(taskHandleLogEntity.getTaskId());
                if (hisTaskEntity != null) {
                    taskHandleLogEntity.setEndTime(hisTaskEntity.getEndTime());
                    taskHandleLogEntity.setPresentAssignee(hisTaskEntity.getPresentAssignee());
                    taskHandleLogEntity.setExecutionType(hisTaskEntity.getExecutionType());
                    taskHandleLogEntity.setEntityName(hisTaskEntity.getEntityName());
                    taskHandleLogEntity.setStartName(hisTaskEntity.getStartName());
                    taskHandleLogEntity.setStartNameFormat(hisTaskEntity.getStartNameFormat());
                    taskHandleLogEntity.setDisplay(Boolean.valueOf(hisTaskEntity.isDisplay()));
                    taskHandleLogEntity.setEndType(hisTaskEntity.getEndType());
                    taskHandleLogEntity.setProcessType(hisTaskEntity.getProcessType());
                    taskHandleLogEntity.setSenderNameFormat(hisTaskEntity.getSenderNameFormat());
                    taskHandleLogEntity.setSenderName(hisTaskEntity.getSenderName());
                    taskHandleLogEntity.setBizTraceNo(hisTaskEntity.getBizTraceNo());
                    taskHandleLogEntity.setGroupNumber(hisTaskEntity.getGroupNumber());
                    this.setTaskState(taskHandleLogEntity, hisTaskEntity.getHandleState(), hisTaskEntity.isActive(), hisTaskEntity.getSuspensionState());
                }
                if (taskEntity != null) {
                    taskHandleLogEntity.setDisplay(Boolean.valueOf(taskEntity.getBoolean("display")));
                    this.setTaskState(taskHandleLogEntity, taskEntity.getString("handlestate"), taskEntity.getBoolean("active"), taskEntity.getString("suspensionState"));
                    taskHandleLogEntity.setBizType(taskEntity.getString("yzjgroupid"));
                    taskHandleLogEntity.setSource(taskEntity.getString("source"));
                    taskHandleLogEntity.setSourceName(taskEntity.getLocaleString("sourcename"));
                    taskHandleLogEntity.setBizTraceNo(taskEntity.getString("biztraceno"));
                    taskHandleLogEntity.setGroupNumber(this.getGroupNumber(taskEntity));
                }
                if (hisTaskEntity == null && taskEntity == null) {
                    taskHandleLogEntity.setDisplay(Boolean.valueOf(false));
                }
                if (var16_25 == taskHandleLogEntities.size() - 1) {
                    require.put(LASTDATE, this.format.format(taskHandleLogEntity.getCreateDate()));
                }
                ++var16_25;
            }
        } else {
            String firstDate = (String)require.get(FIRSTDATE);
            try {
                Date ff = this.format.parse(firstDate);
                if (ff.before(startTime)) {
                    require.put(LASTDATE, this.format.format(startTime));
                    return Boolean.FALSE;
                }
            }
            catch (ParseException e) {
                this.logger.debug("first date is null:" + e.getMessage());
            }
            return Boolean.TRUE;
        }
        wfService.getTaskService().updateTaskHandleLogEntityData(taskHandleLogEntities, limitSize);
        taskHandleLogEntities.clear();
        historicTaskMap.clear();
        taskEntityMap.clear();
        taskEntities.clear();
        hisTaskEntities.clear();
        identityLinkEntities.clear();
        return Boolean.FALSE;
    }

    private Long getGroupNumber(DynamicObject task) {
        Object groupNumber = task.get("groupnumber");
        if (groupNumber instanceof DynamicObject) {
            return ((DynamicObject)groupNumber).getLong("id");
        }
        return task.getLong("groupnumber");
    }

    private void setTaskState(TaskHandleLogEntity taskHandleLogEntity, String handleState, boolean active, String suspensionstate) {
        String taskState = handleState;
        if (!active) {
            taskState = "freeze";
        }
        if (!ManagementConstants.ACTIVE.getStateCode().equals(suspensionstate)) {
            taskState = "manualSuspended";
        }
        taskHandleLogEntity.setTaskState(taskState);
    }

    Date getDateBeforeStep(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -10);
        return cal.getTime();
    }

    protected String getFirstDate() {
        Date date = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_createdate", (String)"wf_taskhandlelog", (String)"createdate", null, (String)"id", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                date = ((Row)iterator.next()).getDate("createdate");
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("HistoryRepairTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (date != null) {
            return this.format.format(date);
        }
        return FIRSTDATE_VALUE;
    }

    protected void updateSingleTableQuery(String key) {
        Object[] params;
        String sql;
        QFilter filter = new QFilter("key", "=", (Object)key);
        QFilter filter2 = new QFilter("type", "=", (Object)"global");
        DynamicObject obj = QueryServiceHelper.queryOne((String)"wf_confcenter", (String)"id, value", (QFilter[])new QFilter[]{filter, filter2});
        if (obj != null) {
            sql = "update t_wf_confcenter set fvalue = 'true' where fid = ?";
            Long id = obj.getLong("id");
            params = new Object[]{id};
        } else {
            sql = "insert into t_wf_confcenter (fid, ftype, fkey, fvalue) values (?, 'global', ?, 'true')";
            Long id = DBServiceHelper.genGlobalLongId();
            params = new Object[]{id, key};
        }
        DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])params);
    }
}

