/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;
import kd.bos.workflow.support.service.exectors.RepaireIdentityLinkExecutor;

public class RepaireUserTaskDisplayExecutor
implements HistoryRepairTaskExecutor {
    private Log logger = LogFactory.getLog(RepaireIdentityLinkExecutor.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String FIRSTDATE_VALUE = "2023-01-01 00:00:00";
    private static final String LASTDATE = "lastdate";
    private static final String FIRSTDATE = "firstdate";
    private static final int SELECTCOUNT_IN = 300;
    private static final int LIMITDAYS = -10;
    private static final int SAVECOUNT = 500;
    private static final String APPID = "L+YYPU4WNDE";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) throws Exception {
        int times = param.getTimes();
        int limitSize = param.getLimitSize();
        Map<String, Object> require = param.getRequire();
        if (require == null) {
            require = new HashMap<String, Object>(2);
        }
        if (require.get(FIRSTDATE) == null || require.get(LASTDATE) == null) {
            require.put(FIRSTDATE, this.getFirstDate());
            require.put(LASTDATE, this.format.format(new Date()));
        }
        boolean display = this.getDisplay();
        HistoryRepairTaskResult result = new HistoryRepairTaskResult();
        try {
            for (int i = 1; i <= times; ++i) {
                if (!this.repairHistoricTaskTable(limitSize, require, display).booleanValue()) continue;
                result.setState(RepairTaskState.FINISHED);
                result.setRequire(new HashMap<String, Object>());
                return result;
            }
            result.setRequire(require);
            result.setState(RepairTaskState.RUNNING);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean repairHistoricTaskTable(int limitSize, Map<String, Object> require, boolean display) {
        Iterator iterator;
        ArrayList<Object> taskIds;
        ArrayList<Object> ids;
        int tag;
        block29: {
            Date firstTime = null;
            Date endTime = null;
            if (require != null) {
                try {
                    endTime = this.format.parse((String)require.get(LASTDATE));
                    firstTime = this.format.parse((String)require.get(FIRSTDATE));
                }
                catch (Exception e) {
                    this.logger.debug("\u65e5\u671f\u683c\u5f0f\u5316\u5831\u932f(\u4e0d\u8981\u624b\u8f38\u597d\u5427\uff0c\u8b93\u7cfb\u7d71\u81ea\u5df1\u5beb\u503c):" + e.getMessage());
                }
            }
            if (endTime != null && endTime.before(firstTime)) {
                return Boolean.TRUE;
            }
            Date startTime = this.getDateBeforeStep(endTime);
            QFilter q1 = new QFilter("step", "=", (Object)10);
            QFilter q2 = new QFilter("handlestate", "=", (Object)"handled");
            QFilter q3 = new QFilter("category", "=", (Object)"UserTask");
            QFilter q4 = new QFilter("createdate", "<", (Object)endTime);
            QFilter q5 = new QFilter("createdate", ">=", (Object)startTime);
            QFilter q6 = new QFilter("taskid", "!=", (Object)0L);
            QFilter q7 = new QFilter("display", "=", (Object)(!display ? 1 : 0));
            QFilter[] timeFilter = new QFilter[]{q4, q5, q1, q2, q3, q6, q7};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)"wf_hicomment", (String)"id,taskid,createdate", (QFilter[])timeFilter, (String)"createdate desc", (int)limitSize);){
                if (dataSet.isEmpty()) {
                    String firstDate = (String)require.get(FIRSTDATE);
                    try {
                        Date ff = this.format.parse(firstDate);
                        if (ff.before(startTime)) {
                            require.put(LASTDATE, this.format.format(startTime));
                            Boolean bl = Boolean.FALSE;
                            return bl;
                        }
                    }
                    catch (ParseException e) {
                        this.logger.debug("first date is null:" + e.getMessage());
                    }
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                tag = 0;
                ids = new ArrayList<Object>();
                taskIds = new ArrayList<Object>();
                iterator = dataSet.iterator();
                break block29;
            }
            catch (Exception e) {
                this.logger.debug("RepaireUserTaskDisplayExecutor--repairtaskData is error: " + WfUtils.getExceptionStacktrace((Throwable)e));
            }
            return Boolean.FALSE;
        }
        while (iterator.hasNext()) {
            boolean isEnd;
            Row row = (Row)iterator.next();
            Long id = row.getLong("id");
            Long taskId = row.getLong("taskid");
            Date createDate = row.getDate("createdate");
            ids.add(id);
            taskIds.add(taskId);
            boolean bl = isEnd = !iterator.hasNext();
            if (++tag % 500 == 0 || isEnd) {
                this.batchUpdateDisplay(display, ids, taskIds);
                ids.clear();
                taskIds.clear();
            }
            if (createDate == null || !isEnd) continue;
            String thisDate = this.format.format(createDate);
            require.put(LASTDATE, thisDate);
        }
        return Boolean.FALSE;
    }

    private boolean getDisplay() {
        boolean display = true;
        try {
            AppParam param = new AppParam();
            param.setAppId(APPID);
            param.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
            param.setViewType("01");
            Object showsubmitlog = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"showsubmitlog");
            if (StringUtils.isNotBlank((Object)showsubmitlog)) {
                display = (Boolean)showsubmitlog;
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("MessageSystemParamterUtils-%1$s-%2$s", "showSubmitLog", e.getMessage()));
        }
        return display;
    }

    private void batchUpdateDisplay(boolean display, List<Object> identityLinkParamsList, List<Object> taskParamsList) {
        if (identityLinkParamsList.size() > 0) {
            String identityLinkSql = String.format("update t_wf_hicomment set fisdisplay= %s  where fid in ( ? ) ", display ? 1 : 0);
            WfDBUtils.executeBatchDeleteByIn((String)identityLinkSql, identityLinkParamsList, (Integer)500, (boolean)true);
            String hitaskinstSql = String.format("update t_wf_hitaskinst set fisdisplay= %s  where fid in ( ? ) ", display ? 1 : 0);
            WfDBUtils.executeBatchDeleteByIn((String)hitaskinstSql, taskParamsList, (Integer)500, (boolean)true);
        }
    }

    private String getFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, -1);
        return this.format.format(cal.getTime());
    }

    Date getDateBeforeStep(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -10);
        return cal.getTime();
    }
}

