/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.service.exectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.service.HistoryRepairTaskExecutor;

public class RtrelationRepairTaskExecutor
implements HistoryRepairTaskExecutor {
    private static Log logger = LogFactory.getLog(RtrelationRepairTaskExecutor.class);
    private static final String ID = "id";
    private static final String ENDID = "endID";
    private static final String STEPID = "stepId";
    private static final String TASKID = "taskid";
    private static final String ISFINISH = "isFinish";
    private static final String PROCINSTID = "processinstanceid";
    private static final String ENTITY_HITASK = "wf_hitaskinst";
    private static final String ENTITY_RULETASKRELATION = "wf_ruletaskrelation";

    @Override
    public HistoryRepairTaskResult execute(HistoryRepairTaskParam param) {
        HistoryRepairTaskResult repairTaskResult = new HistoryRepairTaskResult();
        int limitSize = param.getLimitSize();
        int times = param.getTimes();
        Map<String, Object> require = param.getRequire();
        Long stepId = null;
        Long endId = null;
        if (require != null && !require.isEmpty()) {
            if (require.get(STEPID) != null) {
                stepId = (Long)require.get(STEPID);
            }
            endId = require.get(ENDID) != null ? (Long)require.get(ENDID) : this.getRtrelationDataEndId();
        } else {
            endId = this.getRtrelationDataEndId();
        }
        logger.debug(String.format("HistoryRepairTaskResult and stepId[%s], endId[%s]", stepId, endId));
        if (endId == null) {
            repairTaskResult.setState(RepairTaskState.FINISHED);
            return repairTaskResult;
        }
        boolean isFinish = Boolean.FALSE;
        Map<String, Object> repairResult = null;
        for (int i = 0; i < times; ++i) {
            repairResult = this.correctRuleTaskRelationData(limitSize, stepId, endId);
            if (repairResult == null) continue;
            stepId = (Long)repairResult.get(STEPID);
            isFinish = (Boolean)repairResult.get(ISFINISH);
            if (isFinish) break;
        }
        if (isFinish) {
            repairTaskResult.setState(RepairTaskState.FINISHED);
        } else {
            repairTaskResult.setState(RepairTaskState.RUNNING);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STEPID, stepId);
        map.put(ENDID, endId);
        logger.debug(String.format("HistoryRepairTaskResult and map[%s]", ((Object)map).toString()));
        repairTaskResult.setRequire(map);
        return repairTaskResult;
    }

    private Map<String, Object> correctRuleTaskRelationData(int limitSize, Long stepId, Long endId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        logger.debug(String.format("HistoryRepairTaskResult and stepId[%s]", stepId));
        HashSet<Long> taskIds = new HashSet<Long>();
        Long id = null;
        QFilter f1 = new QFilter(PROCINSTID, "=", (Object)0L);
        if (stepId != null) {
            QFilter f2 = new QFilter(ID, ">", (Object)stepId);
            f1.and(f2);
        }
        String selectProperties = "id, taskid, processinstanceid";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"entity_rtrelationquery", (String)ENTITY_RULETASKRELATION, (String)selectProperties, (QFilter[])new QFilter[]{f1}, (String)"id asc", (int)limitSize);){
            for (Row row : dataSet) {
                Long taskId = row.getLong(TASKID);
                if (!WfUtils.isNotEmpty((Long)taskId)) continue;
                taskIds.add(taskId);
                id = row.getLong(ID);
            }
        }
        catch (Exception e) {
            logger.debug("HistoryRepairTaskResult--queryData isError " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (id != null && endId <= id) {
            data.put(ISFINISH, Boolean.TRUE);
        } else {
            data.put(ISFINISH, Boolean.FALSE);
        }
        ArrayList<Long[]> paramsList = new ArrayList<Long[]>();
        QFilter[] taskFilters = new QFilter[]{new QFilter(ID, "in", taskIds)};
        try (DataSet taskDataSet = QueryServiceHelper.queryDataSet((String)"entity_queryHitask", (String)ENTITY_HITASK, (String)"id,processinstanceid", (QFilter[])taskFilters, null);){
            for (Row taskRow : taskDataSet) {
                Long[] param = new Long[]{taskRow.getLong(PROCINSTID), taskRow.getLong(ID)};
                paramsList.add(param);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("HistoryRepairTaskResult--queryData isError %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        data.put(STEPID, id);
        if (paramsList.isEmpty()) {
            return data;
        }
        logger.debug("HistoryRepairTaskResult and repair rtrelation");
        try {
            String updateSql = "update t_wf_rtrelation set fprocinstid = ? where ftaskid = ?;";
            WfUtils.executeBatch((String)updateSql, paramsList, (Integer)500);
        }
        catch (Exception e) {
            logger.debug(String.format("HistoryRepairTaskResult--updateHiparticipantDataIsError and info:%s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return data;
    }

    private Long getRtrelationDataEndId() {
        Long id = null;
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)0L)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_indataenddate", (String)ENTITY_RULETASKRELATION, (String)ID, (QFilter[])filters, (String)"id desc", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                id = ((Row)iterator.next()).getLong(ID);
            }
        }
        catch (Exception e) {
            logger.debug("HistoryRepairTaskResult--queryData isError " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return id;
    }
}

