/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.task;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.support.util.WfSupportUtil;

public class AutoRetryCustomTask
extends AbstractTask {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final Integer MAXDELNUM = 100;
    private static final String ERRORTYPE = "business";
    private static final String ERRORCODE = "bos.wf.biz.businessBizOperationError";
    private static final String LASTJOBID = "wf.autoRetryCustomTask.lastJobId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        Integer maxDelNum = MAXDELNUM;
        if (param.get("maxDelNum") != null) {
            maxDelNum = Integer.parseInt((String)param.get("maxDelNum"));
        }
        this.log.debug("AutoRetryCustomTask maxDelNum is :" + maxDelNum);
        String errorType = ERRORTYPE;
        if (param.get("errorType") != null) {
            errorType = (String)param.get("errorType");
        }
        this.log.debug("AutoRetryCustomTask errorType is :" + errorType);
        String errorCode = ERRORCODE;
        if (param.get("errorCode") != null) {
            errorCode = (String)param.get("errorCode");
        }
        this.log.debug("AutoRetryCustomTask errorCode is :" + errorCode);
        String[] exceptionMsgParams = new String[]{ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a", (String)"AutoRetryCustomTask_1", (String)"bos-wf-unittest", (Object[])new Object[0])};
        if (param.get("exceptionMsg") != null) {
            String exceptionMsgParam = (String)param.get("exceptionMsg");
            exceptionMsgParams = exceptionMsgParam.split("\\$");
        }
        this.log.debug("AutoRetryCustomTask exceptionMsg is :" + exceptionMsgParams);
        Long jobId = 0L;
        Object configCenterVal = WfConfigurationUtil.getConfigCenterVal((String)LASTJOBID);
        if (configCenterVal != null) {
            jobId = Long.parseLong((String)configCenterVal);
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        try (DataSet ds = null;){
            QFilter q1 = new QFilter("id", ">", (Object)jobId);
            QFilter q2 = new QFilter("errortype", "=", (Object)errorType);
            QFilter q3 = new QFilter("errorcode", "=", (Object)errorCode);
            ds = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)"wf_deadletterjob", (String)"id,exceptionmessage", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"id", (int)maxDelNum);
            if (!ds.isEmpty()) {
                Iterator iterator = ds.iterator();
                Long lastJobId = 0L;
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    lastJobId = row.getLong("id");
                    String exceptionMsg = row.getString("exceptionmessage");
                    boolean found = Arrays.stream(exceptionMsgParams).anyMatch(s -> exceptionMsg.contains((CharSequence)s));
                    if (!found) continue;
                    wfService.getManagementService().revokeSuspendProcessInstancesByIds(row.getLong("id"), null);
                }
                WfSupportUtil.updateWfConfCenterInfo("global", LASTJOBID, String.valueOf(lastJobId), "autoRetryCustomTask");
            }
        }
    }

    private String createAlgoKey() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(((Object)((Object)this)).getClass().getName()).append(".").append(methodName).toString();
    }
}

