/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;

public class DeleteDirtyExecutionTask
extends AbstractTask {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String DELETECOUNT = "count";
    private static final String PROCDEFIDS = "procDefIds";
    private static final String PROCINSTANCEIDS = "procInstanceIds";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int count = this.getEveryDeleteData(map);
        String procdefs = this.getDeleteProcdefs(map);
        String procInstanceIds = this.getDeleteProcInstanceIds(map);
        if (WfUtils.isEmpty((String)procdefs) && WfUtils.isEmpty((String)procInstanceIds)) {
            this.log.debug("procdefs & procInstanceIds is empty.");
            return;
        }
        Set<Long> finishedProcInstIds = this.findFinishedProcInstIds(procdefs, procInstanceIds, count);
        if (WfUtils.isEmptyForCollection(finishedProcInstIds)) {
            this.log.debug("finishedProcInstIds is empty.");
            return;
        }
        this.filterFinishedProcInstIds(finishedProcInstIds);
        if (WfUtils.isEmptyForCollection(finishedProcInstIds)) {
            this.log.debug("after filter,finishedProcInstIds is empty.");
            return;
        }
        List<Object> dirtyExecutions = this.findDirtyExecutions(finishedProcInstIds);
        if (WfUtils.isEmptyForCollection(dirtyExecutions)) {
            this.log.debug("dirtyExecutions is empty.");
            return;
        }
        WfDBUtils.executeBatchDeleteByIn((String)"delete from t_wf_execution where fid in (?);", dirtyExecutions, (Integer)500, (boolean)false);
    }

    private void filterFinishedProcInstIds(Set<Long> finishedProcInstIds) {
        QFilter[] qs = new QFilter[]{new QFilter("id", "in", finishedProcInstIds)};
        try (DataSet ds = ORM.create().queryDataSet("wf.ops.filterFinishedProcInstIds", "wf_execution", "id", qs, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("id");
                finishedProcInstIds.remove(id);
            }
        }
        this.log.debug(String.format("after filter  ret:%s", WfUtils.listToString(finishedProcInstIds, (String)",")));
    }

    private List<Object> findDirtyExecutions(Set<Long> finishedProcInstIds) {
        ArrayList<Object> ret = new ArrayList<Object>();
        QFilter[] qs = new QFilter[]{new QFilter("processInstanceId", "in", finishedProcInstIds), new QFilter("scope", "=", (Object)Character.valueOf('0'))};
        try (DataSet ds = ORM.create().queryDataSet("wf.ops.findDirtyExecutions", "wf_execution", "id", qs, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("id");
                ret.add(id);
            }
        }
        this.log.debug(String.format(" delete excution ids:%s", WfUtils.listToString(ret, (String)",")));
        return ret;
    }

    private Set<Long> findFinishedProcInstIds(String procdefs, String procInstanceIds, int count) {
        Collection ids;
        HashSet<Long> ret = new HashSet<Long>();
        QFilter[] qs = null;
        long lastId = this.getLastProcInstId();
        if (WfUtils.isNotEmpty((String)procdefs)) {
            ids = WfUtils.stringToCollection((String)procdefs, (String)",");
            qs = new QFilter[]{new QFilter("id", ">=", (Object)lastId), new QFilter("processDefinitionId", "in", (Object)ids), new QFilter("endTime", "is not null", null)};
        } else if (WfUtils.isNotEmpty((String)procInstanceIds)) {
            ids = WfUtils.stringToCollection((String)procInstanceIds, (String)",");
            qs = new QFilter[]{new QFilter("id", "in", (Object)ids), new QFilter("endTime", "is not null", null)};
        }
        if (qs == null) {
            return ret;
        }
        try (DataSet ds = ORM.create().queryDataSet("wf.ops.findFinishedProcInstIds", "wf_hiprocinst", "id", qs, "id", count);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("id");
                ret.add(id);
                lastId = id;
            }
        }
        if (WfUtils.isNotEmpty((Long)lastId)) {
            this.putLastProcInstId(lastId);
        }
        this.log.debug(String.format("lastid:%s  ret:%s", lastId, WfUtils.listToString(ret, (String)",")));
        return ret;
    }

    private long getLastProcInstId() {
        String val;
        DistributeSessionlessCache disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
        String key = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "wf", "deleteDirtyExecutionLastProcId");
        if (disCache != null && (val = (String)disCache.get(key)) != null) {
            return Long.parseLong(val);
        }
        return 0L;
    }

    private void putLastProcInstId(Long lastId) {
        DistributeSessionlessCache disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
        if (disCache != null) {
            String key = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "wf", "deleteDirtyExecutionLastProcId");
            disCache.put(key, (Object)String.valueOf(lastId));
        }
    }

    private String getDeleteProcInstanceIds(Map<String, Object> map) {
        if (WfUtils.isNotEmptyForMap(map)) {
            try {
                if (map.containsKey(PROCINSTANCEIDS)) {
                    return String.valueOf(map.get(PROCINSTANCEIDS));
                }
            }
            catch (Exception e) {
                this.log.debug("error count.");
            }
        }
        return null;
    }

    private String getDeleteProcdefs(Map<String, Object> map) {
        if (WfUtils.isNotEmptyForMap(map)) {
            try {
                if (map.containsKey(PROCDEFIDS)) {
                    return String.valueOf(map.get(PROCDEFIDS));
                }
            }
            catch (Exception e) {
                this.log.debug("error count.");
            }
        }
        return null;
    }

    private int getEveryDeleteData(Map<String, Object> map) {
        if (WfUtils.isNotEmptyForMap(map)) {
            try {
                if (map.containsKey(DELETECOUNT)) {
                    return Integer.parseInt(String.valueOf(map.get(DELETECOUNT)));
                }
            }
            catch (Exception e) {
                this.log.debug("error count.");
            }
        }
        return 1000;
    }
}

